/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import java.time.Duration;
import java.util.function.Function;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.groups.ComponentIdGenerator;
import org.apache.nifi.groups.ComponentScheduler;
import org.apache.nifi.groups.PropertyDecryptor;
import org.apache.nifi.groups.ScheduledStateChangeListener;

public class FlowSynchronizationOptions {
    private final ComponentIdGenerator componentIdGenerator;
    private final Function<VersionedComponent, String> componentComparisonIdLookup;
    private final ComponentScheduler componentScheduler;
    private final PropertyDecryptor propertyDecryptor;
    private final boolean ignoreLocalModifications;
    private final boolean updateSettings;
    private final boolean updateDescendantVersionedFlows;
    private final boolean updateGroupVersionControlSnapshot;
    private final boolean updateRpgUrls;
    private final Duration componentStopTimeout;
    private final ComponentStopTimeoutAction timeoutAction;
    private final ScheduledStateChangeListener scheduledStateChangeListener;
    private final String topLevelGroupId;

    private FlowSynchronizationOptions(Builder builder) {
        this.componentIdGenerator = builder.componentIdGenerator;
        this.componentComparisonIdLookup = builder.componentComparisonIdLookup;
        this.componentScheduler = builder.componentScheduler;
        this.propertyDecryptor = builder.propertyDecryptor;
        this.ignoreLocalModifications = builder.ignoreLocalModifications;
        this.updateSettings = builder.updateSettings;
        this.updateDescendantVersionedFlows = builder.updateDescendantVersionedFlows;
        this.updateGroupVersionControlSnapshot = builder.updateGroupVersionControlSnapshot;
        this.updateRpgUrls = builder.updateRpgUrls;
        this.componentStopTimeout = builder.componentStopTimeout;
        this.timeoutAction = builder.timeoutAction;
        this.scheduledStateChangeListener = builder.scheduledStateChangeListener;
        this.topLevelGroupId = builder.topLevelGroupId;
    }

    public ComponentIdGenerator getComponentIdGenerator() {
        return this.componentIdGenerator;
    }

    public Function<VersionedComponent, String> getComponentComparisonIdLookup() {
        return this.componentComparisonIdLookup;
    }

    public ComponentScheduler getComponentScheduler() {
        return this.componentScheduler;
    }

    public boolean isIgnoreLocalModifications() {
        return this.ignoreLocalModifications;
    }

    public boolean isUpdateSettings() {
        return this.updateSettings;
    }

    public boolean isUpdateDescendantVersionedFlows() {
        return this.updateDescendantVersionedFlows;
    }

    public boolean isUpdateGroupVersionControlSnapshot() {
        return this.updateGroupVersionControlSnapshot;
    }

    public boolean isUpdateRpgUrls() {
        return this.updateRpgUrls;
    }

    public PropertyDecryptor getPropertyDecryptor() {
        return this.propertyDecryptor;
    }

    public Duration getComponentStopTimeout() {
        return this.componentStopTimeout;
    }

    public ComponentStopTimeoutAction getComponentStopTimeoutAction() {
        return this.timeoutAction;
    }

    public ScheduledStateChangeListener getScheduledStateChangeListener() {
        return this.scheduledStateChangeListener;
    }

    public String getTopLevelGroupId() {
        return this.topLevelGroupId;
    }

    public static class Builder {
        private ComponentIdGenerator componentIdGenerator;
        private Function<VersionedComponent, String> componentComparisonIdLookup;
        private ComponentScheduler componentScheduler;
        private boolean ignoreLocalModifications = false;
        private boolean updateSettings = true;
        private boolean updateDescendantVersionedFlows = true;
        private boolean updateGroupVersionControlSnapshot = true;
        private boolean updateRpgUrls = false;
        private ScheduledStateChangeListener scheduledStateChangeListener;
        private PropertyDecryptor propertyDecryptor = value -> value;
        private Duration componentStopTimeout = Duration.ofSeconds(30L);
        private ComponentStopTimeoutAction timeoutAction = ComponentStopTimeoutAction.THROW_TIMEOUT_EXCEPTION;
        private String topLevelGroupId;

        public Builder componentIdGenerator(ComponentIdGenerator componentIdGenerator) {
            this.componentIdGenerator = componentIdGenerator;
            return this;
        }

        public Builder componentComparisonIdLookup(Function<VersionedComponent, String> idLookup) {
            this.componentComparisonIdLookup = idLookup;
            return this;
        }

        public Builder componentScheduler(ComponentScheduler componentScheduler) {
            this.componentScheduler = componentScheduler;
            return this;
        }

        public Builder ignoreLocalModifications(boolean ignore) {
            this.ignoreLocalModifications = ignore;
            return this;
        }

        public Builder updateGroupSettings(boolean updateSettings) {
            this.updateSettings = updateSettings;
            return this;
        }

        public Builder updateDescendantVersionedFlows(boolean updateDescendantVersionedFlows) {
            this.updateDescendantVersionedFlows = updateDescendantVersionedFlows;
            return this;
        }

        public Builder updateGroupVersionControlSnapshot(boolean updateGroupVersionControlSnapshot) {
            this.updateGroupVersionControlSnapshot = updateGroupVersionControlSnapshot;
            return this;
        }

        public Builder updateRpgUrls(boolean updateRpgUrls) {
            this.updateRpgUrls = updateRpgUrls;
            return this;
        }

        public Builder propertyDecryptor(PropertyDecryptor decryptor) {
            this.propertyDecryptor = decryptor;
            return this;
        }

        public Builder componentStopTimeout(Duration duration) {
            this.componentStopTimeout = duration;
            return this;
        }

        public Builder componentStopTimeoutAction(ComponentStopTimeoutAction action) {
            this.timeoutAction = action;
            return this;
        }

        public Builder scheduledStateChangeListener(ScheduledStateChangeListener listener) {
            this.scheduledStateChangeListener = listener;
            return this;
        }

        public FlowSynchronizationOptions build() {
            if (this.componentIdGenerator == null) {
                throw new IllegalStateException("Must set Component ID Generator");
            }
            if (this.componentComparisonIdLookup == null) {
                throw new IllegalStateException("Must set the Component Comparison ID Lookup");
            }
            if (this.componentScheduler == null) {
                throw new IllegalStateException("Must set Component Scheduler");
            }
            if (this.scheduledStateChangeListener == null) {
                this.scheduledStateChangeListener = ScheduledStateChangeListener.EMPTY;
            }
            return new FlowSynchronizationOptions(this);
        }

        public Builder topLevelGroupId(String topLevelGroupId) {
            this.topLevelGroupId = topLevelGroupId;
            return this;
        }

        public static Builder from(FlowSynchronizationOptions options) {
            Builder builder = new Builder();
            builder.componentIdGenerator = options.getComponentIdGenerator();
            builder.componentComparisonIdLookup = options.getComponentComparisonIdLookup();
            builder.componentScheduler = options.getComponentScheduler();
            builder.ignoreLocalModifications = options.isIgnoreLocalModifications();
            builder.updateSettings = options.isUpdateSettings();
            builder.updateDescendantVersionedFlows = options.isUpdateDescendantVersionedFlows();
            builder.updateGroupVersionControlSnapshot = options.isUpdateGroupVersionControlSnapshot();
            builder.updateRpgUrls = options.isUpdateRpgUrls();
            builder.propertyDecryptor = options.getPropertyDecryptor();
            builder.componentStopTimeout = options.getComponentStopTimeout();
            builder.timeoutAction = options.getComponentStopTimeoutAction();
            builder.scheduledStateChangeListener = options.getScheduledStateChangeListener();
            builder.topLevelGroupId = options.getTopLevelGroupId();
            return builder;
        }
    }

    public static enum ComponentStopTimeoutAction {
        THROW_TIMEOUT_EXCEPTION,
        TERMINATE;

    }
}

