/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.registry.flow.BucketLocation;
import org.apache.nifi.registry.flow.FlowLocation;
import org.apache.nifi.registry.flow.FlowRegistryBranch;
import org.apache.nifi.registry.flow.FlowRegistryBucket;
import org.apache.nifi.registry.flow.FlowRegistryClientConfigurationContext;
import org.apache.nifi.registry.flow.FlowRegistryClientInitializationContext;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.FlowVersionLocation;
import org.apache.nifi.registry.flow.RegisterAction;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;

public interface FlowRegistryClient
extends ConfigurableComponent {
    public static final String DEFAULT_BRANCH_NAME = "main";

    public void initialize(FlowRegistryClientInitializationContext var1);

    public boolean isStorageLocationApplicable(FlowRegistryClientConfigurationContext var1, String var2);

    default public boolean isBranchingSupported(FlowRegistryClientConfigurationContext context) {
        return false;
    }

    default public Set<FlowRegistryBranch> getBranches(FlowRegistryClientConfigurationContext context) throws FlowRegistryException, IOException {
        return Set.of(this.getDefaultBranch(context));
    }

    default public FlowRegistryBranch getDefaultBranch(FlowRegistryClientConfigurationContext context) throws FlowRegistryException, IOException {
        FlowRegistryBranch branch = new FlowRegistryBranch();
        branch.setName(DEFAULT_BRANCH_NAME);
        return branch;
    }

    public Set<FlowRegistryBucket> getBuckets(FlowRegistryClientConfigurationContext var1, String var2) throws FlowRegistryException, IOException;

    public FlowRegistryBucket getBucket(FlowRegistryClientConfigurationContext var1, BucketLocation var2) throws FlowRegistryException, IOException;

    public RegisteredFlow registerFlow(FlowRegistryClientConfigurationContext var1, RegisteredFlow var2) throws FlowRegistryException, IOException;

    public RegisteredFlow deregisterFlow(FlowRegistryClientConfigurationContext var1, FlowLocation var2) throws FlowRegistryException, IOException;

    public RegisteredFlow getFlow(FlowRegistryClientConfigurationContext var1, FlowLocation var2) throws FlowRegistryException, IOException;

    public Set<RegisteredFlow> getFlows(FlowRegistryClientConfigurationContext var1, BucketLocation var2) throws FlowRegistryException, IOException;

    public RegisteredFlowSnapshot getFlowContents(FlowRegistryClientConfigurationContext var1, FlowVersionLocation var2) throws FlowRegistryException, IOException;

    public RegisteredFlowSnapshot registerFlowSnapshot(FlowRegistryClientConfigurationContext var1, RegisteredFlowSnapshot var2, RegisterAction var3) throws FlowRegistryException, IOException;

    public Set<RegisteredFlowSnapshotMetadata> getFlowVersions(FlowRegistryClientConfigurationContext var1, FlowLocation var2) throws FlowRegistryException, IOException;

    public Optional<String> getLatestVersion(FlowRegistryClientConfigurationContext var1, FlowLocation var2) throws FlowRegistryException, IOException;

    default public String generateFlowId(String flowName) {
        return UUID.randomUUID().toString();
    }
}

