/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.nar.NarManifestEntry;

public class NarManifest {
    private final String group;
    private final String id;
    private final String version;
    private final String dependencyGroup;
    private final String dependencyId;
    private final String dependencyVersion;
    private final String buildTag;
    private final String buildRevision;
    private final String buildBranch;
    private final String buildTimestamp;
    private final String buildJdk;
    private final String builtBy;
    private final String createdBy;

    private NarManifest(Builder builder) {
        this.group = Objects.requireNonNull(builder.group);
        this.id = Objects.requireNonNull(builder.id);
        this.version = Objects.requireNonNull(builder.version);
        this.dependencyGroup = builder.dependencyGroup;
        this.dependencyId = builder.dependencyId;
        this.dependencyVersion = builder.dependencyVersion;
        this.buildTag = builder.buildTag;
        this.buildRevision = builder.buildRevision;
        this.buildBranch = builder.buildBranch;
        this.buildTimestamp = builder.buildTimestamp;
        this.buildJdk = builder.buildJdk;
        this.builtBy = builder.builtBy;
        this.createdBy = builder.createdBy;
    }

    public String getGroup() {
        return this.group;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDependencyGroup() {
        return this.dependencyGroup;
    }

    public String getDependencyId() {
        return this.dependencyId;
    }

    public String getDependencyVersion() {
        return this.dependencyVersion;
    }

    public String getBuildTag() {
        return this.buildTag;
    }

    public String getBuildRevision() {
        return this.buildRevision;
    }

    public String getBuildBranch() {
        return this.buildBranch;
    }

    public String getBuildTimestamp() {
        return this.buildTimestamp;
    }

    public String getBuildJdk() {
        return this.buildJdk;
    }

    public String getBuiltBy() {
        return this.builtBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public BundleCoordinate getCoordinate() {
        return new BundleCoordinate(this.group, this.id, this.version);
    }

    public BundleCoordinate getDependencyCoordinate() {
        if (this.dependencyId == null) {
            return null;
        }
        return new BundleCoordinate(this.dependencyGroup, this.dependencyId, this.dependencyVersion);
    }

    public static NarManifest fromNarFile(File narFile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(narFile);){
            NarManifest narManifest = NarManifest.fromInputStream(inputStream);
            return narManifest;
        }
    }

    static NarManifest fromInputStream(InputStream narInputStream) throws IOException {
        try (JarInputStream jarInputStream = new JarInputStream(narInputStream);){
            Manifest manifest = jarInputStream.getManifest();
            NarManifest narManifest = NarManifest.fromManifest(manifest);
            return narManifest;
        }
    }

    static NarManifest fromManifest(Manifest manifest) {
        if (manifest == null) {
            throw new IllegalArgumentException("NAR content is missing required META-INF/MANIFEST entry");
        }
        Attributes attributes = manifest.getMainAttributes();
        return NarManifest.builder().group(attributes.getValue(NarManifestEntry.NAR_GROUP.getEntryName())).id(attributes.getValue(NarManifestEntry.NAR_ID.getEntryName())).version(attributes.getValue(NarManifestEntry.NAR_VERSION.getEntryName())).dependencyGroup(attributes.getValue(NarManifestEntry.NAR_DEPENDENCY_GROUP.getEntryName())).dependencyId(attributes.getValue(NarManifestEntry.NAR_DEPENDENCY_ID.getEntryName())).dependencyVersion(attributes.getValue(NarManifestEntry.NAR_DEPENDENCY_VERSION.getEntryName())).buildTag(attributes.getValue(NarManifestEntry.BUILD_TAG.getEntryName())).buildRevision(attributes.getValue(NarManifestEntry.BUILD_REVISION.getEntryName())).buildBranch(attributes.getValue(NarManifestEntry.BUILD_BRANCH.getEntryName())).buildTimestamp(attributes.getValue(NarManifestEntry.BUILD_TIMESTAMP.getEntryName())).buildJdk(attributes.getValue(NarManifestEntry.BUILD_JDK.getEntryName())).builtBy(attributes.getValue(NarManifestEntry.BUILT_BY.getEntryName())).createdBy(attributes.getValue(NarManifestEntry.CREATED_BY.getEntryName())).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String group;
        private String id;
        private String version;
        private String dependencyGroup;
        private String dependencyId;
        private String dependencyVersion;
        private String buildTag;
        private String buildRevision;
        private String buildBranch;
        private String buildTimestamp;
        private String buildJdk;
        private String builtBy;
        private String createdBy;

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder dependencyGroup(String dependencyGroup) {
            this.dependencyGroup = dependencyGroup;
            return this;
        }

        public Builder dependencyId(String dependencyId) {
            this.dependencyId = dependencyId;
            return this;
        }

        public Builder dependencyVersion(String dependencyVersion) {
            this.dependencyVersion = dependencyVersion;
            return this;
        }

        public Builder buildTag(String buildTag) {
            this.buildTag = buildTag;
            return this;
        }

        public Builder buildRevision(String buildRevision) {
            this.buildRevision = buildRevision;
            return this;
        }

        public Builder buildBranch(String buildBranch) {
            this.buildBranch = buildBranch;
            return this;
        }

        public Builder buildTimestamp(String buildTimestamp) {
            this.buildTimestamp = buildTimestamp;
            return this;
        }

        public Builder buildJdk(String buildJdk) {
            this.buildJdk = buildJdk;
            return this;
        }

        public Builder builtBy(String builtBy) {
            this.builtBy = builtBy;
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public NarManifest build() {
            return new NarManifest(this);
        }
    }
}

