/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.aggregator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.olingo.odata2.api.edm.EdmComplexType;
import org.apache.olingo.odata2.api.edm.EdmConcurrencyMode;
import org.apache.olingo.odata2.api.edm.EdmCustomizableFeedMappings;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.apache.olingo.odata2.core.ep.aggregator.EntityComplexPropertyInfo;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;
import org.apache.olingo.odata2.core.ep.aggregator.NavigationPropertyInfo;

public class EntityInfoAggregator {
    private static final Set<String> SYN_TARGET_PATHS = new HashSet<String>(Arrays.asList("SyndicationAuthorName", "SyndicationAuthorEmail", "SyndicationAuthorUri", "SyndicationPublished", "SyndicationRights", "SyndicationTitle", "SyndicationUpdated", "SyndicationContributorName", "SyndicationContributorEmail", "SyndicationContributorUri", "SyndicationSource", "SyndicationSummary"));
    private Map<String, EntityPropertyInfo> propertyInfo = new HashMap<String, EntityPropertyInfo>();
    private Map<String, NavigationPropertyInfo> navigationPropertyInfos = new HashMap<String, NavigationPropertyInfo>();
    private List<EntityPropertyInfo> keyPropertyInfos;
    private List<String> etagPropertyNames = new ArrayList<String>();
    private List<String> propertyNames;
    private List<String> navigationPropertyNames;
    private List<String> selectedPropertyNames;
    private List<String> selectedNavigationPropertyNames;
    private List<String> expandedNavigationPropertyNames;
    private Map<String, EntityPropertyInfo> targetPath2EntityPropertyInfo = new HashMap<String, EntityPropertyInfo>();
    private List<String> noneSyndicationTargetPaths = new ArrayList<String>();
    private boolean isDefaultEntityContainer;
    private String entitySetName;
    private String entityContainerName;
    private EdmEntityType entityType;
    private EdmEntitySet entitySet;

    private EntityInfoAggregator() {
    }

    public static EntityInfoAggregator create(EdmEntitySet entitySet, ExpandSelectTreeNode expandSelectTree) throws EntityProviderException {
        EntityInfoAggregator eia = new EntityInfoAggregator();
        eia.initialize(entitySet, expandSelectTree);
        return eia;
    }

    public static EntityInfoAggregator create(EdmEntitySet entitySet) throws EntityProviderException {
        EntityInfoAggregator eia = new EntityInfoAggregator();
        eia.initialize(entitySet, null);
        return eia;
    }

    public static EntityPropertyInfo create(EdmProperty property) throws EntityProviderException {
        try {
            EntityInfoAggregator eia = new EntityInfoAggregator();
            return eia.createEntityPropertyInfo(property);
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    public static Map<String, EntityPropertyInfo> create(EdmComplexType complexType) throws EntityProviderException {
        try {
            EntityInfoAggregator entityInfo = new EntityInfoAggregator();
            return entityInfo.createPropertyInfoObjects((EdmStructuralType)complexType, complexType.getPropertyNames());
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    public static EntityPropertyInfo create(EdmFunctionImport functionImport) throws EntityProviderException {
        try {
            EntityInfoAggregator eia = new EntityInfoAggregator();
            return eia.createEntityPropertyInfo(functionImport, functionImport.getReturnType().getType());
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    public EdmEntitySet getEntitySet() {
        return this.entitySet;
    }

    public String getEntitySetName() {
        return this.entitySetName;
    }

    public boolean isDefaultEntityContainer() {
        return this.isDefaultEntityContainer;
    }

    public EntityPropertyInfo getTargetPathInfo(String targetPath) {
        return this.targetPath2EntityPropertyInfo.get(targetPath);
    }

    public EdmEntityType getEntityType() {
        return this.entityType;
    }

    public String getEntityContainerName() {
        return this.entityContainerName;
    }

    public Collection<String> getTargetPathNames() {
        return Collections.unmodifiableCollection(this.targetPath2EntityPropertyInfo.keySet());
    }

    public List<String> getNoneSyndicationTargetPathNames() {
        return Collections.unmodifiableList(this.noneSyndicationTargetPaths);
    }

    public List<String> getNavigationPropertyNames() throws EntityProviderException {
        return Collections.unmodifiableList(this.navigationPropertyNames);
    }

    public List<String> getPropertyNames() throws EntityProviderException {
        return Collections.unmodifiableList(this.propertyNames);
    }

    public List<String> getSelectedPropertyNames() throws EntityProviderException {
        return Collections.unmodifiableList(this.selectedPropertyNames);
    }

    public List<String> getSelectedNavigationPropertyNames() throws EntityProviderException {
        return Collections.unmodifiableList(this.selectedNavigationPropertyNames);
    }

    public Collection<EntityPropertyInfo> getPropertyInfos() {
        return Collections.unmodifiableCollection(this.propertyInfo.values());
    }

    public EntityPropertyInfo getPropertyInfo(String name) {
        return this.propertyInfo.get(name);
    }

    public Collection<EntityPropertyInfo> getETagPropertyInfos() {
        ArrayList<EntityPropertyInfo> keyProperties = new ArrayList<EntityPropertyInfo>();
        for (String etagPropertyName : this.etagPropertyNames) {
            EntityPropertyInfo e = this.propertyInfo.get(etagPropertyName);
            keyProperties.add(e);
        }
        return keyProperties;
    }

    public List<EntityPropertyInfo> getKeyPropertyInfos() throws EntityProviderException {
        if (this.keyPropertyInfos == null) {
            try {
                this.keyPropertyInfos = new ArrayList<EntityPropertyInfo>();
                for (String keyPropertyName : this.entityType.getKeyPropertyNames()) {
                    this.keyPropertyInfos.add(this.propertyInfo.get(keyPropertyName));
                }
            }
            catch (EdmException e) {
                throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
            }
        }
        return this.keyPropertyInfos;
    }

    public NavigationPropertyInfo getNavigationPropertyInfo(String name) {
        return this.navigationPropertyInfos.get(name);
    }

    private void initialize(EdmEntitySet entitySet, ExpandSelectTreeNode expandSelectTree) throws EntityProviderException {
        try {
            this.entitySet = entitySet;
            this.entityType = entitySet.getEntityType();
            this.entitySetName = entitySet.getName();
            this.isDefaultEntityContainer = entitySet.getEntityContainer().isDefaultEntityContainer();
            this.entityContainerName = entitySet.getEntityContainer().getName();
            this.propertyNames = this.entityType.getPropertyNames();
            this.navigationPropertyNames = this.entityType.getNavigationPropertyNames();
            this.propertyInfo = this.createPropertyInfoObjects((EdmStructuralType)this.entityType, this.propertyNames);
            this.navigationPropertyInfos = this.createNavigationInfoObjects((EdmStructuralType)this.entityType, this.navigationPropertyNames);
            this.selectedPropertyNames = this.propertyNames;
            this.selectedNavigationPropertyNames = this.navigationPropertyNames;
            this.expandedNavigationPropertyNames = new ArrayList<String>();
            if (expandSelectTree != null && !expandSelectTree.isAll()) {
                this.selectedPropertyNames = new ArrayList<String>();
                this.selectedNavigationPropertyNames = new ArrayList<String>();
                for (Object property : expandSelectTree.getProperties()) {
                    this.selectedPropertyNames.add(property.getName());
                }
                for (Object property : expandSelectTree.getLinks().keySet()) {
                    this.selectedNavigationPropertyNames.add((String)property);
                    if (expandSelectTree.getLinks().get(property) == null) continue;
                    this.expandedNavigationPropertyNames.add((String)property);
                }
            } else if (expandSelectTree != null) {
                for (String property : expandSelectTree.getLinks().keySet()) {
                    if (expandSelectTree.getLinks().get(property) == null) continue;
                    this.expandedNavigationPropertyNames.add(property);
                }
            }
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private Map<String, EntityPropertyInfo> createPropertyInfoObjects(EdmStructuralType type, List<String> propertyNames) throws EntityProviderException {
        try {
            HashMap<String, EntityPropertyInfo> infos = new HashMap<String, EntityPropertyInfo>();
            for (String propertyName : propertyNames) {
                EdmProperty property = (EdmProperty)type.getProperty(propertyName);
                this.checkETagRelevant(property);
                EntityPropertyInfo info = this.createEntityPropertyInfo(property);
                infos.put(info.getName(), info);
                this.checkTargetPathInfo(property, info);
            }
            return infos;
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private Map<String, NavigationPropertyInfo> createNavigationInfoObjects(EdmStructuralType type, List<String> propertyNames) throws EntityProviderException {
        try {
            HashMap<String, NavigationPropertyInfo> infos = new HashMap<String, NavigationPropertyInfo>();
            for (String propertyName : propertyNames) {
                EdmNavigationProperty navProperty = (EdmNavigationProperty)type.getProperty(propertyName);
                NavigationPropertyInfo info = NavigationPropertyInfo.create(navProperty);
                infos.put(propertyName, info);
            }
            return infos;
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private EntityPropertyInfo createEntityPropertyInfo(EdmProperty property) throws EdmException, EntityProviderException {
        EdmType type = property.getType();
        if (type instanceof EdmSimpleType) {
            return EntityPropertyInfo.create(property);
        }
        if (type instanceof EdmComplexType) {
            EdmComplexType complex = (EdmComplexType)type;
            Map<String, EntityPropertyInfo> recursiveInfos = this.createPropertyInfoObjects((EdmStructuralType)complex, complex.getPropertyNames());
            return EntityComplexPropertyInfo.create(property, complex.getPropertyNames(), recursiveInfos);
        }
        throw new EntityProviderException(EntityProviderException.UNSUPPORTED_PROPERTY_TYPE);
    }

    private EntityPropertyInfo createEntityPropertyInfo(EdmFunctionImport functionImport, EdmType type) throws EdmException, EntityProviderException {
        EntityPropertyInfo epi;
        if (type.getKind() == EdmTypeKind.COMPLEX) {
            EdmComplexType complex = (EdmComplexType)type;
            Map<String, EntityPropertyInfo> eia = EntityInfoAggregator.create(complex);
            ArrayList<EntityPropertyInfo> childEntityInfoList = new ArrayList<EntityPropertyInfo>();
            for (String propertyName : complex.getPropertyNames()) {
                childEntityInfoList.add(eia.get(propertyName));
            }
            epi = new EntityComplexPropertyInfo(functionImport.getName(), type, null, null, childEntityInfoList);
        } else if (type.getKind() == EdmTypeKind.SIMPLE) {
            epi = new EntityPropertyInfo(functionImport.getName(), type, null, null, null, null);
        } else {
            throw new EntityProviderException(EntityProviderException.UNSUPPORTED_PROPERTY_TYPE.addContent(new Object[]{type.getKind()}));
        }
        return epi;
    }

    private void checkETagRelevant(EdmProperty edmProperty) throws EntityProviderException {
        try {
            if (edmProperty.getFacets() != null && edmProperty.getFacets().getConcurrencyMode() == EdmConcurrencyMode.Fixed) {
                this.etagPropertyNames.add(edmProperty.getName());
            }
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void checkTargetPathInfo(EdmProperty property, EntityPropertyInfo propertyInfo) throws EntityProviderException {
        try {
            EdmCustomizableFeedMappings customizableFeedMappings = property.getCustomizableFeedMappings();
            if (customizableFeedMappings != null) {
                String targetPath = customizableFeedMappings.getFcTargetPath();
                this.targetPath2EntityPropertyInfo.put(targetPath, propertyInfo);
                if (!SYN_TARGET_PATHS.contains(targetPath)) {
                    this.noneSyndicationTargetPaths.add(targetPath);
                }
            }
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    public List<String> getExpandedNavigationPropertyNames() {
        return this.expandedNavigationPropertyNames;
    }
}

