/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.net.URI;
import java.util.Collection;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.EdmMetadataRequest;
import org.apache.olingo.client.api.communication.request.retrieve.XMLMetadataRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractMetadataRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.edm.Edm;

class EdmMetadataRequestImpl
extends AbstractMetadataRequestImpl<Edm>
implements EdmMetadataRequest {
    private final String serviceRoot;
    private EdmMetadataResponseImpl privateResponse;

    EdmMetadataRequestImpl(ODataClient odataClient, String serviceRoot, URI uri) {
        super(odataClient, uri);
        this.serviceRoot = serviceRoot;
    }

    private EdmMetadataResponseImpl getPrivateResponse() {
        if (this.privateResponse == null) {
            XMLMetadataRequest request = this.odataClient.getRetrieveRequestFactory().getXMLMetadataRequest(this.serviceRoot);
            if (this.getPrefer() != null) {
                request.setPrefer(this.getPrefer());
            }
            if (this.getIfMatch() != null) {
                request.setIfMatch(this.getIfMatch());
            }
            if (this.getIfNoneMatch() != null) {
                request.setIfNoneMatch(this.getIfNoneMatch());
            }
            if (this.getHeader() != null) {
                for (String key : this.getHeaderNames()) {
                    request.addCustomHeader(key, this.odataHeaders.getHeader(key));
                }
            }
            ODataRetrieveResponse xmlMetadataResponse = (ODataRetrieveResponse)request.execute();
            this.privateResponse = new EdmMetadataResponseImpl(this.odataClient, this.httpClient, xmlMetadataResponse);
        }
        return this.privateResponse;
    }

    public XMLMetadata getXMLMetadata() {
        return this.getPrivateResponse().getXMLMetadata();
    }

    @Override
    public ODataRetrieveResponse<Edm> execute() {
        return this.getPrivateResponse();
    }

    private class EdmMetadataResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private final ODataRetrieveResponse<XMLMetadata> xmlMetadataResponse;
        private XMLMetadata metadata;

        private EdmMetadataResponseImpl(ODataClient odataClient, HttpClient httpClient, ODataRetrieveResponse<XMLMetadata> xmlMetadataResponse) {
            super(odataClient, httpClient, null);
            this.metadata = null;
            this.xmlMetadataResponse = xmlMetadataResponse;
        }

        @Override
        public void close() {
            super.close();
            this.xmlMetadataResponse.close();
        }

        @Override
        public int getStatusCode() {
            return this.xmlMetadataResponse.getStatusCode();
        }

        @Override
        public String getStatusMessage() {
            return this.xmlMetadataResponse.getStatusMessage();
        }

        @Override
        public Collection<String> getHeaderNames() {
            return this.xmlMetadataResponse.getHeaderNames();
        }

        @Override
        public Collection<String> getHeader(String name) {
            return this.xmlMetadataResponse.getHeader(name);
        }

        public XMLMetadata getXMLMetadata() {
            if (this.metadata == null) {
                try {
                    this.metadata = (XMLMetadata)this.xmlMetadataResponse.getBody();
                }
                finally {
                    this.close();
                }
            }
            return this.metadata;
        }

        public Edm getBody() {
            return this.odataClient.getReader().readMetadata(this.getXMLMetadata().getSchemaByNsOrAlias());
        }
    }
}

