/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.olingo.client.api.EdmEnabledODataClient;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.ComplexType;
import org.apache.olingo.ext.proxy.api.EntityType;
import org.apache.olingo.ext.proxy.api.annotations.EntitySet;
import org.apache.olingo.ext.proxy.api.annotations.Namespace;
import org.apache.olingo.ext.proxy.api.annotations.Singleton;
import org.apache.olingo.ext.proxy.commons.ComplexInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.context.AttachedEntityStatus;
import org.apache.olingo.ext.proxy.context.Context;
import org.apache.olingo.ext.proxy.context.EntityContext;
import org.apache.olingo.ext.proxy.utils.CoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractInvocationHandler
implements InvocationHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractInvocationHandler.class);
    protected AbstractService<?> service;

    protected AbstractInvocationHandler(AbstractService<?> service) {
        this.service = service;
    }

    protected EdmEnabledODataClient getClient() {
        return this.service.getClient();
    }

    protected Context getContext() {
        return this.service.getContext();
    }

    protected boolean isSelfMethod(Method method) {
        Method[] selfMethods = this.getClass().getMethods();
        boolean result = false;
        for (int i = 0; i < selfMethods.length && !result; ++i) {
            result = method.getName().equals(selfMethods[i].getName()) && Arrays.equals(method.getParameterTypes(), selfMethods[i].getParameterTypes());
        }
        return result;
    }

    protected Object invokeSelfMethod(Method method, Object[] args) throws Throwable {
        try {
            return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
        }
        catch (UndeclaredThrowableException e) {
            throw e.getCause();
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    protected ComplexType<?> getComplex(String name, ClientValue value, Class<?> ref, EntityInvocationHandler handler, URI baseURI, boolean collectionItem) {
        ComplexInvocationHandler complexHandler;
        URIBuilder targetURI = collectionItem ? null : (baseURI == null ? null : this.getClient().newURIBuilder(baseURI.toASCIIString()).appendPropertySegment(name));
        Class<?> actualRef = ref;
        if (value == null) {
            complexHandler = ComplexInvocationHandler.getInstance(actualRef, this.service, targetURI);
        } else {
            actualRef = CoreUtils.getComplexTypeRef(this.service, value);
            complexHandler = ComplexInvocationHandler.getInstance(value.asComplex(), actualRef, this.service, targetURI);
        }
        complexHandler.setEntityHandler(handler);
        ComplexType res = (ComplexType)ComplexType.class.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{actualRef}, (InvocationHandler)complexHandler));
        return res;
    }

    protected boolean isDeleted(EntityInvocationHandler handler) {
        return this.getContext().entityContext().isAttached(handler) && this.getContext().entityContext().getStatus(handler) == AttachedEntityStatus.DELETED || this.getContext().entityContext().getFurtherDeletes().contains(handler.getEntityURI());
    }

    protected <S extends EntityType<?>> void deleteEntity(EntityInvocationHandler handler, URI entitySetURI) {
        URI entityURI;
        ClientEntity template;
        URI baseURI;
        EntityContext entityContext = this.getContext().entityContext();
        URI uRI = baseURI = entitySetURI == null ? handler.getEntitySetURI() : entitySetURI;
        if (baseURI == null) {
            throw new IllegalStateException("Entity base URI not available");
        }
        String name = handler.getUUID().getType().getAnnotation(org.apache.olingo.ext.proxy.api.annotations.EntityType.class).name();
        String namespace = handler.getUUID().getType().getAnnotation(Namespace.class).value();
        if (handler.getEntityURI() == null || handler.getUUID().getKey() == null) {
            template = this.service.getClient().getObjectFactory().newEntity(new FullQualifiedName(namespace, name));
            CoreUtils.addProperties(this.getClient(), handler.getPropertyChanges(), template);
            Object key = CoreUtils.getKey(this.getClient(), handler, handler.getUUID().getType(), template);
            entityURI = CoreUtils.buildEditLink(this.getClient(), baseURI.toASCIIString(), key).build();
            template.setEditLink(entityURI);
        } else {
            entityURI = handler.getEntityURI();
            template = handler.getEntity();
        }
        if (entityContext.isAttached(handler)) {
            entityContext.addFurtherDeletes(entityURI);
        } else {
            if (handler.getUUID().getKey() == null) {
                handler.updateEntityUUID(baseURI, handler.getUUID().getType(), template);
            } else {
                handler.updateUUID(baseURI, handler.getUUID().getType(), handler.getUUID().getKey());
            }
            entityContext.attach(handler, AttachedEntityStatus.DELETED, true);
        }
    }

    protected static URIBuilder buildEntitySetURI(Class<?> ref, AbstractService<?> service) {
        Annotation ann = ref.getAnnotation(EntitySet.class);
        String entitySetName = ann instanceof EntitySet ? ((EntitySet)EntitySet.class.cast(ann)).name() : ((ann = ref.getAnnotation(Singleton.class)) instanceof Singleton ? ((Singleton)Singleton.class.cast(ann)).name() : null);
        return AbstractInvocationHandler.buildEntitySetURI(entitySetName, service);
    }

    protected static URIBuilder buildEntitySetURI(String entitySetName, AbstractService<?> service) {
        URIBuilder uriBuilder = service.getClient().newURIBuilder();
        StringBuilder entitySetSegment = new StringBuilder();
        entitySetSegment.append(entitySetName);
        uriBuilder.appendEntitySetSegment(entitySetSegment.toString());
        return uriBuilder;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

