/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.identifier;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class IdentifierRule {
    public static final Set<String> EMPTY_SET = new HashSet<String>(0);
    public static final String DEFAULT_RULE = "default";
    public static char UNDERSCORE = (char)95;
    private String _name;
    private int _maxLength = 128;
    private boolean _nullable = false;
    private boolean _allowTruncation = false;
    private boolean _allowCompaction = true;
    private boolean _canDelimit = true;
    private boolean _mustDelimit = false;
    private boolean _mustBeginWithLetter = true;
    private boolean _onlyLettersDigitsUnderscores = true;
    private String _specialCharacters = "";
    private Set<String> _reservedWords = null;
    private boolean _delimitReservedWords = false;
    private String _wildcard = "%";

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public void setAllowTruncation(boolean allowTruncation) {
        this._allowTruncation = allowTruncation;
    }

    public boolean isAllowTruncation() {
        return this._allowTruncation;
    }

    public void setNullable(boolean nullable) {
        this._nullable = nullable;
    }

    public boolean isNullable() {
        return this._nullable;
    }

    public void setAllowCompaction(boolean allowCompaction) {
        this._allowCompaction = allowCompaction;
    }

    public boolean getAllowCompaction() {
        return this._allowCompaction;
    }

    public void setCanDelimit(boolean canDelimit) {
        this._canDelimit = canDelimit;
    }

    public boolean getCanDelimit() {
        return this._canDelimit;
    }

    public void setMustDelimit(boolean mustDelimit) {
        this._mustDelimit = mustDelimit;
    }

    public boolean getMustDelimit() {
        return this._mustDelimit;
    }

    public void setMustBeginWithLetter(boolean mustBeginWithLetter) {
        this._mustBeginWithLetter = mustBeginWithLetter;
    }

    public boolean isMustBeginWithLetter() {
        return this._mustBeginWithLetter;
    }

    public void setOnlyLettersDigitsUnderscores(boolean onlyLettersDigitsUnderscores) {
        this._onlyLettersDigitsUnderscores = onlyLettersDigitsUnderscores;
    }

    public boolean isOnlyLettersDigitsUnderscores() {
        return this._onlyLettersDigitsUnderscores;
    }

    public void setReservedWords(Set<String> reservedWords) {
        this._reservedWords = reservedWords;
    }

    public Set<String> getReservedWords() {
        if (this._reservedWords == null) {
            this._reservedWords = new HashSet<String>();
        }
        return this._reservedWords;
    }

    public void setSpecialCharacters(String specialCharacters) {
        this._specialCharacters = specialCharacters;
    }

    public String getSpecialCharacters() {
        return this._specialCharacters;
    }

    public void setDelimitReservedWords(boolean delimitReservedWords) {
        this._delimitReservedWords = delimitReservedWords;
    }

    public boolean getDelimitReservedWords() {
        return this._delimitReservedWords;
    }

    public boolean requiresDelimiters(String identifier) {
        if (this._wildcard.equals(identifier) || "?".equals(identifier) || identifier.endsWith("()")) {
            return false;
        }
        if (this.getMustDelimit()) {
            return true;
        }
        char[] chars = identifier.toCharArray();
        if (this.isMustBeginWithLetter() && !Character.isJavaIdentifierStart(chars[0])) {
            return true;
        }
        for (char ch : chars) {
            if (this.isOnlyLettersDigitsUnderscores() && !Character.isJavaIdentifierPart(ch) && ch != UNDERSCORE) {
                return true;
            }
            if (!StringUtils.contains(this.getSpecialCharacters(), ch)) continue;
            return true;
        }
        return this.getDelimitReservedWords() && this.isReservedWord(identifier);
    }

    public boolean isReservedWord(String identifier) {
        return this._reservedWords.contains(identifier);
    }
}

