/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.managerAPI;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionFactory;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class Connector {
    private ManagerConnection managerConnection;
    private static final Log logger = LogFactory.getLog(Connector.class);

    public ManagerConnection connect(AsteriskSettings asteriskSettings) throws IOException, AuthenticationFailedException, TimeoutException, IllegalStateException {
        this.checkIfAsteriskRunning(asteriskSettings);
        this.makeConnection(asteriskSettings);
        return this.managerConnection;
    }

    private void checkIfAsteriskRunning(AsteriskSettings asteriskSettings) throws UnknownHostException, IOException {
        try (Socket socket = new Socket();){
            socket.setSoTimeout(2000);
            InetSocketAddress asteriskHost = new InetSocketAddress(asteriskSettings.getAsteriskIP(), asteriskSettings.getManagerPortNo());
            socket.connect(asteriskHost, 2000);
        }
    }

    private void makeConnection(AsteriskSettings asteriskSettings) throws IOException, AuthenticationFailedException, TimeoutException, IllegalStateException {
        ManagerConnectionFactory factory = null;
        if (asteriskSettings.getManagerPortNo() == -1) {
            logger.debug("Using default port 5038.");
            factory = new ManagerConnectionFactory(asteriskSettings.getAsteriskIP(), asteriskSettings.getManagerUsername(), asteriskSettings.getManagerPassword());
        } else {
            factory = new ManagerConnectionFactory(asteriskSettings.getAsteriskIP(), asteriskSettings.getManagerPortNo(), asteriskSettings.getManagerUsername(), asteriskSettings.getManagerPassword());
        }
        this.managerConnection = factory.createManagerConnection();
        this.managerConnection.login();
    }
}

