/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.dashboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wicketstuff.dashboard.Dashboard;
import org.wicketstuff.dashboard.Widget;
import org.wicketstuff.dashboard.WidgetComparator;

public class DefaultDashboard
implements Dashboard {
    private static final long serialVersionUID = 1L;
    private String id;
    private String title;
    private int columnCount;
    private List<Widget> widgets;

    public DefaultDashboard(String id, String title) {
        this.id = id;
        this.title = title;
        this.columnCount = 2;
        this.widgets = new ArrayList<Widget>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    @Override
    public List<Widget> getWidgets() {
        return this.widgets;
    }

    @Override
    public List<Widget> getWidgets(int column) {
        ArrayList<Widget> columnWidgets = new ArrayList<Widget>();
        for (Widget widget : this.widgets) {
            if (column != widget.getLocation().getColumn()) continue;
            columnWidgets.add(widget);
        }
        Collections.sort(columnWidgets, new WidgetComparator());
        return columnWidgets;
    }

    @Override
    public Widget getWidget(String widgetId) {
        for (Widget widget : this.widgets) {
            if (!widget.getId().equals(widgetId)) continue;
            return widget;
        }
        return null;
    }

    public void setWidgets(List<Widget> widgets) {
        this.widgets = widgets;
    }

    @Override
    public void addWidget(Widget widget) {
        this.widgets.add(widget);
    }

    @Override
    public void deleteWidget(String widgetId) {
        Widget widget = this.getWidget(widgetId);
        if (widget != null) {
            this.widgets.remove(widget);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DefaultDashboard[");
        buffer.append("id = ").append(this.id);
        buffer.append(" title = ").append(this.title);
        buffer.append(" widgets = ").append(this.widgets);
        buffer.append("]");
        return buffer.toString();
    }
}

