/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.net;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Browser {
    private final String executable;
    private final String userAgent;
    private final InetSocketAddress proxy;
    private final List<String> options = Arrays.asList("--headless", "--disable-gpu", "--ignore-certificate-errors", "--hide-scrollbars");
    private static final long DEFAULT_TIMEOUT = 60000L;

    public static Browser chrome(String executable, InetSocketAddress proxy) {
        return new Browser(executable, proxy, null);
    }

    Browser(String executable, InetSocketAddress proxy, String userAgent) {
        this.executable = executable;
        this.proxy = proxy;
        this.userAgent = userAgent;
    }

    public void browse(URI uri) throws IOException {
        this.run(uri.toString());
    }

    public void screenshot(URI uri, Path outfile) throws IOException {
        this.screenshot(uri.toString(), outfile);
    }

    public void screenshot(String url, Path outfile) throws IOException {
        this.run("--screenshot=" + outfile, url);
    }

    public FileChannel screenshot(URI uri) throws IOException {
        return this.screenshot(uri.toString());
    }

    public FileChannel screenshot(String uri) throws IOException {
        Path outfile = Files.createTempFile("jwarc-screenshot", ".png", new FileAttribute[0]);
        try {
            this.run("--screenshot=" + outfile, uri);
            return FileChannel.open(outfile, StandardOpenOption.DELETE_ON_CLOSE);
        }
        catch (Exception e) {
            Files.deleteIfExists(outfile);
            throw e;
        }
    }

    private void run(String ... args) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.executable);
        command.addAll(this.options);
        if (this.proxy != null) {
            command.add("--proxy-server=" + this.proxy.getHostString() + ":" + this.proxy.getPort());
        }
        if (this.userAgent != null) {
            command.add("--user-agent=" + this.userAgent);
        }
        command.addAll(Arrays.asList(args));
        try {
            Process process = new ProcessBuilder(command).inheritIO().redirectOutput(Browser.devNull()).start();
            if (!process.waitFor(60000L, TimeUnit.MILLISECONDS)) {
                process.destroy();
                process.waitFor(60000L, TimeUnit.MILLISECONDS);
                process.destroyForcibly();
                throw new IOException("timed out after 60000ms");
            }
            if (process.exitValue() != 0) {
                throw new IOException("browser returned exit status: " + process.exitValue());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static File devNull() {
        return new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null");
    }
}

