/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.filter.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XShape;
import com.sun.star.graphic.XGraphicProvider;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.XComponentContext;
import java.awt.Dimension;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.local.filter.FilterChain;
import org.jodconverter.local.filter.text.AbstractTextContentInserterFilter;
import org.jodconverter.local.office.LocalOfficeContext;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.local.office.utils.Info;
import org.jodconverter.local.office.utils.Lo;
import org.jodconverter.local.office.utils.Props;
import org.jodconverter.local.office.utils.Write;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicInserterFilter
extends AbstractTextContentInserterFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphicInserterFilter.class);
    private File imageFile;

    /*
     * Exception decompiling
     */
    private static Dimension getImageSize(File image) throws OfficeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 9[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int pixelsToMillimeters(int pixels) {
        return Math.round((float)pixels * 0.26458332f);
    }

    public GraphicInserterFilter(@NonNull String imagePath, int horizontalPosition, int verticalPosition) throws OfficeException {
        super(horizontalPosition, verticalPosition);
        this.setImageFile(imagePath);
        this.setRectSize(GraphicInserterFilter.getImageSize(this.imageFile));
    }

    public GraphicInserterFilter(@NonNull String imagePath, int width, int height, int horizontalPosition, int verticalPosition) {
        super(new Dimension(width, height), horizontalPosition, verticalPosition);
        this.setImageFile(imagePath);
    }

    public GraphicInserterFilter(@NonNull String imagePath, @NonNull Map<@NonNull String, @NonNull Object> shapeProperties) throws OfficeException {
        super(shapeProperties);
        this.setImageFile(imagePath);
        this.setRectSize(GraphicInserterFilter.getImageSize(this.imageFile));
    }

    public GraphicInserterFilter(@NonNull String imagePath, int width, int height, @NonNull Map<@NonNull String, @NonNull Object> shapeProperties) {
        super(new Dimension(width, height), shapeProperties);
        this.setImageFile(imagePath);
    }

    @Override
    public void doFilter(@NonNull OfficeContext context, @NonNull XComponent document, @NonNull FilterChain chain) throws Exception {
        if (Write.isText(document)) {
            LOGGER.debug("Applying the GraphicInserterFilter");
            this.insertGraphic(((LocalOfficeContext)context).getComponentContext(), document);
        }
        chain.doFilter(context, document);
    }

    private void setImageFile(String imagePath) {
        AssertUtils.notBlank((String)imagePath, (String)"imagePath must not be null nor blank");
        this.imageFile = new File(imagePath);
        AssertUtils.isTrue((boolean)this.imageFile.exists(), (String)"imagePath must be the path of an existing file");
    }

    private void insertGraphic(XComponentContext context, XComponent document) throws Exception {
        XMultiServiceFactory serviceFactory = Lo.getServiceFactory(document);
        Object graphicShape = serviceFactory.createInstance("com.sun.star.drawing.GraphicObjectShape");
        XShape shape = Lo.qi(XShape.class, graphicShape);
        shape.setSize(GraphicInserterFilter.toOfficeSize(this.getRectSize()));
        String strUrl = LocalOfficeUtils.toUrl(this.imageFile);
        XPropertySet propSet = Lo.qi(XPropertySet.class, graphicShape);
        if (Info.isLibreOffice(context) && Info.compareVersions("6.1", Info.getOfficeVersionShort(context), 2) >= 0) {
            XGraphicProvider graphicProvider = Lo.createInstance(context, XGraphicProvider.class, "com.sun.star.graphic.GraphicProvider");
            Objects.requireNonNull(graphicProvider);
            propSet.setPropertyValue("Graphic", (Object)graphicProvider.queryGraphic(Props.makeProperties("URL", strUrl, "LoadAsLink", false)));
        } else {
            XNameContainer bitmapContainer = Lo.createInstance(serviceFactory, XNameContainer.class, "com.sun.star.drawing.BitmapTable");
            LOGGER.debug("Embedding image to the bitmap container '{}'", (Object)strUrl);
            String string = UUID.randomUUID().toString();
            bitmapContainer.insertByName(string, (Object)strUrl);
            propSet.setPropertyValue("GraphicURL", bitmapContainer.getByName(string));
        }
        for (Map.Entry entry : this.getShapeProperties().entrySet()) {
            propSet.setPropertyValue((String)entry.getKey(), entry.getValue());
        }
        XTextDocument docText = Lo.qi(XTextDocument.class, document);
        XText xText = docText.getText();
        XTextCursor textCursor = xText.createTextCursor();
        this.applyAnchorPageNoFix(docText, textCursor);
        XTextContent textContent = Lo.qi(XTextContent.class, graphicShape);
        LOGGER.debug("Inserting image into the document");
        xText.insertTextContent((XTextRange)textCursor, textContent, false);
    }
}

