/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ISQLServerMessage;
import com.microsoft.sqlserver.jdbc.SQLServerError;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerWarning;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.TDSReader;
import java.sql.SQLException;

public final class SQLServerInfoMessage
extends StreamPacket
implements ISQLServerMessage {
    SQLServerError msg = new SQLServerError();

    SQLServerInfoMessage() {
        super(171);
    }

    SQLServerInfoMessage(SQLServerError msg) {
        super(171);
        this.msg = msg;
    }

    @Override
    void setFromTDS(TDSReader tdsReader) throws SQLServerException {
        if (171 != tdsReader.readUnsignedByte()) assert (false);
        this.msg.setContentsFromTDS(tdsReader);
    }

    @Override
    public SQLServerError getSQLServerMessage() {
        return this.msg;
    }

    @Override
    public String getErrorMessage() {
        return this.msg.getErrorMessage();
    }

    @Override
    public int getErrorNumber() {
        return this.msg.getErrorNumber();
    }

    @Override
    public int getErrorState() {
        return this.msg.getErrorState();
    }

    @Override
    public int getErrorSeverity() {
        return this.msg.getErrorSeverity();
    }

    @Override
    public String getServerName() {
        return this.msg.getServerName();
    }

    @Override
    public String getProcedureName() {
        return this.msg.getProcedureName();
    }

    @Override
    public long getLineNumber() {
        return this.msg.getLineNumber();
    }

    public ISQLServerMessage toSQLServerError() {
        return this.toSQLServerError(-1, -1);
    }

    public ISQLServerMessage toSQLServerError(int newErrorSeverity) {
        return this.toSQLServerError(newErrorSeverity, -1);
    }

    public ISQLServerMessage toSQLServerError(int newErrorSeverity, int newErrorNumber) {
        if (newErrorSeverity != -1) {
            this.msg.setErrorSeverity(newErrorSeverity);
        }
        if (newErrorNumber != -1) {
            this.msg.setErrorNumber(newErrorNumber);
        }
        return new SQLServerError(this.msg);
    }

    @Override
    public SQLException toSqlExceptionOrSqlWarning() {
        return new SQLServerWarning(this.msg);
    }
}

