/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.xobject;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.xobject.XObjectValidator;

public abstract class AbstractXObjValidator
implements XObjectValidator {
    protected COSStream xobject = null;
    protected PreflightContext context = null;
    protected COSDocument cosDocument = null;

    public AbstractXObjValidator(PreflightContext context, COSStream xobj) {
        this.xobject = xobj;
        this.context = context;
        this.cosDocument = context.getDocument().getDocument();
    }

    protected void checkSMask() {
        COSBase smask = this.xobject.getDictionaryObject(COSName.SMASK);
        if (smask != null && !COSName.getPDFName("None").equals(smask)) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.2.2", "Soft Mask must be null or None"));
        }
    }

    protected void checkOPI() {
        if (this.xobject.getItem(COSName.getPDFName("OPI")) != null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3", "Unexpected 'OPI' Key"));
        }
    }

    protected void checkReferenceXObject() {
        if (this.xobject.getItem("Ref") != null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3", "No reference Xobject allowed in PDF/A"));
        }
    }

    protected void checkPostscriptXObject() {
        String subtype = this.xobject.getNameAsString(COSName.SUBTYPE);
        if (subtype != null && "PS".equals(subtype)) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3.2", "No Postscript Xobject allowed in PDF/A"));
            return;
        }
        if (this.xobject.getItem(COSName.getPDFName("Subtype2")) != null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3.2", "No Postscript Xobject allowed in PDF/A (Subtype2)"));
            return;
        }
    }

    protected abstract void checkMandatoryFields();

    public void validate() throws ValidationException {
        this.checkMandatoryFields();
        this.checkOPI();
        this.checkSMask();
        this.checkReferenceXObject();
        this.checkPostscriptXObject();
    }
}

