/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.ConfigModelPasswordManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.manager.ManagedUser;
import org.apache.qpid.server.security.auth.sasl.PasswordSource;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.security.auth.sasl.crammd5.CramMd5Negotiator;
import org.apache.qpid.server.security.auth.sasl.plain.PlainNegotiator;
import org.apache.qpid.server.security.auth.sasl.scram.ScramNegotiator;
import org.apache.qpid.server.security.auth.sasl.scram.ScramSaslServerSourceAdapter;

@ManagedObject(category=false, type="Plain", validChildTypes="org.apache.qpid.server.security.auth.manager.ConfigModelPasswordManagingAuthenticationProvider#getSupportedUserTypes()")
public class PlainAuthenticationProvider
extends ConfigModelPasswordManagingAuthenticationProvider<PlainAuthenticationProvider> {
    private final List<String> _mechanisms = Collections.unmodifiableList(Arrays.asList("PLAIN", "CRAM-MD5", "SCRAM-SHA-1", "SCRAM-SHA-256"));
    private volatile ScramSaslServerSourceAdapter _scramSha1Adapter;
    private volatile ScramSaslServerSourceAdapter _scramSha256Adapter;

    @ManagedObjectFactoryConstructor
    protected PlainAuthenticationProvider(Map<String, Object> attributes, Broker broker) {
        super(attributes, broker);
    }

    @Override
    protected void postResolveChildren() {
        super.postResolveChildren();
        PasswordSource passwordSource = this.getPasswordSource();
        int scramIterationCount = this.getContextValue(Integer.class, "qpid.auth.scram.iteration_count");
        this._scramSha1Adapter = new ScramSaslServerSourceAdapter(scramIterationCount, "HmacSHA1", "SHA-1", passwordSource);
        this._scramSha256Adapter = new ScramSaslServerSourceAdapter(scramIterationCount, "HmacSHA256", "SHA-256", passwordSource);
    }

    @Override
    protected String createStoredPassword(String password) {
        return password;
    }

    @Override
    void validateUser(ManagedUser managedUser) {
    }

    @Override
    public List<String> getMechanisms() {
        return this._mechanisms;
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        ManagedUser user = this.getUser(username);
        AuthenticationResult result = user != null && user.getPassword().equals(password) ? new AuthenticationResult(new UsernamePrincipal(username, this)) : new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
        return result;
    }

    @Override
    public SaslNegotiator createSaslNegotiator(String mechanism, SaslSettings saslSettings, NamedAddressSpace addressSpace) {
        if ("PLAIN".equals(mechanism)) {
            return new PlainNegotiator(this);
        }
        if ("CRAM-MD5".equals(mechanism)) {
            return new CramMd5Negotiator(this, saslSettings.getLocalFQDN(), this.getPasswordSource());
        }
        if ("SCRAM-SHA-1".equals(mechanism)) {
            return new ScramNegotiator(this, this._scramSha1Adapter, "SCRAM-SHA-1");
        }
        if ("SCRAM-SHA-256".equals(mechanism)) {
            return new ScramNegotiator(this, this._scramSha256Adapter, "SCRAM-SHA-256");
        }
        return null;
    }
}

