/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.util;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowControllingBlockingQueue<T> {
    private static final Logger _logger = LoggerFactory.getLogger(FlowControllingBlockingQueue.class);
    private final Queue<T> _queue = new ConcurrentLinkedQueue<T>();
    private final int _flowControlHighThreshold;
    private final int _flowControlLowThreshold;
    private final ThresholdListener _listener;
    private int _count;
    private boolean disableFlowControl;
    private volatile boolean _closed;

    public boolean isEmpty() {
        return this._queue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        FlowControllingBlockingQueue flowControllingBlockingQueue = this;
        synchronized (flowControllingBlockingQueue) {
            this._closed = true;
            this.notifyAll();
        }
    }

    public FlowControllingBlockingQueue(int threshold, ThresholdListener listener) {
        this(threshold, threshold, listener);
    }

    public FlowControllingBlockingQueue(int highThreshold, int lowThreshold, ThresholdListener listener) {
        this._flowControlHighThreshold = highThreshold;
        this._flowControlLowThreshold = lowThreshold;
        this._listener = listener;
        if (highThreshold <= 0) {
            this.disableFlowControl = true;
        } else {
            if (lowThreshold > highThreshold) {
                throw new IllegalArgumentException(String.format("Invalid low threshold %d : it should be less or equal high threshold %d", lowThreshold, highThreshold));
            }
            if (lowThreshold < 1) {
                throw new IllegalArgumentException(String.format("Invalid low threshold %d: it should be greater than 0", lowThreshold));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T blockingPeek() throws InterruptedException {
        T o = this._queue.peek();
        if (o == null) {
            FlowControllingBlockingQueue flowControllingBlockingQueue = this;
            synchronized (flowControllingBlockingQueue) {
                while (!this._closed && (o = this._queue.peek()) == null) {
                    this.wait();
                }
            }
        }
        return o;
    }

    public T nonBlockingTake() throws InterruptedException {
        T o = this._queue.poll();
        if (o != null && !this.disableFlowControl && this._listener != null) {
            this.reportBelowIfNecessary();
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T take() throws InterruptedException {
        T o = this._queue.poll();
        if (o == null) {
            FlowControllingBlockingQueue flowControllingBlockingQueue = this;
            synchronized (flowControllingBlockingQueue) {
                while (!this._closed && (o = this._queue.poll()) == null) {
                    this.wait();
                }
            }
        }
        if (!this._closed && !this.disableFlowControl && this._listener != null) {
            this.reportBelowIfNecessary();
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T o) {
        FlowControllingBlockingQueue flowControllingBlockingQueue = this;
        synchronized (flowControllingBlockingQueue) {
            this._queue.add(o);
            this.notifyAll();
        }
        if (!this.disableFlowControl && this._listener != null) {
            this.reportAboveIfNecessary();
        }
    }

    public boolean remove(T o) {
        boolean removed = this._queue.remove(o);
        if (removed && !this.disableFlowControl && this._listener != null) {
            this.reportBelowIfNecessary();
        }
        return removed;
    }

    public Iterator<T> iterator() {
        return this._queue.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this._queue.clear();
        if (!this.disableFlowControl && this._listener != null) {
            ThresholdListener thresholdListener = this._listener;
            synchronized (thresholdListener) {
                int count = this._count;
                this._count = 0;
                if (count >= this._flowControlLowThreshold) {
                    this._listener.underThreshold(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportAboveIfNecessary() {
        ThresholdListener thresholdListener = this._listener;
        synchronized (thresholdListener) {
            if (++this._count == this._flowControlHighThreshold) {
                this._listener.aboveThreshold(this._count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportBelowIfNecessary() {
        ThresholdListener thresholdListener = this._listener;
        synchronized (thresholdListener) {
            if (this._count-- == this._flowControlLowThreshold) {
                this._listener.underThreshold(this._count);
            }
        }
    }

    public static interface ThresholdListener {
        public void aboveThreshold(int var1);

        public void underThreshold(int var1);
    }
}

