/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import com.alibaba.fastjson.JSON;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.metrics.PopMetricsManager;
import org.apache.rocketmq.broker.processor.PopMessageProcessor;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.PopAckConstants;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.pop.AckMsg;
import org.apache.rocketmq.store.pop.PopCheckPoint;

public class PopBufferMergeService
extends ServiceThread {
    private static final Logger POP_LOGGER = LoggerFactory.getLogger((String)"RocketmqPop");
    ConcurrentHashMap<String, PopCheckPointWrapper> buffer = new ConcurrentHashMap(16384);
    ConcurrentHashMap<String, QueueWithTime<PopCheckPointWrapper>> commitOffsets = new ConcurrentHashMap();
    private volatile boolean serving = true;
    private AtomicInteger counter = new AtomicInteger(0);
    private int scanTimes = 0;
    private final BrokerController brokerController;
    private final PopMessageProcessor popMessageProcessor;
    private final PopMessageProcessor.QueueLockManager queueLockManager;
    private final long interval = 5L;
    private final long minute5 = 300000L;
    private final int countOfMinute1 = 12000;
    private final int countOfSecond1 = 200;
    private final int countOfSecond30 = 6000;
    private volatile boolean master = false;

    public PopBufferMergeService(BrokerController brokerController, PopMessageProcessor popMessageProcessor) {
        this.brokerController = brokerController;
        this.popMessageProcessor = popMessageProcessor;
        this.queueLockManager = popMessageProcessor.getQueueLockManager();
    }

    private boolean isShouldRunning() {
        if (this.brokerController.getBrokerConfig().isEnableSlaveActingMaster()) {
            return true;
        }
        this.master = this.brokerController.getMessageStoreConfig().getBrokerRole() != BrokerRole.SLAVE;
        return this.master;
    }

    public String getServiceName() {
        if (this.brokerController != null && this.brokerController.getBrokerConfig().isInBrokerContainer()) {
            return this.brokerController.getBrokerIdentity().getIdentifier() + PopBufferMergeService.class.getSimpleName();
        }
        return PopBufferMergeService.class.getSimpleName();
    }

    public void run() {
        while (!this.isStopped()) {
            try {
                if (!this.isShouldRunning()) {
                    this.waitForRunning(5000L);
                    POP_LOGGER.info("Broker is {}, {}, clear all data", (Object)this.brokerController.getMessageStoreConfig().getBrokerRole(), (Object)this.master);
                    this.buffer.clear();
                    this.commitOffsets.clear();
                    continue;
                }
                this.scan();
                if (this.scanTimes % 6000 == 0) {
                    this.scanGarbage();
                }
                this.waitForRunning(5L);
                if (this.serving || this.buffer.size() != 0 || this.getOffsetTotalSize() != 0) continue;
                this.serving = true;
            }
            catch (Throwable e) {
                POP_LOGGER.error("PopBufferMergeService error", e);
                this.waitForRunning(3000L);
            }
        }
        this.serving = false;
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.isShouldRunning()) {
            return;
        }
        while (this.buffer.size() > 0 || this.getOffsetTotalSize() > 0) {
            this.scan();
        }
    }

    private int scanCommitOffset() {
        Iterator<Map.Entry<String, QueueWithTime<PopCheckPointWrapper>>> iterator = this.commitOffsets.entrySet().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            PopCheckPointWrapper pointWrapper;
            Map.Entry<String, QueueWithTime<PopCheckPointWrapper>> entry = iterator.next();
            LinkedBlockingDeque<PopCheckPointWrapper> queue = entry.getValue().get();
            while ((pointWrapper = queue.peek()) != null) {
                if (pointWrapper.isJustOffset() && pointWrapper.isCkStored() || this.isCkDone(pointWrapper) || this.isCkDoneForFinish(pointWrapper) && pointWrapper.isCkStored()) {
                    if (!this.commitOffset(pointWrapper)) break;
                    queue.poll();
                    continue;
                }
                if (System.currentTimeMillis() - pointWrapper.getCk().getPopTime() <= (long)(this.brokerController.getBrokerConfig().getPopCkStayBufferTime() * 2)) break;
                POP_LOGGER.warn("[PopBuffer] ck offset long time not commit, {}", (Object)pointWrapper);
                break;
            }
            int qs = queue.size();
            count += qs;
            if (qs <= 5000 || this.scanTimes % 200 != 0) continue;
            POP_LOGGER.info("[PopBuffer] offset queue size too long, {}, {}", (Object)entry.getKey(), (Object)qs);
        }
        return count;
    }

    public long getLatestOffset(String lockKey) {
        QueueWithTime<PopCheckPointWrapper> queue = this.commitOffsets.get(lockKey);
        if (queue == null) {
            return -1L;
        }
        PopCheckPointWrapper pointWrapper = queue.get().peekLast();
        if (pointWrapper != null) {
            return pointWrapper.getNextBeginOffset();
        }
        return -1L;
    }

    public long getLatestOffset(String topic, String group, int queueId) {
        return this.getLatestOffset(KeyBuilder.buildPollingKey((String)topic, (String)group, (int)queueId));
    }

    private void scanGarbage() {
        Iterator<Map.Entry<String, QueueWithTime<PopCheckPointWrapper>>> iterator = this.commitOffsets.entrySet().iterator();
        while (iterator.hasNext()) {
            String[] keyArray;
            Map.Entry<String, QueueWithTime<PopCheckPointWrapper>> entry = iterator.next();
            if (entry.getKey() == null || (keyArray = entry.getKey().split("@")) == null || keyArray.length != 3) continue;
            String topic = keyArray[0];
            String cid = keyArray[1];
            if (this.brokerController.getTopicConfigManager().selectTopicConfig(topic) == null) {
                POP_LOGGER.info("[PopBuffer]remove not exit topic {} in buffer!", (Object)topic);
                iterator.remove();
                continue;
            }
            if (!this.brokerController.getSubscriptionGroupManager().getSubscriptionGroupTable().containsKey(cid)) {
                POP_LOGGER.info("[PopBuffer]remove not exit sub {} of topic {} in buffer!", (Object)cid, (Object)topic);
                iterator.remove();
                continue;
            }
            if (System.currentTimeMillis() - entry.getValue().getTime() <= 300000L) continue;
            POP_LOGGER.info("[PopBuffer]remove long time not used sub {} of topic {} in buffer!", (Object)cid, (Object)topic);
            iterator.remove();
        }
    }

    private void scan() {
        long startTime = System.currentTimeMillis();
        int count = 0;
        int countCk = 0;
        Iterator<Map.Entry<String, PopCheckPointWrapper>> iterator = this.buffer.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean removeCk;
            Map.Entry<String, PopCheckPointWrapper> entry = iterator.next();
            PopCheckPointWrapper pointWrapper = entry.getValue();
            if (pointWrapper.isJustOffset() && pointWrapper.isCkStored() || this.isCkDone(pointWrapper) || this.isCkDoneForFinish(pointWrapper) && pointWrapper.isCkStored()) {
                if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                    POP_LOGGER.info("[PopBuffer]ck done, {}", (Object)pointWrapper);
                }
                iterator.remove();
                this.counter.decrementAndGet();
                continue;
            }
            PopCheckPoint point = pointWrapper.getCk();
            long now = System.currentTimeMillis();
            boolean bl = removeCk = !this.serving;
            if (point.getReviveTime() - now < (long)this.brokerController.getBrokerConfig().getPopCkStayBufferTimeOut()) {
                removeCk = true;
            }
            if (now - point.getPopTime() > (long)this.brokerController.getBrokerConfig().getPopCkStayBufferTime()) {
                removeCk = true;
            }
            if (now - point.getPopTime() > (long)this.brokerController.getBrokerConfig().getPopCkStayBufferTime() * 2L) {
                POP_LOGGER.warn("[PopBuffer]ck finish fail, stay too long, {}", (Object)pointWrapper);
            }
            if (this.isCkDone(pointWrapper)) continue;
            if (pointWrapper.isJustOffset()) {
                if (pointWrapper.getReviveQueueOffset() >= 0L) continue;
                this.putCkToStore(pointWrapper, false);
                ++countCk;
                continue;
            }
            if (!removeCk) continue;
            if (pointWrapper.getReviveQueueOffset() < 0L) {
                this.putCkToStore(pointWrapper, false);
                ++countCk;
            }
            if (!pointWrapper.isCkStored()) continue;
            for (byte i = 0; i < point.getNum(); i = (byte)(i + 1)) {
                if (!DataConverter.getBit((int)pointWrapper.getBits().get(), (int)i) || DataConverter.getBit((int)pointWrapper.getToStoreBits().get(), (int)i) || !this.putAckToStore(pointWrapper, i)) continue;
                ++count;
                this.markBitCAS(pointWrapper.getToStoreBits(), i);
            }
            if (!this.isCkDoneForFinish(pointWrapper) || !pointWrapper.isCkStored()) continue;
            if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                POP_LOGGER.info("[PopBuffer]ck finish, {}", (Object)pointWrapper);
            }
            iterator.remove();
            this.counter.decrementAndGet();
        }
        int offsetBufferSize = this.scanCommitOffset();
        long eclipse = System.currentTimeMillis() - startTime;
        if (eclipse > (long)(this.brokerController.getBrokerConfig().getPopCkStayBufferTimeOut() - 1000)) {
            POP_LOGGER.warn("[PopBuffer]scan stop, because eclipse too long, PopBufferEclipse={}, PopBufferToStoreAck={}, PopBufferToStoreCk={}, PopBufferSize={}, PopBufferOffsetSize={}", new Object[]{eclipse, count, countCk, this.counter.get(), offsetBufferSize});
            this.serving = false;
        } else if (this.scanTimes % 200 == 0) {
            POP_LOGGER.info("[PopBuffer]scan, PopBufferEclipse={}, PopBufferToStoreAck={}, PopBufferToStoreCk={}, PopBufferSize={}, PopBufferOffsetSize={}", new Object[]{eclipse, count, countCk, this.counter.get(), offsetBufferSize});
        }
        PopMetricsManager.recordPopBufferScanTimeConsume(eclipse);
        ++this.scanTimes;
        if (this.scanTimes >= 12000) {
            this.counter.set(this.buffer.size());
            this.scanTimes = 0;
        }
    }

    public int getOffsetTotalSize() {
        int count = 0;
        for (Map.Entry<String, QueueWithTime<PopCheckPointWrapper>> entry : this.commitOffsets.entrySet()) {
            LinkedBlockingDeque<PopCheckPointWrapper> queue = entry.getValue().get();
            count += queue.size();
        }
        return count;
    }

    public int getBufferedCKSize() {
        return this.counter.get();
    }

    private void markBitCAS(AtomicInteger setBits, int index) {
        int newBits;
        int bits;
        while (!DataConverter.getBit((int)(bits = setBits.get()), (int)index) && !setBits.compareAndSet(bits, newBits = DataConverter.setBit((int)bits, (int)index, (boolean)true))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commitOffset(PopCheckPointWrapper wrapper) {
        if (wrapper.getNextBeginOffset() < 0L) {
            return true;
        }
        PopCheckPoint popCheckPoint = wrapper.getCk();
        String lockKey = wrapper.getLockKey();
        if (!this.queueLockManager.tryLock(lockKey)) {
            return false;
        }
        try {
            long offset = this.brokerController.getConsumerOffsetManager().queryOffset(popCheckPoint.getCId(), popCheckPoint.getTopic(), popCheckPoint.getQueueId());
            if (wrapper.getNextBeginOffset() > offset) {
                if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                    POP_LOGGER.info("Commit offset, {}, {}", (Object)wrapper, (Object)offset);
                }
            } else {
                POP_LOGGER.warn("Commit offset, consumer offset less than store, {}, {}", (Object)wrapper, (Object)offset);
            }
            this.brokerController.getConsumerOffsetManager().commitOffset(this.getServiceName(), popCheckPoint.getCId(), popCheckPoint.getTopic(), popCheckPoint.getQueueId(), wrapper.getNextBeginOffset());
        }
        finally {
            this.queueLockManager.unLock(lockKey);
        }
        return true;
    }

    private boolean putOffsetQueue(PopCheckPointWrapper pointWrapper) {
        QueueWithTime<PopCheckPointWrapper> queue = this.commitOffsets.get(pointWrapper.getLockKey());
        if (queue == null) {
            queue = new QueueWithTime();
            QueueWithTime<PopCheckPointWrapper> old = this.commitOffsets.putIfAbsent(pointWrapper.getLockKey(), queue);
            if (old != null) {
                queue = old;
            }
        }
        queue.setTime(pointWrapper.getCk().getPopTime());
        return queue.get().offer(pointWrapper);
    }

    private boolean checkQueueOk(PopCheckPointWrapper pointWrapper) {
        QueueWithTime<PopCheckPointWrapper> queue = this.commitOffsets.get(pointWrapper.getLockKey());
        if (queue == null) {
            return true;
        }
        return queue.get().size() < this.brokerController.getBrokerConfig().getPopCkOffsetMaxQueueSize();
    }

    public void addCkJustOffset(PopCheckPoint point, int reviveQueueId, long reviveQueueOffset, long nextBeginOffset) {
        PopCheckPointWrapper pointWrapper;
        this.putCkToStore(pointWrapper, !this.checkQueueOk(pointWrapper = new PopCheckPointWrapper(reviveQueueId, reviveQueueOffset, point, nextBeginOffset, true)));
        this.putOffsetQueue(pointWrapper);
        this.buffer.put(pointWrapper.getMergeKey(), pointWrapper);
        this.counter.incrementAndGet();
        if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
            POP_LOGGER.info("[PopBuffer]add ck just offset, {}", (Object)pointWrapper);
        }
    }

    public void addCkMock(String group, String topic, int queueId, long startOffset, long invisibleTime, long popTime, int reviveQueueId, long nextBeginOffset, String brokerName) {
        PopCheckPoint ck = new PopCheckPoint();
        ck.setBitMap(0);
        ck.setNum((byte)0);
        ck.setPopTime(popTime);
        ck.setInvisibleTime(invisibleTime);
        ck.setStartOffset(startOffset);
        ck.setCId(group);
        ck.setTopic(topic);
        ck.setQueueId(queueId);
        ck.setBrokerName(brokerName);
        PopCheckPointWrapper pointWrapper = new PopCheckPointWrapper(reviveQueueId, Long.MAX_VALUE, ck, nextBeginOffset, true);
        pointWrapper.setCkStored(true);
        this.putOffsetQueue(pointWrapper);
        if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
            POP_LOGGER.info("[PopBuffer]add ck just offset, mocked, {}", (Object)pointWrapper);
        }
    }

    public boolean addCk(PopCheckPoint point, int reviveQueueId, long reviveQueueOffset, long nextBeginOffset) {
        if (!this.brokerController.getBrokerConfig().isEnablePopBufferMerge()) {
            return false;
        }
        if (!this.serving) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (point.getReviveTime() - now < (long)(this.brokerController.getBrokerConfig().getPopCkStayBufferTimeOut() + 1500)) {
            if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                POP_LOGGER.warn("[PopBuffer]add ck, timeout, {}, {}", (Object)point, (Object)now);
            }
            return false;
        }
        if (this.counter.get() > this.brokerController.getBrokerConfig().getPopCkMaxBufferSize()) {
            POP_LOGGER.warn("[PopBuffer]add ck, max size, {}, {}", (Object)point, (Object)this.counter.get());
            return false;
        }
        PopCheckPointWrapper pointWrapper = new PopCheckPointWrapper(reviveQueueId, reviveQueueOffset, point, nextBeginOffset);
        if (!this.checkQueueOk(pointWrapper)) {
            return false;
        }
        this.putOffsetQueue(pointWrapper);
        this.buffer.put(pointWrapper.getMergeKey(), pointWrapper);
        this.counter.incrementAndGet();
        if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
            POP_LOGGER.info("[PopBuffer]add ck, {}", (Object)pointWrapper);
        }
        return true;
    }

    public boolean addAk(int reviveQid, AckMsg ackMsg) {
        if (!this.brokerController.getBrokerConfig().isEnablePopBufferMerge()) {
            return false;
        }
        if (!this.serving) {
            return false;
        }
        try {
            PopCheckPointWrapper pointWrapper = this.buffer.get(ackMsg.getTopic() + ackMsg.getConsumerGroup() + ackMsg.getQueueId() + ackMsg.getStartOffset() + ackMsg.getPopTime() + ackMsg.getBrokerName());
            if (pointWrapper == null) {
                if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                    POP_LOGGER.warn("[PopBuffer]add ack fail, rqId={}, no ck, {}", (Object)reviveQid, (Object)ackMsg);
                }
                return false;
            }
            if (pointWrapper.isJustOffset()) {
                return false;
            }
            PopCheckPoint point = pointWrapper.getCk();
            long now = System.currentTimeMillis();
            if (point.getReviveTime() - now < (long)(this.brokerController.getBrokerConfig().getPopCkStayBufferTimeOut() + 1500)) {
                if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                    POP_LOGGER.warn("[PopBuffer]add ack fail, rqId={}, almost timeout for revive, {}, {}, {}", new Object[]{reviveQid, pointWrapper, ackMsg, now});
                }
                return false;
            }
            if (now - point.getPopTime() > (long)(this.brokerController.getBrokerConfig().getPopCkStayBufferTime() - 1500)) {
                if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                    POP_LOGGER.warn("[PopBuffer]add ack fail, rqId={}, stay too long, {}, {}, {}", new Object[]{reviveQid, pointWrapper, ackMsg, now});
                }
                return false;
            }
            int indexOfAck = point.indexOfAck(ackMsg.getAckOffset());
            if (indexOfAck <= -1) {
                POP_LOGGER.error("[PopBuffer]Invalid index of ack, reviveQid={}, {}, {}", new Object[]{reviveQid, ackMsg, point});
                return true;
            }
            this.markBitCAS(pointWrapper.getBits(), indexOfAck);
            if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                POP_LOGGER.info("[PopBuffer]add ack, rqId={}, {}, {}", new Object[]{reviveQid, pointWrapper, ackMsg});
            }
            return true;
        }
        catch (Throwable e) {
            POP_LOGGER.error("[PopBuffer]add ack error, rqId=" + reviveQid + ", " + ackMsg, e);
            return false;
        }
    }

    public void clearOffsetQueue(String lockKey) {
        this.commitOffsets.remove(lockKey);
    }

    private void putCkToStore(PopCheckPointWrapper pointWrapper, boolean runInCurrent) {
        if (pointWrapper.getReviveQueueOffset() >= 0L) {
            return;
        }
        MessageExtBrokerInner msgInner = this.popMessageProcessor.buildCkMsg(pointWrapper.getCk(), pointWrapper.getReviveQueueId());
        PutMessageResult putMessageResult = this.brokerController.getEscapeBridge().putMessageToSpecificQueue(msgInner);
        PopMetricsManager.incPopReviveCkPutCount(pointWrapper.getCk(), putMessageResult.getPutMessageStatus());
        if (putMessageResult.getPutMessageStatus() != PutMessageStatus.PUT_OK && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_DISK_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_SLAVE_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.SLAVE_NOT_AVAILABLE) {
            POP_LOGGER.error("[PopBuffer]put ck to store fail: {}, {}", (Object)pointWrapper, (Object)putMessageResult);
            return;
        }
        pointWrapper.setCkStored(true);
        if (putMessageResult.isRemotePut()) {
            pointWrapper.setReviveQueueOffset(0L);
        } else {
            pointWrapper.setReviveQueueOffset(putMessageResult.getAppendMessageResult().getLogicsOffset());
        }
        if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
            POP_LOGGER.info("[PopBuffer]put ck to store ok: {}, {}", (Object)pointWrapper, (Object)putMessageResult);
        }
    }

    private boolean putAckToStore(PopCheckPointWrapper pointWrapper, byte msgIndex) {
        PopCheckPoint point = pointWrapper.getCk();
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        AckMsg ackMsg = new AckMsg();
        ackMsg.setAckOffset(point.ackOffsetByIndex(msgIndex));
        ackMsg.setStartOffset(point.getStartOffset());
        ackMsg.setConsumerGroup(point.getCId());
        ackMsg.setTopic(point.getTopic());
        ackMsg.setQueueId(point.getQueueId());
        ackMsg.setPopTime(point.getPopTime());
        msgInner.setTopic(this.popMessageProcessor.reviveTopic);
        msgInner.setBody(JSON.toJSONString((Object)ackMsg).getBytes(DataConverter.charset));
        msgInner.setQueueId(pointWrapper.getReviveQueueId());
        msgInner.setTags("ack");
        msgInner.setBornTimestamp(System.currentTimeMillis());
        msgInner.setBornHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setStoreHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setDeliverTimeMs(point.getReviveTime());
        msgInner.getProperties().put("UNIQ_KEY", PopMessageProcessor.genAckUniqueId(ackMsg));
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        PutMessageResult putMessageResult = this.brokerController.getEscapeBridge().putMessageToSpecificQueue(msgInner);
        PopMetricsManager.incPopReviveAckPutCount(ackMsg, putMessageResult.getPutMessageStatus());
        if (putMessageResult.getPutMessageStatus() != PutMessageStatus.PUT_OK && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_DISK_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_SLAVE_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.SLAVE_NOT_AVAILABLE) {
            POP_LOGGER.error("[PopBuffer]put ack to store fail: {}, {}, {}", new Object[]{pointWrapper, ackMsg, putMessageResult});
            return false;
        }
        if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
            POP_LOGGER.info("[PopBuffer]put ack to store ok: {}, {}, {}", new Object[]{pointWrapper, ackMsg, putMessageResult});
        }
        return true;
    }

    private boolean cancelCkTimer(PopCheckPointWrapper pointWrapper) {
        if (pointWrapper.getReviveQueueOffset() < 0L) {
            return true;
        }
        PopCheckPoint point = pointWrapper.getCk();
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(this.popMessageProcessor.reviveTopic);
        msgInner.setBody((pointWrapper.getReviveQueueId() + "-" + pointWrapper.getReviveQueueOffset()).getBytes(StandardCharsets.UTF_8));
        msgInner.setQueueId(pointWrapper.getReviveQueueId());
        msgInner.setTags("ck");
        msgInner.setBornTimestamp(System.currentTimeMillis());
        msgInner.setBornHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setStoreHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setDeliverTimeMs(point.getReviveTime() - PopAckConstants.ackTimeInterval);
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        PutMessageResult putMessageResult = this.brokerController.getEscapeBridge().putMessageToSpecificQueue(msgInner);
        if (putMessageResult.getPutMessageStatus() != PutMessageStatus.PUT_OK && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_DISK_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_SLAVE_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.SLAVE_NOT_AVAILABLE) {
            POP_LOGGER.error("[PopBuffer]PutMessageCallback cancelCheckPoint fail, {}, {}", (Object)pointWrapper, (Object)putMessageResult);
            return false;
        }
        if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
            POP_LOGGER.info("[PopBuffer]cancelCheckPoint, {}", (Object)pointWrapper);
        }
        return true;
    }

    private boolean isCkDone(PopCheckPointWrapper pointWrapper) {
        byte num = pointWrapper.getCk().getNum();
        for (byte i = 0; i < num; i = (byte)(i + 1)) {
            if (DataConverter.getBit((int)pointWrapper.getBits().get(), (int)i)) continue;
            return false;
        }
        return true;
    }

    private boolean isCkDoneForFinish(PopCheckPointWrapper pointWrapper) {
        byte num = pointWrapper.getCk().getNum();
        int bits = pointWrapper.getBits().get() ^ pointWrapper.getToStoreBits().get();
        for (byte i = 0; i < num; i = (byte)(i + 1)) {
            if (!DataConverter.getBit((int)bits, (int)i)) continue;
            return false;
        }
        return true;
    }

    public class PopCheckPointWrapper {
        private final int reviveQueueId;
        private volatile long reviveQueueOffset;
        private final PopCheckPoint ck;
        private final AtomicInteger bits;
        private final AtomicInteger toStoreBits;
        private final long nextBeginOffset;
        private final String lockKey;
        private final String mergeKey;
        private final boolean justOffset;
        private volatile boolean ckStored = false;

        public PopCheckPointWrapper(int reviveQueueId, long reviveQueueOffset, PopCheckPoint point, long nextBeginOffset) {
            this.reviveQueueId = reviveQueueId;
            this.reviveQueueOffset = reviveQueueOffset;
            this.ck = point;
            this.bits = new AtomicInteger(0);
            this.toStoreBits = new AtomicInteger(0);
            this.nextBeginOffset = nextBeginOffset;
            this.lockKey = this.ck.getTopic() + "@" + this.ck.getCId() + "@" + this.ck.getQueueId();
            this.mergeKey = point.getTopic() + point.getCId() + point.getQueueId() + point.getStartOffset() + point.getPopTime() + point.getBrokerName();
            this.justOffset = false;
        }

        public PopCheckPointWrapper(int reviveQueueId, long reviveQueueOffset, PopCheckPoint point, long nextBeginOffset, boolean justOffset) {
            this.reviveQueueId = reviveQueueId;
            this.reviveQueueOffset = reviveQueueOffset;
            this.ck = point;
            this.bits = new AtomicInteger(0);
            this.toStoreBits = new AtomicInteger(0);
            this.nextBeginOffset = nextBeginOffset;
            this.lockKey = this.ck.getTopic() + "@" + this.ck.getCId() + "@" + this.ck.getQueueId();
            this.mergeKey = point.getTopic() + point.getCId() + point.getQueueId() + point.getStartOffset() + point.getPopTime() + point.getBrokerName();
            this.justOffset = justOffset;
        }

        public int getReviveQueueId() {
            return this.reviveQueueId;
        }

        public long getReviveQueueOffset() {
            return this.reviveQueueOffset;
        }

        public boolean isCkStored() {
            return this.ckStored;
        }

        public void setReviveQueueOffset(long reviveQueueOffset) {
            this.reviveQueueOffset = reviveQueueOffset;
        }

        public PopCheckPoint getCk() {
            return this.ck;
        }

        public AtomicInteger getBits() {
            return this.bits;
        }

        public AtomicInteger getToStoreBits() {
            return this.toStoreBits;
        }

        public long getNextBeginOffset() {
            return this.nextBeginOffset;
        }

        public String getLockKey() {
            return this.lockKey;
        }

        public String getMergeKey() {
            return this.mergeKey;
        }

        public boolean isJustOffset() {
            return this.justOffset;
        }

        public void setCkStored(boolean ckStored) {
            this.ckStored = ckStored;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("CkWrap{");
            sb.append("rq=").append(this.reviveQueueId);
            sb.append(", rqo=").append(this.reviveQueueOffset);
            sb.append(", ck=").append(this.ck);
            sb.append(", bits=").append(this.bits);
            sb.append(", sBits=").append(this.toStoreBits);
            sb.append(", nbo=").append(this.nextBeginOffset);
            sb.append(", cks=").append(this.ckStored);
            sb.append(", jo=").append(this.justOffset);
            sb.append('}');
            return sb.toString();
        }
    }

    public class QueueWithTime<T> {
        private final LinkedBlockingDeque<T> queue = new LinkedBlockingDeque();
        private long time = System.currentTimeMillis();

        public void setTime(long popTime) {
            this.time = popTime;
        }

        public long getTime() {
            return this.time;
        }

        public LinkedBlockingDeque<T> get() {
            return this.queue;
        }
    }
}

