/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.authorization.strategy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.auth.authorization.context.AuthorizationContext;
import org.apache.rocketmq.auth.authorization.context.DefaultAuthorizationContext;
import org.apache.rocketmq.auth.authorization.exception.AuthorizationException;
import org.apache.rocketmq.auth.authorization.strategy.AbstractAuthorizationStrategy;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.common.Pair;

public class StatefulAuthorizationStrategy
extends AbstractAuthorizationStrategy {
    protected Cache<String, Pair<Boolean, AuthorizationException>> authCache;

    public StatefulAuthorizationStrategy(AuthConfig authConfig, Supplier<?> metadataService) {
        super(authConfig, metadataService);
        this.authCache = Caffeine.newBuilder().expireAfterWrite((long)authConfig.getStatefulAuthorizationCacheExpiredSecond(), TimeUnit.SECONDS).maximumSize((long)authConfig.getStatefulAuthorizationCacheMaxNum()).build();
    }

    @Override
    public void evaluate(AuthorizationContext context) {
        if (StringUtils.isBlank((CharSequence)context.getChannelId())) {
            this.doEvaluate(context);
            return;
        }
        Pair result = (Pair)this.authCache.get((Object)this.buildKey(context), key -> {
            try {
                this.doEvaluate(context);
                return Pair.of((Object)true, null);
            }
            catch (AuthorizationException ex) {
                return Pair.of((Object)false, (Object)ex);
            }
        });
        if (result != null && result.getObject1() == Boolean.FALSE) {
            throw (AuthorizationException)result.getObject2();
        }
    }

    private String buildKey(AuthorizationContext context) {
        if (context instanceof DefaultAuthorizationContext) {
            DefaultAuthorizationContext ctx = (DefaultAuthorizationContext)context;
            return ctx.getChannelId() + (ctx.getSubject() != null ? "#" + ctx.getSubjectKey() : "") + "#" + ctx.getResourceKey() + "#" + StringUtils.join(ctx.getActions(), (String)",") + "#" + ctx.getSourceIp();
        }
        throw new AuthorizationException("The request of {} is not support.", context.getClass().getSimpleName());
    }
}

