/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.client;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.client.ConsumerGroupEvent;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.protocol.heartbeat.ConsumeType;
import org.apache.rocketmq.remoting.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public class ConsumerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final ConcurrentMap<String, ConsumerGroupInfo> consumerTable = new ConcurrentHashMap<String, ConsumerGroupInfo>(1024);
    private final ConcurrentMap<String, ConsumerGroupInfo> consumerCompensationTable = new ConcurrentHashMap<String, ConsumerGroupInfo>(1024);
    private final List<ConsumerIdsChangeListener> consumerIdsChangeListenerList = new CopyOnWriteArrayList<ConsumerIdsChangeListener>();
    protected final BrokerStatsManager brokerStatsManager;
    private final long channelExpiredTimeout;
    private final long subscriptionExpiredTimeout;

    public ConsumerManager(ConsumerIdsChangeListener consumerIdsChangeListener, long expiredTimeout) {
        this.consumerIdsChangeListenerList.add(consumerIdsChangeListener);
        this.brokerStatsManager = null;
        this.channelExpiredTimeout = expiredTimeout;
        this.subscriptionExpiredTimeout = expiredTimeout;
    }

    public ConsumerManager(ConsumerIdsChangeListener consumerIdsChangeListener, BrokerStatsManager brokerStatsManager, BrokerConfig brokerConfig) {
        this.consumerIdsChangeListenerList.add(consumerIdsChangeListener);
        this.brokerStatsManager = brokerStatsManager;
        this.channelExpiredTimeout = brokerConfig.getChannelExpiredTimeout();
        this.subscriptionExpiredTimeout = brokerConfig.getSubscriptionExpiredTimeout();
    }

    public ClientChannelInfo findChannel(String group, String clientId) {
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.findChannel(clientId);
        }
        return null;
    }

    public ClientChannelInfo findChannel(String group, Channel channel) {
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.findChannel(channel);
        }
        return null;
    }

    public SubscriptionData findSubscriptionData(String group, String topic) {
        return this.findSubscriptionData(group, topic, true);
    }

    public SubscriptionData findSubscriptionData(String group, String topic, boolean fromCompensationTable) {
        ConsumerGroupInfo consumerGroupCompensationInfo;
        SubscriptionData subscriptionData;
        ConsumerGroupInfo consumerGroupInfo = this.getConsumerGroupInfo(group, false);
        if (consumerGroupInfo != null && (subscriptionData = consumerGroupInfo.findSubscriptionData(topic)) != null) {
            return subscriptionData;
        }
        if (fromCompensationTable && (consumerGroupCompensationInfo = (ConsumerGroupInfo)this.consumerCompensationTable.get(group)) != null) {
            return consumerGroupCompensationInfo.findSubscriptionData(topic);
        }
        return null;
    }

    public ConcurrentMap<String, ConsumerGroupInfo> getConsumerTable() {
        return this.consumerTable;
    }

    public ConsumerGroupInfo getConsumerGroupInfo(String group) {
        return this.getConsumerGroupInfo(group, false);
    }

    public ConsumerGroupInfo getConsumerGroupInfo(String group, boolean fromCompensationTable) {
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (consumerGroupInfo == null && fromCompensationTable) {
            consumerGroupInfo = (ConsumerGroupInfo)this.consumerCompensationTable.get(group);
        }
        return consumerGroupInfo;
    }

    public int findSubscriptionDataCount(String group) {
        ConsumerGroupInfo consumerGroupInfo = this.getConsumerGroupInfo(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.getSubscriptionTable().size();
        }
        return 0;
    }

    public boolean doChannelCloseEvent(String remoteAddr, Channel channel) {
        boolean removed = false;
        for (Map.Entry next : this.consumerTable.entrySet()) {
            ConsumerGroupInfo remove;
            ConsumerGroupInfo info = (ConsumerGroupInfo)next.getValue();
            ClientChannelInfo clientChannelInfo = info.doChannelCloseEvent(remoteAddr, channel);
            if (clientChannelInfo == null) continue;
            this.callConsumerIdsChangeListener(ConsumerGroupEvent.CLIENT_UNREGISTER, (String)next.getKey(), clientChannelInfo, info.getSubscribeTopics());
            if (info.getChannelInfoTable().isEmpty() && (remove = (ConsumerGroupInfo)this.consumerTable.remove(next.getKey())) != null) {
                LOGGER.info("unregister consumer ok, no any connection, and remove consumer group, {}", next.getKey());
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.UNREGISTER, (String)next.getKey(), new Object[0]);
            }
            this.callConsumerIdsChangeListener(ConsumerGroupEvent.CHANGE, (String)next.getKey(), info.getAllChannel());
        }
        return removed;
    }

    public void compensateBasicConsumerInfo(String group, ConsumeType consumeType, MessageModel messageModel) {
        ConsumerGroupInfo consumerGroupInfo = this.consumerCompensationTable.computeIfAbsent(group, ConsumerGroupInfo::new);
        consumerGroupInfo.setConsumeType(consumeType);
        consumerGroupInfo.setMessageModel(messageModel);
    }

    public void compensateSubscribeData(String group, String topic, SubscriptionData subscriptionData) {
        ConsumerGroupInfo consumerGroupInfo = this.consumerCompensationTable.computeIfAbsent(group, ConsumerGroupInfo::new);
        consumerGroupInfo.getSubscriptionTable().put(topic, subscriptionData);
    }

    public boolean registerConsumer(String group, ClientChannelInfo clientChannelInfo, ConsumeType consumeType, MessageModel messageModel, ConsumeFromWhere consumeFromWhere, Set<SubscriptionData> subList, boolean isNotifyConsumerIdsChangedEnable) {
        return this.registerConsumer(group, clientChannelInfo, consumeType, messageModel, consumeFromWhere, subList, isNotifyConsumerIdsChangedEnable, true);
    }

    public boolean registerConsumer(String group, ClientChannelInfo clientChannelInfo, ConsumeType consumeType, MessageModel messageModel, ConsumeFromWhere consumeFromWhere, Set<SubscriptionData> subList, boolean isNotifyConsumerIdsChangedEnable, boolean updateSubscription) {
        boolean r1;
        long start = System.currentTimeMillis();
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (null == consumerGroupInfo) {
            ConsumerGroupInfo tmp = new ConsumerGroupInfo(group, consumeType, messageModel, consumeFromWhere);
            ConsumerGroupInfo prev = this.consumerTable.putIfAbsent(group, tmp);
            ConsumerGroupInfo consumerGroupInfo2 = consumerGroupInfo = prev != null ? prev : tmp;
        }
        if (r1 = consumerGroupInfo.updateChannel(clientChannelInfo, consumeType, messageModel, consumeFromWhere)) {
            this.callConsumerIdsChangeListener(ConsumerGroupEvent.CLIENT_REGISTER, group, clientChannelInfo, subList.stream().map(SubscriptionData::getTopic).collect(Collectors.toSet()));
        }
        boolean r2 = false;
        if (updateSubscription) {
            r2 = consumerGroupInfo.updateSubscription(subList);
        }
        if ((r1 || r2) && isNotifyConsumerIdsChangedEnable) {
            this.callConsumerIdsChangeListener(ConsumerGroupEvent.CHANGE, group, consumerGroupInfo.getAllChannel());
        }
        if (null != this.brokerStatsManager) {
            this.brokerStatsManager.incConsumerRegisterTime((int)(System.currentTimeMillis() - start));
        }
        this.callConsumerIdsChangeListener(ConsumerGroupEvent.REGISTER, group, subList, clientChannelInfo);
        return r1 || r2;
    }

    public boolean registerConsumerWithoutSub(String group, ClientChannelInfo clientChannelInfo, ConsumeType consumeType, MessageModel messageModel, ConsumeFromWhere consumeFromWhere, boolean isNotifyConsumerIdsChangedEnable) {
        boolean updateChannelRst;
        long start = System.currentTimeMillis();
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (null == consumerGroupInfo) {
            ConsumerGroupInfo tmp = new ConsumerGroupInfo(group, consumeType, messageModel, consumeFromWhere);
            ConsumerGroupInfo prev = this.consumerTable.putIfAbsent(group, tmp);
            ConsumerGroupInfo consumerGroupInfo2 = consumerGroupInfo = prev != null ? prev : tmp;
        }
        if ((updateChannelRst = consumerGroupInfo.updateChannel(clientChannelInfo, consumeType, messageModel, consumeFromWhere)) && isNotifyConsumerIdsChangedEnable) {
            this.callConsumerIdsChangeListener(ConsumerGroupEvent.CHANGE, group, consumerGroupInfo.getAllChannel());
        }
        if (null != this.brokerStatsManager) {
            this.brokerStatsManager.incConsumerRegisterTime((int)(System.currentTimeMillis() - start));
        }
        return updateChannelRst;
    }

    public void unregisterConsumer(String group, ClientChannelInfo clientChannelInfo, boolean isNotifyConsumerIdsChangedEnable) {
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (null != consumerGroupInfo) {
            ConsumerGroupInfo remove;
            boolean removed = consumerGroupInfo.unregisterChannel(clientChannelInfo);
            if (removed) {
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.CLIENT_UNREGISTER, group, clientChannelInfo, consumerGroupInfo.getSubscribeTopics());
            }
            if (consumerGroupInfo.getChannelInfoTable().isEmpty() && (remove = (ConsumerGroupInfo)this.consumerTable.remove(group)) != null) {
                LOGGER.info("unregister consumer ok, no any connection, and remove consumer group, {}", (Object)group);
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.UNREGISTER, group, new Object[0]);
            }
            if (isNotifyConsumerIdsChangedEnable) {
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.CHANGE, group, consumerGroupInfo.getAllChannel());
            }
        }
    }

    public void removeExpireConsumerGroupInfo() {
        ArrayList removeList = new ArrayList();
        this.consumerCompensationTable.forEach((group, consumerGroupInfo) -> {
            ArrayList removeTopicList = new ArrayList();
            ConcurrentMap<String, SubscriptionData> subscriptionTable = consumerGroupInfo.getSubscriptionTable();
            subscriptionTable.forEach((topic, subscriptionData) -> {
                long diff = System.currentTimeMillis() - subscriptionData.getSubVersion();
                if (diff > this.subscriptionExpiredTimeout) {
                    removeTopicList.add(topic);
                }
            });
            for (String topic2 : removeTopicList) {
                subscriptionTable.remove(topic2);
                if (!subscriptionTable.isEmpty()) continue;
                removeList.add(group);
            }
        });
        for (String group2 : removeList) {
            this.consumerCompensationTable.remove(group2);
        }
    }

    public void scanNotActiveChannel() {
        Iterator it = this.consumerTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            String group = (String)next.getKey();
            ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)next.getValue();
            ConcurrentMap<Channel, ClientChannelInfo> channelInfoTable = consumerGroupInfo.getChannelInfoTable();
            Iterator itChannel = channelInfoTable.entrySet().iterator();
            while (itChannel.hasNext()) {
                Map.Entry nextChannel = itChannel.next();
                ClientChannelInfo clientChannelInfo = (ClientChannelInfo)nextChannel.getValue();
                long diff = System.currentTimeMillis() - clientChannelInfo.getLastUpdateTimestamp();
                if (diff <= this.channelExpiredTimeout) continue;
                LOGGER.warn("SCAN: remove expired channel from ConsumerManager consumerTable. channel={}, consumerGroup={}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)clientChannelInfo.getChannel()), (Object)group);
                this.callConsumerIdsChangeListener(ConsumerGroupEvent.CLIENT_UNREGISTER, group, clientChannelInfo, consumerGroupInfo.getSubscribeTopics());
                RemotingHelper.closeChannel((Channel)clientChannelInfo.getChannel());
                itChannel.remove();
            }
            if (!channelInfoTable.isEmpty()) continue;
            LOGGER.warn("SCAN: remove expired channel from ConsumerManager consumerTable, all clear, consumerGroup={}", (Object)group);
            it.remove();
        }
        this.removeExpireConsumerGroupInfo();
    }

    public HashSet<String> queryTopicConsumeByWho(String topic) {
        HashSet<String> groups = new HashSet<String>();
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            ConcurrentMap<String, SubscriptionData> subscriptionTable = ((ConsumerGroupInfo)entry.getValue()).getSubscriptionTable();
            if (!subscriptionTable.containsKey(topic)) continue;
            groups.add((String)entry.getKey());
        }
        return groups;
    }

    public void appendConsumerIdsChangeListener(ConsumerIdsChangeListener listener) {
        this.consumerIdsChangeListenerList.add(listener);
    }

    protected void callConsumerIdsChangeListener(ConsumerGroupEvent event, String group, Object ... args) {
        for (ConsumerIdsChangeListener listener : this.consumerIdsChangeListenerList) {
            try {
                listener.handle(event, group, args);
            }
            catch (Throwable t) {
                LOGGER.error("err when call consumerIdsChangeListener", t);
            }
        }
    }
}

