/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.offset;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.offset.RocksDBConsumerOffsetManager;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class RocksDBLmqConsumerOffsetManager
extends RocksDBConsumerOffsetManager {
    private ConcurrentHashMap<String, Long> lmqOffsetTable = new ConcurrentHashMap(512);

    public RocksDBLmqConsumerOffsetManager(BrokerController brokerController) {
        super(brokerController);
    }

    @Override
    public long queryOffset(String group, String topic, int queueId) {
        if (!MixAll.isLmq((String)group)) {
            return super.queryOffset(group, topic, queueId);
        }
        String key = topic + "@" + group;
        Long offset = this.lmqOffsetTable.get(key);
        if (offset != null) {
            return offset;
        }
        return -1L;
    }

    @Override
    public Map<Integer, Long> queryOffset(String group, String topic) {
        if (!MixAll.isLmq((String)group)) {
            return super.queryOffset(group, topic);
        }
        HashMap<Integer, Long> map = new HashMap<Integer, Long>();
        String key = topic + "@" + group;
        Long offset = this.lmqOffsetTable.get(key);
        if (offset != null) {
            map.put(0, offset);
        }
        return map;
    }

    @Override
    public void commitOffset(String clientHost, String group, String topic, int queueId, long offset) {
        if (!MixAll.isLmq((String)group)) {
            super.commitOffset(clientHost, group, topic, queueId, offset);
            return;
        }
        String key = topic + "@" + group;
        this.lmqOffsetTable.put(key, offset);
    }

    @Override
    public String encode() {
        return this.encode(false);
    }

    @Override
    public void decode(String jsonString) {
        RocksDBLmqConsumerOffsetManager obj;
        if (jsonString != null && (obj = (RocksDBLmqConsumerOffsetManager)((Object)RemotingSerializable.fromJson((String)jsonString, RocksDBLmqConsumerOffsetManager.class))) != null) {
            super.setOffsetTable(obj.getOffsetTable());
            this.lmqOffsetTable = obj.lmqOffsetTable;
        }
    }

    @Override
    public String encode(boolean prettyFormat) {
        return RemotingSerializable.toJson((Object)((Object)this), (boolean)prettyFormat);
    }

    public ConcurrentHashMap<String, Long> getLmqOffsetTable() {
        return this.lmqOffsetTable;
    }

    public void setLmqOffsetTable(ConcurrentHashMap<String, Long> lmqOffsetTable) {
        this.lmqOffsetTable = lmqOffsetTable;
    }
}

