/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl;

import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.RejectedExecutionPolicy;
import com.alipay.remoting.RejectionProcessableInvokeCallback;
import com.alipay.remoting.config.BoltClientOption;
import com.alipay.remoting.rpc.exception.InvokeTimeoutException;
import com.alipay.sofa.jraft.ReplicatorGroup;
import com.alipay.sofa.jraft.error.RemotingException;
import com.alipay.sofa.jraft.option.RpcOptions;
import com.alipay.sofa.jraft.rpc.InvokeCallback;
import com.alipay.sofa.jraft.rpc.InvokeContext;
import com.alipay.sofa.jraft.rpc.RpcClient;
import com.alipay.sofa.jraft.rpc.impl.BoltRaftRpcFactory;
import com.alipay.sofa.jraft.rpc.impl.core.ClientServiceConnectionEventProcessor;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.Requires;
import java.util.Map;
import java.util.concurrent.Executor;

public class BoltRpcClient
implements RpcClient {
    public static final String BOLT_CTX = "BOLT_CTX";
    public static final String BOLT_REJECTED_EXECUTION_POLICY = "BOLT_REJECTED_EXECUTION_POLICY";
    private final com.alipay.remoting.rpc.RpcClient rpcClient;
    private RpcOptions opts;

    public BoltRpcClient(com.alipay.remoting.rpc.RpcClient rpcClient) {
        this.rpcClient = Requires.requireNonNull(rpcClient, "rpcClient");
    }

    @Override
    public boolean init(RpcOptions opts) {
        this.opts = opts;
        this.rpcClient.option(BoltClientOption.NETTY_FLUSH_CONSOLIDATION, (Object)true);
        this.rpcClient.initWriteBufferWaterMark(BoltRaftRpcFactory.CHANNEL_WRITE_BUF_LOW_WATER_MARK, BoltRaftRpcFactory.CHANNEL_WRITE_BUF_HIGH_WATER_MARK);
        this.rpcClient.enableReconnectSwitch();
        this.rpcClient.startup();
        return true;
    }

    @Override
    public void shutdown() {
        this.rpcClient.shutdown();
    }

    @Override
    public boolean checkConnection(Endpoint endpoint) {
        Requires.requireNonNull(endpoint, "endpoint");
        return this.rpcClient.checkConnection(endpoint.toString());
    }

    @Override
    public boolean checkConnection(Endpoint endpoint, boolean createIfAbsent) {
        Requires.requireNonNull(endpoint, "endpoint");
        return this.rpcClient.checkConnection(endpoint.toString(), createIfAbsent, true);
    }

    @Override
    public void closeConnection(Endpoint endpoint) {
        Requires.requireNonNull(endpoint, "endpoint");
        this.rpcClient.closeConnection(endpoint.toString());
    }

    @Override
    public void registerConnectEventListener(ReplicatorGroup replicatorGroup) {
        this.rpcClient.addConnectionEventProcessor(ConnectionEventType.CONNECT, (ConnectionEventProcessor)new ClientServiceConnectionEventProcessor(replicatorGroup));
    }

    @Override
    public Object invokeSync(Endpoint endpoint, Object request, InvokeContext ctx, long timeoutMs) throws InterruptedException, RemotingException {
        Requires.requireNonNull(endpoint, "endpoint");
        try {
            return this.rpcClient.invokeSync(endpoint.toString(), request, this.getBoltInvokeCtx(ctx), (int)timeoutMs);
        }
        catch (InvokeTimeoutException e) {
            throw new com.alipay.sofa.jraft.error.InvokeTimeoutException(e);
        }
        catch (com.alipay.remoting.exception.RemotingException e) {
            throw new RemotingException(e);
        }
    }

    @Override
    public void invokeAsync(Endpoint endpoint, Object request, InvokeContext ctx, InvokeCallback callback, long timeoutMs) throws InterruptedException, RemotingException {
        Requires.requireNonNull(endpoint, "endpoint");
        try {
            this.rpcClient.invokeWithCallback(endpoint.toString(), request, this.getBoltInvokeCtx(ctx), (com.alipay.remoting.InvokeCallback)this.getBoltCallback(callback, ctx), (int)timeoutMs);
        }
        catch (InvokeTimeoutException e) {
            throw new com.alipay.sofa.jraft.error.InvokeTimeoutException(e);
        }
        catch (com.alipay.remoting.exception.RemotingException e) {
            throw new RemotingException(e);
        }
    }

    public com.alipay.remoting.rpc.RpcClient getRpcClient() {
        return this.rpcClient;
    }

    private RejectedExecutionPolicy getRejectedPolicy(InvokeContext ctx) {
        return ctx == null ? RejectedExecutionPolicy.CALLER_HANDLE_EXCEPTION : ctx.getOrDefault(BOLT_REJECTED_EXECUTION_POLICY, RejectedExecutionPolicy.CALLER_HANDLE_EXCEPTION);
    }

    private com.alipay.remoting.InvokeContext getBoltInvokeCtx(InvokeContext ctx) {
        if (ctx == null) {
            com.alipay.remoting.InvokeContext boltCtx = new com.alipay.remoting.InvokeContext();
            boltCtx.put("bolt.invoke.crc.switch", (Object)this.opts.isEnableRpcChecksum());
            return boltCtx;
        }
        com.alipay.remoting.InvokeContext boltCtx = (com.alipay.remoting.InvokeContext)ctx.get(BOLT_CTX);
        if (boltCtx != null) {
            return boltCtx;
        }
        boltCtx = new com.alipay.remoting.InvokeContext();
        for (Map.Entry<String, Object> entry : ctx.entrySet()) {
            boltCtx.put(entry.getKey(), entry.getValue());
        }
        Boolean crcSwitch = (Boolean)ctx.get("invoke.crc.switch");
        if (crcSwitch != null) {
            boltCtx.put("bolt.invoke.crc.switch", (Object)crcSwitch);
        }
        return boltCtx;
    }

    private BoltCallback getBoltCallback(InvokeCallback callback, InvokeContext ctx) {
        Requires.requireNonNull(callback, "callback");
        return new BoltCallback(callback, this.getRejectedPolicy(ctx));
    }

    private static class BoltCallback
    implements RejectionProcessableInvokeCallback {
        private final InvokeCallback callback;
        private final RejectedExecutionPolicy rejectedPolicy;

        private BoltCallback(InvokeCallback callback, RejectedExecutionPolicy rejectedPolicy) {
            this.callback = callback;
            this.rejectedPolicy = rejectedPolicy;
        }

        public void onResponse(Object result) {
            this.callback.complete(result, null);
        }

        public void onException(Throwable err) {
            this.callback.complete(null, err);
        }

        public Executor getExecutor() {
            return this.callback.executor();
        }

        public RejectedExecutionPolicy rejectedExecutionPolicy() {
            return this.rejectedPolicy;
        }
    }
}

