/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.rocksdb;

import org.apache.rocketmq.common.config.ConfigHelper;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.rocksdb.ConsumeQueueCompactionFilterFactory;
import org.rocksdb.AbstractCompactionFilterFactory;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionOptionsUniversal;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompactionStopStyle;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.DataBlockIndexType;
import org.rocksdb.Filter;
import org.rocksdb.IndexType;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.LRUCache;
import org.rocksdb.MemTableConfig;
import org.rocksdb.MergeOperator;
import org.rocksdb.RateLimiter;
import org.rocksdb.SkipListMemTableConfig;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.rocksdb.StringAppendOperator;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WALRecoveryMode;

public class RocksDBOptionsFactory {
    public static ColumnFamilyOptions createCQCFOptions(MessageStore messageStore, ConsumeQueueCompactionFilterFactory consumeQueueCompactionFilterFactory) {
        BlockBasedTableConfig blockBasedTableConfig = new BlockBasedTableConfig().setFormatVersion(5).setIndexType(IndexType.kBinarySearch).setDataBlockIndexType(DataBlockIndexType.kDataBlockBinaryAndHash).setDataBlockHashTableUtilRatio(0.75).setBlockSize(32768L).setMetadataBlockSize(4096L).setFilterPolicy((Filter)new BloomFilter(16.0, false)).setCacheIndexAndFilterBlocks(false).setCacheIndexAndFilterBlocksWithHighPriority(true).setPinL0FilterAndIndexBlocksInCache(false).setPinTopLevelIndexAndFilter(true).setBlockCache((Cache)new LRUCache(0x40000000L, 8, false)).setWholeKeyFiltering(true);
        ColumnFamilyOptions columnFamilyOptions = new ColumnFamilyOptions();
        CompactionOptionsUniversal compactionOption = new CompactionOptionsUniversal();
        compactionOption.setSizeRatio(100).setMaxSizeAmplificationPercent(25).setAllowTrivialMove(true).setMinMergeWidth(2).setMaxMergeWidth(Integer.MAX_VALUE).setStopStyle(CompactionStopStyle.CompactionStopStyleTotalSize).setCompressionSizePercent(-1);
        String bottomMostCompressionTypeOpt = messageStore.getMessageStoreConfig().getBottomMostCompressionTypeForConsumeQueueStore();
        String compressionTypeOpt = messageStore.getMessageStoreConfig().getRocksdbCompressionType();
        CompressionType bottomMostCompressionType = CompressionType.getCompressionType((String)bottomMostCompressionTypeOpt);
        CompressionType compressionType = CompressionType.getCompressionType((String)compressionTypeOpt);
        return columnFamilyOptions.setMaxWriteBufferNumber(4).setWriteBufferSize(0x8000000L).setMinWriteBufferNumberToMerge(1).setTableFormatConfig((TableFormatConfig)blockBasedTableConfig).setMemTableConfig((MemTableConfig)new SkipListMemTableConfig()).setCompressionType(compressionType).setBottommostCompressionType(bottomMostCompressionType).setNumLevels(7).setCompactionPriority(CompactionPriority.MinOverlappingRatio).setCompactionStyle(CompactionStyle.UNIVERSAL).setCompactionOptionsUniversal(compactionOption).setMaxCompactionBytes(0x1900000000L).setSoftPendingCompactionBytesLimit(0x1900000000L).setHardPendingCompactionBytesLimit(0x4000000000L).setLevel0FileNumCompactionTrigger(2).setLevel0SlowdownWritesTrigger(8).setLevel0StopWritesTrigger(10).setTargetFileSizeBase(0x10000000L).setTargetFileSizeMultiplier(2).setMergeOperator((MergeOperator)new StringAppendOperator()).setCompactionFilterFactory((AbstractCompactionFilterFactory)consumeQueueCompactionFilterFactory).setReportBgIoStats(true).setOptimizeFiltersForHits(true);
    }

    public static ColumnFamilyOptions createOffsetCFOptions() {
        BlockBasedTableConfig blockBasedTableConfig = new BlockBasedTableConfig().setFormatVersion(5).setIndexType(IndexType.kBinarySearch).setDataBlockIndexType(DataBlockIndexType.kDataBlockBinarySearch).setBlockSize(32768L).setFilterPolicy((Filter)new BloomFilter(16.0, false)).setCacheIndexAndFilterBlocks(false).setCacheIndexAndFilterBlocksWithHighPriority(true).setPinL0FilterAndIndexBlocksInCache(false).setPinTopLevelIndexAndFilter(true).setBlockCache((Cache)new LRUCache(0x8000000L, 8, false)).setWholeKeyFiltering(true);
        ColumnFamilyOptions columnFamilyOptions = new ColumnFamilyOptions();
        return columnFamilyOptions.setMaxWriteBufferNumber(4).setWriteBufferSize(0x4000000L).setMinWriteBufferNumberToMerge(1).setTableFormatConfig((TableFormatConfig)blockBasedTableConfig).setMemTableConfig((MemTableConfig)new SkipListMemTableConfig()).setCompressionType(CompressionType.NO_COMPRESSION).setNumLevels(7).setCompactionStyle(CompactionStyle.LEVEL).setLevel0FileNumCompactionTrigger(2).setLevel0SlowdownWritesTrigger(8).setLevel0StopWritesTrigger(10).setTargetFileSizeBase(0x4000000L).setTargetFileSizeMultiplier(2).setMaxBytesForLevelBase(0x10000000L).setMaxBytesForLevelMultiplier(2.0).setMergeOperator((MergeOperator)new StringAppendOperator()).setInplaceUpdateSupport(true);
    }

    public static ColumnFamilyOptions createPopCFOptions() {
        BlockBasedTableConfig blockBasedTableConfig = new BlockBasedTableConfig().setFormatVersion(5).setIndexType(IndexType.kBinarySearch).setDataBlockIndexType(DataBlockIndexType.kDataBlockBinaryAndHash).setDataBlockHashTableUtilRatio(0.75).setBlockSize(32768L).setMetadataBlockSize(4096L).setFilterPolicy((Filter)new BloomFilter(16.0, false)).setCacheIndexAndFilterBlocks(false).setCacheIndexAndFilterBlocksWithHighPriority(true).setPinL0FilterAndIndexBlocksInCache(false).setPinTopLevelIndexAndFilter(true).setBlockCache((Cache)new LRUCache(0x40000000L, 8, false)).setWholeKeyFiltering(true);
        CompactionOptionsUniversal compactionOption = new CompactionOptionsUniversal().setSizeRatio(100).setMaxSizeAmplificationPercent(25).setAllowTrivialMove(true).setMinMergeWidth(2).setMaxMergeWidth(Integer.MAX_VALUE).setStopStyle(CompactionStopStyle.CompactionStopStyleTotalSize).setCompressionSizePercent(-1);
        return new ColumnFamilyOptions().setMaxWriteBufferNumber(4).setWriteBufferSize(0x8000000L).setMinWriteBufferNumberToMerge(1).setTableFormatConfig((TableFormatConfig)blockBasedTableConfig).setMemTableConfig((MemTableConfig)new SkipListMemTableConfig()).setCompressionType(CompressionType.NO_COMPRESSION).setBottommostCompressionType(CompressionType.NO_COMPRESSION).setNumLevels(7).setCompactionPriority(CompactionPriority.MinOverlappingRatio).setCompactionStyle(CompactionStyle.UNIVERSAL).setCompactionOptionsUniversal(compactionOption).setMaxCompactionBytes(0x1900000000L).setSoftPendingCompactionBytesLimit(0x1900000000L).setHardPendingCompactionBytesLimit(0x4000000000L).setLevel0FileNumCompactionTrigger(2).setLevel0SlowdownWritesTrigger(8).setLevel0StopWritesTrigger(10).setTargetFileSizeBase(0x10000000L).setTargetFileSizeMultiplier(2).setMergeOperator((MergeOperator)new StringAppendOperator()).setReportBgIoStats(true).setOptimizeFiltersForHits(true);
    }

    public static DBOptions createDBOptions() {
        DBOptions options = new DBOptions();
        Statistics statistics = new Statistics();
        statistics.setStatsLevel(StatsLevel.EXCEPT_DETAILED_TIMERS);
        return options.setDbLogDir(ConfigHelper.getDBLogDir()).setInfoLogLevel(InfoLogLevel.INFO_LEVEL).setWalRecoveryMode(WALRecoveryMode.PointInTimeRecovery).setManualWalFlush(true).setCreateIfMissing(true).setBytesPerSync(0x100000L).setCreateMissingColumnFamilies(true).setMaxOpenFiles(-1).setMaxLogFileSize(0x40000000L).setKeepLogFileNum(5L).setMaxManifestFileSize(0x40000000L).setAllowConcurrentMemtableWrite(false).setStatistics(statistics).setAtomicFlush(true).setCompactionReadaheadSize(0x400000L).setMaxBackgroundJobs(32).setMaxSubcompactions(8).setParanoidChecks(true).setDelayedWriteRate(0x1000000L).setRateLimiter(new RateLimiter(0x6400000L)).setUseDirectIoForFlushAndCompaction(false).setUseDirectReads(false);
    }
}

