/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.retry;

import apache.rocketmq.v2.ExponentialBackoff;
import apache.rocketmq.v2.RetryPolicy;
import java.time.Duration;
import org.apache.rocketmq.client.java.retry.RetryPolicy;
import org.apache.rocketmq.shaded.com.google.common.base.MoreObjects;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;
import org.apache.rocketmq.shaded.com.google.protobuf.util.Durations;

public class ExponentialBackoffRetryPolicy
implements RetryPolicy {
    private final int maxAttempts;
    private final Duration initialBackoff;
    private final Duration maxBackoff;
    private final double backoffMultiplier;

    public ExponentialBackoffRetryPolicy(int maxAttempts, Duration initialBackoff, Duration maxBackoff, double backoffMultiplier) {
        this.maxAttempts = maxAttempts;
        this.initialBackoff = initialBackoff;
        this.maxBackoff = maxBackoff;
        this.backoffMultiplier = backoffMultiplier;
    }

    public static ExponentialBackoffRetryPolicy immediatelyRetryPolicy(int maxAttempts) {
        return new ExponentialBackoffRetryPolicy(maxAttempts, Duration.ZERO, Duration.ZERO, 1.0);
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public Duration getNextAttemptDelay(int attempt) {
        Preconditions.checkArgument(attempt > 0, "attempt must be positive");
        double delayNanos = Math.min((double)this.initialBackoff.toNanos() * Math.pow(this.backoffMultiplier, 1.0 * (double)(attempt - 1)), (double)this.maxBackoff.toNanos());
        if (delayNanos <= 0.0) {
            return Duration.ZERO;
        }
        return Duration.ofNanos((long)delayNanos);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("maxAttempts", this.maxAttempts).add("initialBackoff", this.initialBackoff).add("maxBackoff", this.maxBackoff).add("backoffMultiplier", this.backoffMultiplier).toString();
    }

    public static ExponentialBackoffRetryPolicy fromProtobuf(apache.rocketmq.v2.RetryPolicy retryPolicy) {
        if (!RetryPolicy.StrategyCase.EXPONENTIAL_BACKOFF.equals(retryPolicy.getStrategyCase())) {
            throw new IllegalArgumentException();
        }
        ExponentialBackoff exponentialBackoff = retryPolicy.getExponentialBackoff();
        return new ExponentialBackoffRetryPolicy(retryPolicy.getMaxAttempts(), Duration.ofNanos(Durations.toNanos(exponentialBackoff.getInitial())), Duration.ofNanos(Durations.toNanos(exponentialBackoff.getMax())), exponentialBackoff.getMultiplier());
    }

    @Override
    public RetryPolicy updateBackoff(apache.rocketmq.v2.RetryPolicy retryPolicy) {
        if (!RetryPolicy.StrategyCase.EXPONENTIAL_BACKOFF.equals(retryPolicy.getStrategyCase())) {
            throw new IllegalArgumentException("strategy must be exponential backoff");
        }
        return this.updateBackoff(retryPolicy.getExponentialBackoff());
    }

    private RetryPolicy updateBackoff(ExponentialBackoff backoff) {
        return new ExponentialBackoffRetryPolicy(this.maxAttempts, Duration.ofNanos(Durations.toNanos(backoff.getInitial())), Duration.ofNanos(Durations.toNanos(backoff.getMax())), backoff.getMultiplier());
    }

    @Override
    public apache.rocketmq.v2.RetryPolicy toProtobuf() {
        ExponentialBackoff exponentialBackoff = ExponentialBackoff.newBuilder().setMultiplier((float)this.backoffMultiplier).setMax(Durations.fromNanos(this.maxBackoff.toNanos())).setInitial(Durations.fromNanos(this.initialBackoff.toNanos())).build();
        return apache.rocketmq.v2.RetryPolicy.newBuilder().setMaxAttempts(this.maxAttempts).setExponentialBackoff(exponentialBackoff).build();
    }
}

