/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.session.notify;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rocketmq.mqtt.common.model.MessageEvent;
import org.apache.rocketmq.mqtt.common.model.Queue;
import org.apache.rocketmq.mqtt.common.model.Subscription;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;
import org.apache.rocketmq.mqtt.cs.session.QueueFresh;
import org.apache.rocketmq.mqtt.cs.session.Session;
import org.apache.rocketmq.mqtt.cs.session.loop.QueueCache;
import org.apache.rocketmq.mqtt.cs.session.loop.SessionLoop;
import org.apache.rocketmq.mqtt.cs.session.match.MatchAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageNotifyAction {
    private static Logger logger = LoggerFactory.getLogger(MessageNotifyAction.class);
    @Resource
    private MatchAction matchAction;
    @Resource
    private SessionLoop sessionLoop;
    @Resource
    private QueueCache queueCache;
    @Resource
    private QueueFresh queueFresh;

    public void notify(List<MessageEvent> events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        for (MessageEvent event : events) {
            Set<Pair<Session, Subscription>> result = this.matchAction.matchClients(TopicUtils.normalizeTopic((String)event.getPubTopic()), event.getNamespace());
            if (result == null || result.isEmpty()) continue;
            for (Pair<Session, Subscription> pair : result) {
                Subscription subscription;
                Session session = (Session)pair.getLeft();
                Set<Queue> set = this.queueFresh.freshQueue(session, subscription = (Subscription)pair.getRight());
                if (set == null || set.isEmpty()) continue;
                for (Queue queue : set) {
                    if (!this.isTargetQueue(queue, event)) continue;
                    this.queueCache.refreshCache((Pair<Queue, Session>)Pair.of((Object)queue, (Object)session));
                    this.sessionLoop.notifyPullMessage(session, subscription, queue);
                }
            }
        }
    }

    private boolean isTargetQueue(Queue queue, MessageEvent event) {
        return Objects.equals(queue.getBrokerName(), event.getBrokerName());
    }
}

