/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swf.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.problems.FileIOProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.SWFCSMTextSettingsWrongReferenceTypeProblem;
import org.apache.royale.compiler.problems.SWFCharacterIDNotFoundProblem;
import org.apache.royale.compiler.problems.SWFDefineFontAlignZonesLinkToIncorrectFontProblem;
import org.apache.royale.compiler.problems.SWFFrameCountMismatchProblem;
import org.apache.royale.compiler.problems.SWFInvalidSignatureProblem;
import org.apache.royale.compiler.problems.SWFTagLengthTooLongProblem;
import org.apache.royale.compiler.problems.SWFUnableToReadTagBodyProblem;
import org.apache.royale.compiler.problems.SWFUnexpectedEndOfFileProblem;
import org.apache.royale.compiler.problems.SWFUnknownFillStyleProblem;
import org.apache.royale.swf.Header;
import org.apache.royale.swf.ISWF;
import org.apache.royale.swf.ITagContainer;
import org.apache.royale.swf.SWF;
import org.apache.royale.swf.SWFFrame;
import org.apache.royale.swf.TagType;
import org.apache.royale.swf.io.ISWFReader;
import org.apache.royale.swf.io.InputBitStream;
import org.apache.royale.swf.tags.CSMTextSettingsTag;
import org.apache.royale.swf.tags.CharacterTag;
import org.apache.royale.swf.tags.DefineBinaryDataTag;
import org.apache.royale.swf.tags.DefineBitsJPEG2Tag;
import org.apache.royale.swf.tags.DefineBitsJPEG3Tag;
import org.apache.royale.swf.tags.DefineBitsLossless2Tag;
import org.apache.royale.swf.tags.DefineBitsLosslessTag;
import org.apache.royale.swf.tags.DefineBitsTag;
import org.apache.royale.swf.tags.DefineButton2Tag;
import org.apache.royale.swf.tags.DefineButtonSoundTag;
import org.apache.royale.swf.tags.DefineButtonTag;
import org.apache.royale.swf.tags.DefineEditTextTag;
import org.apache.royale.swf.tags.DefineFont2Tag;
import org.apache.royale.swf.tags.DefineFont3Tag;
import org.apache.royale.swf.tags.DefineFont4Tag;
import org.apache.royale.swf.tags.DefineFontAlignZonesTag;
import org.apache.royale.swf.tags.DefineFontInfo2Tag;
import org.apache.royale.swf.tags.DefineFontInfoTag;
import org.apache.royale.swf.tags.DefineFontNameTag;
import org.apache.royale.swf.tags.DefineFontTag;
import org.apache.royale.swf.tags.DefineMorphShape2Tag;
import org.apache.royale.swf.tags.DefineMorphShapeTag;
import org.apache.royale.swf.tags.DefineScalingGridTag;
import org.apache.royale.swf.tags.DefineSceneAndFrameLabelDataTag;
import org.apache.royale.swf.tags.DefineShape2Tag;
import org.apache.royale.swf.tags.DefineShape3Tag;
import org.apache.royale.swf.tags.DefineShape4Tag;
import org.apache.royale.swf.tags.DefineShapeTag;
import org.apache.royale.swf.tags.DefineSoundTag;
import org.apache.royale.swf.tags.DefineSpriteTag;
import org.apache.royale.swf.tags.DefineTextTag;
import org.apache.royale.swf.tags.DefineVideoStreamTag;
import org.apache.royale.swf.tags.DoABCTag;
import org.apache.royale.swf.tags.EnableDebugger2Tag;
import org.apache.royale.swf.tags.EnableTelemetryTag;
import org.apache.royale.swf.tags.EndTag;
import org.apache.royale.swf.tags.ExportAssetsTag;
import org.apache.royale.swf.tags.FileAttributesTag;
import org.apache.royale.swf.tags.FrameLabelTag;
import org.apache.royale.swf.tags.ICharacterTag;
import org.apache.royale.swf.tags.IDefineFontTag;
import org.apache.royale.swf.tags.IManagedTag;
import org.apache.royale.swf.tags.ITag;
import org.apache.royale.swf.tags.JPEGTablesTag;
import org.apache.royale.swf.tags.MetadataTag;
import org.apache.royale.swf.tags.PlaceObject2Tag;
import org.apache.royale.swf.tags.PlaceObject3Tag;
import org.apache.royale.swf.tags.PlaceObjectTag;
import org.apache.royale.swf.tags.ProductInfoTag;
import org.apache.royale.swf.tags.RawTag;
import org.apache.royale.swf.tags.RemoveObject2Tag;
import org.apache.royale.swf.tags.RemoveObjectTag;
import org.apache.royale.swf.tags.ScriptLimitsTag;
import org.apache.royale.swf.tags.SetBackgroundColorTag;
import org.apache.royale.swf.tags.SetTabIndexTag;
import org.apache.royale.swf.tags.ShowFrameTag;
import org.apache.royale.swf.tags.SoundStreamBlockTag;
import org.apache.royale.swf.tags.SoundStreamHead2Tag;
import org.apache.royale.swf.tags.SoundStreamHeadTag;
import org.apache.royale.swf.tags.StartSound2Tag;
import org.apache.royale.swf.tags.StartSoundTag;
import org.apache.royale.swf.tags.SymbolClassTag;
import org.apache.royale.swf.tags.VideoFrameTag;
import org.apache.royale.swf.types.BevelFilter;
import org.apache.royale.swf.types.BlurFilter;
import org.apache.royale.swf.types.ButtonRecord;
import org.apache.royale.swf.types.CXForm;
import org.apache.royale.swf.types.CXFormWithAlpha;
import org.apache.royale.swf.types.ClipActions;
import org.apache.royale.swf.types.ConvolutionFilter;
import org.apache.royale.swf.types.CurvedEdgeRecord;
import org.apache.royale.swf.types.DropShadowFilter;
import org.apache.royale.swf.types.FillStyle;
import org.apache.royale.swf.types.FillStyleArray;
import org.apache.royale.swf.types.Filter;
import org.apache.royale.swf.types.FocalGradient;
import org.apache.royale.swf.types.GlowFilter;
import org.apache.royale.swf.types.GlyphEntry;
import org.apache.royale.swf.types.GradRecord;
import org.apache.royale.swf.types.Gradient;
import org.apache.royale.swf.types.GradientBevelFilter;
import org.apache.royale.swf.types.GradientGlowFilter;
import org.apache.royale.swf.types.IFillStyle;
import org.apache.royale.swf.types.ILineStyle;
import org.apache.royale.swf.types.KerningRecord;
import org.apache.royale.swf.types.LineStyle;
import org.apache.royale.swf.types.LineStyle2;
import org.apache.royale.swf.types.LineStyleArray;
import org.apache.royale.swf.types.Matrix;
import org.apache.royale.swf.types.MorphFillStyle;
import org.apache.royale.swf.types.MorphGradRecord;
import org.apache.royale.swf.types.MorphGradient;
import org.apache.royale.swf.types.MorphLineStyle;
import org.apache.royale.swf.types.MorphLineStyle2;
import org.apache.royale.swf.types.RGB;
import org.apache.royale.swf.types.RGBA;
import org.apache.royale.swf.types.Rect;
import org.apache.royale.swf.types.Shape;
import org.apache.royale.swf.types.ShapeRecord;
import org.apache.royale.swf.types.ShapeWithStyle;
import org.apache.royale.swf.types.SoundEnvelope;
import org.apache.royale.swf.types.SoundInfo;
import org.apache.royale.swf.types.StraightEdgeRecord;
import org.apache.royale.swf.types.StyleChangeRecord;
import org.apache.royale.swf.types.Styles;
import org.apache.royale.swf.types.TextRecord;
import org.apache.royale.swf.types.ZoneData;
import org.apache.royale.swf.types.ZoneRecord;
import org.apache.royale.utils.FilenameNormalization;

public class SWFReader
implements ISWFReader,
ITagContainer {
    public static final InvalidTag INVALID_TAG = new InvalidTag();
    protected static final int MASK_TAG_LENGTH = 63;
    protected static final int BITS_TAG_LENGTH = 6;
    private static final int UI16_LENGTH = 2;
    private static final int SI32_LENGTH = 4;
    protected InputBitStream bitStream;
    protected SWF swf;
    private String swfPath;
    private final Map<Integer, ICharacterTag> dictionary;
    private final boolean buildFrames;
    protected final List<ITag> tags;
    protected final Collection<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();

    public SWFReader() {
        this(true);
    }

    public SWFReader(boolean isBuildFrames) {
        this.buildFrames = isBuildFrames;
        this.tags = new ArrayList<ITag>();
        this.dictionary = new HashMap<Integer, ICharacterTag>();
        this.swf = new SWF();
    }

    @Override
    public ISWF readFrom(InputStream input, String path) {
        int foundFrames;
        int expectedFrames;
        assert (input != null && path != null);
        this.swfPath = FilenameNormalization.normalize(path);
        this.bitStream = new InputBitStream(input);
        try {
            if (this.readHeader()) {
                this.readTags();
            }
        }
        catch (IOException e) {
            this.problems.add(new FileIOProblem(e));
        }
        if (this.buildFrames && (expectedFrames = this.swf.getFrameCount()) != (foundFrames = this.swf.getFrames().size())) {
            this.problems.add(new SWFFrameCountMismatchProblem(expectedFrames, foundFrames, this.swfPath));
        }
        return this.swf;
    }

    public ISWF getSWF() {
        return this.swf;
    }

    @Override
    public Collection<ICompilerProblem> getProblems() {
        return this.problems;
    }

    private ITag nextTag() throws IOException {
        TagHeader header = this.nextTagHeader();
        return this.readTag(header);
    }

    protected void readTags() throws IOException {
        ITag tag;
        SWFFrame currentFrame;
        SWFFrame sWFFrame = currentFrame = this.buildFrames ? new SWFFrame() : null;
        do {
            if ((tag = this.nextTag()) == null) continue;
            if (tag instanceof ICharacterTag) {
                this.addToDictionary((ICharacterTag)tag);
            }
            this.tags.add(tag);
            if (!this.buildFrames) continue;
            currentFrame = this.buildFramesFromTags(currentFrame, tag);
        } while (tag == null || tag.getTagType() != TagType.End);
    }

    protected TagHeader nextTagHeader() {
        try {
            this.bitStream.setReadBoundary(this.bitStream.getOffset() + 2L);
            int tagCodeAndLength = this.bitStream.readUI16();
            TagType tagType = TagType.getTagType(tagCodeAndLength >>> 6);
            int tagLength = tagCodeAndLength & 0x3F;
            if (tagLength == 63) {
                this.bitStream.setReadBoundary(this.bitStream.getOffset() + 4L);
                tagLength = this.bitStream.readSI32();
            }
            return new TagHeader(tagType, tagLength);
        }
        catch (Exception e) {
            this.problems.add(new SWFUnexpectedEndOfFileProblem(this.swfPath));
            return new TagHeader(TagType.End, 0);
        }
    }

    protected ITag readTag(TagHeader header) throws IOException {
        this.bitStream.setReadBoundary(this.bitStream.getOffset() + (long)header.length);
        ITag tag = null;
        try {
            tag = this.readTagBody(header.type);
        }
        catch (RuntimeException e) {
            this.problems.add(new SWFUnableToReadTagBodyProblem(header.type.getValue(), header.length, this.swfPath, this.bitStream.getOffset()));
        }
        catch (MalformedTagException e) {
            // empty catch block
        }
        if (this.bitStream.getOffset() < this.bitStream.getReadBoundary()) {
            try {
                boolean nonZeroBytes = false;
                long oldOffset = this.bitStream.getOffset();
                while (this.bitStream.getOffset() < this.bitStream.getReadBoundary()) {
                    if (this.bitStream.readByte() == 0) continue;
                    nonZeroBytes = true;
                }
                if (nonZeroBytes) {
                    this.problems.add(new SWFTagLengthTooLongProblem(header.type.getValue(), this.swfPath, oldOffset, this.bitStream.getReadBoundary()));
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return tag;
    }

    private void addToDictionary(ICharacterTag tag) {
        this.dictionary.put(tag.getCharacterID(), tag);
    }

    private SWFFrame buildFramesFromTags(SWFFrame currentFrame, ITag tag) {
        block14: {
            block13: {
                if (!(tag instanceof IManagedTag)) break block13;
                switch (tag.getTagType()) {
                    case ShowFrame: {
                        this.swf.addFrame(currentFrame);
                        currentFrame = new SWFFrame();
                        break block14;
                    }
                    case FrameLabel: {
                        FrameLabelTag frameLabel = (FrameLabelTag)tag;
                        currentFrame.setName(frameLabel.getName(), frameLabel.isNamedAnchorTag());
                        break block14;
                    }
                    case Metadata: {
                        this.swf.setMetadata(((MetadataTag)tag).getMetadata());
                        break block14;
                    }
                    case FileAttributes: {
                        FileAttributesTag fileAttributes = (FileAttributesTag)tag;
                        this.swf.setUseAS3(fileAttributes.isAS3());
                        this.swf.setUseDirectBlit(fileAttributes.isUseDirectBlit());
                        this.swf.setUseGPU(fileAttributes.isUseGPU());
                        this.swf.setUseNetwork(fileAttributes.isUseNetwork());
                        break block14;
                    }
                    case SetBackgroundColor: {
                        this.swf.setBackgroundColor(((SetBackgroundColorTag)tag).getColor());
                        break block14;
                    }
                    case SymbolClass: {
                        SymbolClassTag symbolClass = (SymbolClassTag)tag;
                        for (String name : symbolClass.getSymbolNames()) {
                            ICharacterTag exportedCharacter = symbolClass.getSymbol(name);
                            currentFrame.defineSymbol(exportedCharacter, name, this.dictionary);
                        }
                        break block14;
                    }
                    case EnableDebugger2: {
                        this.swf.setEnableDebugger2((EnableDebugger2Tag)tag);
                        break block14;
                    }
                    case ProductInfo: {
                        this.swf.setProductInfo((ProductInfoTag)tag);
                        break block14;
                    }
                    case DefineSceneAndFrameLabelData: 
                    case ScriptLimits: 
                    case ExportAssets: 
                    case ImportAssets: 
                    case End: {
                        break block14;
                    }
                    default: {
                        assert (false) : "Unhandled managed tag: " + tag;
                        break block14;
                    }
                }
            }
            currentFrame.addTag(tag);
        }
        return currentFrame;
    }

    @Override
    public void close() throws IOException {
        if (this.bitStream != null) {
            this.bitStream.close();
        }
    }

    private ICharacterTag getTagById(int id, TagType tagType) throws MalformedTagException {
        if (this.dictionary.containsKey(id)) {
            return this.dictionary.get(id);
        }
        if (id != 65535) {
            this.problems.add(new SWFCharacterIDNotFoundProblem(id, tagType.getValue(), this.swfPath, this.bitStream.getOffset()));
            throw new MalformedTagException();
        }
        return INVALID_TAG;
    }

    @Override
    public Iterator<ITag> iterator() {
        return this.tags.iterator();
    }

    private CXFormWithAlpha readColorTransformWithAlpha() {
        this.bitStream.byteAlign();
        CXFormWithAlpha cxFormWithAlpha = new CXFormWithAlpha();
        boolean hasAddTerms = this.bitStream.readBit();
        boolean hasMultTerms = this.bitStream.readBit();
        int nbits = this.bitStream.readUB(4);
        if (hasMultTerms) {
            cxFormWithAlpha.setMultTerm(this.bitStream.readSB(nbits), this.bitStream.readSB(nbits), this.bitStream.readSB(nbits), this.bitStream.readSB(nbits));
        }
        if (hasAddTerms) {
            cxFormWithAlpha.setAddTerm(this.bitStream.readSB(nbits), this.bitStream.readSB(nbits), this.bitStream.readSB(nbits), this.bitStream.readSB(nbits));
        }
        return cxFormWithAlpha;
    }

    private CurvedEdgeRecord readCurvedEdgeRecord() throws IOException {
        CurvedEdgeRecord curvedEdgeRecord = new CurvedEdgeRecord();
        int nbits = 2 + this.bitStream.readUB(4);
        curvedEdgeRecord.setControlDeltaX(this.bitStream.readSB(nbits));
        curvedEdgeRecord.setControlDeltaY(this.bitStream.readSB(nbits));
        curvedEdgeRecord.setAnchorDeltaX(this.bitStream.readSB(nbits));
        curvedEdgeRecord.setAnchorDeltaY(this.bitStream.readSB(nbits));
        return curvedEdgeRecord;
    }

    private DefineBinaryDataTag readDefineBinaryData() throws IOException {
        int characterId = this.bitStream.readUI16();
        this.bitStream.readUI32();
        byte[] data = this.bitStream.readToBoundary();
        DefineBinaryDataTag result = new DefineBinaryDataTag(data);
        result.setCharacterID(characterId);
        return result;
    }

    private DefineBitsLosslessTag readDefineBitsLossless() throws IOException {
        return this.readDefineBitsLossless(new DefineBitsLosslessTag());
    }

    private DefineBitsLossless2Tag readDefineBitsLossless2() throws IOException {
        return (DefineBitsLossless2Tag)this.readDefineBitsLossless(new DefineBitsLossless2Tag());
    }

    private DefineBitsLosslessTag readDefineBitsLossless(DefineBitsLosslessTag tag) throws IOException {
        tag.setCharacterID(this.bitStream.readUI16());
        tag.setBitmapFormat(this.bitStream.readUI8());
        tag.setBitmapWidth(this.bitStream.readUI16());
        tag.setBitmapHeight(this.bitStream.readUI16());
        if (tag.getBitmapFormat() == 3) {
            tag.setBitmapColorTableSize(this.bitStream.readUI8() + 1);
        }
        tag.setZlibBitmapData(this.bitStream.readToBoundary());
        this.addToDictionary(tag);
        return tag;
    }

    private DefineScalingGridTag readDefineScalingGrid() throws MalformedTagException {
        int characterId = this.bitStream.readUI16();
        ICharacterTag character = this.getTagById(characterId, TagType.DefineScalingGrid);
        Rect splitter = this.readRect();
        return new DefineScalingGridTag(character, splitter);
    }

    private ITag readDefineSceneAndFrameLabelData() {
        DefineSceneAndFrameLabelDataTag tag = new DefineSceneAndFrameLabelDataTag();
        long sceneCount = this.bitStream.readEncodedU32();
        for (long i = 0L; i < sceneCount; ++i) {
            long offset = this.bitStream.readEncodedU32();
            String name = this.bitStream.readString();
            tag.addScene(name, offset);
        }
        long frameLabelCount = this.bitStream.readEncodedU32();
        for (long i = 0L; i < frameLabelCount; ++i) {
            long frameNum = this.bitStream.readEncodedU32();
            String frameLabel = this.bitStream.readString();
            tag.addFrame(frameLabel, frameNum);
        }
        return tag;
    }

    private DefineShapeTag readDefineShape() throws IOException, MalformedTagException {
        DefineShapeTag tag = new DefineShapeTag();
        tag.setCharacterID(this.bitStream.readUI16());
        tag.setShapeBounds(this.readRect());
        ShapeWithStyle shapeWithStyle = this.readShapeWithStyle(TagType.DefineShape);
        tag.setShapes(shapeWithStyle);
        return tag;
    }

    private DefineShape2Tag readDefineShape2() throws IOException, MalformedTagException {
        DefineShape2Tag tag = new DefineShape2Tag();
        tag.setCharacterID(this.bitStream.readUI16());
        tag.setShapeBounds(this.readRect());
        ShapeWithStyle shapeWithStyle = this.readShapeWithStyle(TagType.DefineShape2);
        tag.setShapes(shapeWithStyle);
        return tag;
    }

    private DefineShape3Tag readDefineShape3() throws IOException, MalformedTagException {
        DefineShape3Tag tag = new DefineShape3Tag();
        tag.setCharacterID(this.bitStream.readUI16());
        tag.setShapeBounds(this.readRect());
        ShapeWithStyle shapeWithStyle = this.readShapeWithStyle(TagType.DefineShape3);
        tag.setShapes(shapeWithStyle);
        return tag;
    }

    private DefineShape4Tag readDefineShape4() throws IOException, MalformedTagException {
        DefineShape4Tag tag = new DefineShape4Tag();
        tag.setCharacterID(this.bitStream.readUI16());
        tag.setShapeBounds(this.readRect());
        tag.setEdgeBounds(this.readRect());
        this.bitStream.readUB(5);
        tag.setUsesFillWindingRule(this.bitStream.readBit());
        tag.setUsesNonScalingStrokes(this.bitStream.readBit());
        tag.setUsesScalingStrokes(this.bitStream.readBit());
        ShapeWithStyle shapeWithStyle = this.readShapeWithStyle(TagType.DefineShape4);
        tag.setShapes(shapeWithStyle);
        return tag;
    }

    private DefineSpriteTag readDefineSprite() throws IOException {
        ITag spriteTag;
        long boundary = this.bitStream.getReadBoundary();
        int spriteId = this.bitStream.readUI16();
        int frameCount = this.bitStream.readUI16();
        ArrayList<ITag> spriteTags = new ArrayList<ITag>();
        do {
            if ((spriteTag = this.nextTag()) == null || spriteTag.getTagType() == TagType.End) continue;
            spriteTags.add(spriteTag);
        } while (spriteTag == null || spriteTag.getTagType() != TagType.End);
        this.bitStream.setReadBoundary(boundary);
        DefineSpriteTag sprite = new DefineSpriteTag(frameCount, spriteTags);
        sprite.setCharacterID(spriteId);
        return sprite;
    }

    protected DoABCTag readDoABC() throws IOException {
        long flag = this.bitStream.readUI32();
        String name = this.bitStream.readString();
        byte[] abcData = this.bitStream.readToBoundary();
        return new DoABCTag(flag, name, abcData);
    }

    private EnableDebugger2Tag readEnableDebugger2() {
        this.bitStream.readUI16();
        return new EnableDebugger2Tag(this.bitStream.readString());
    }

    private EnableTelemetryTag readEnableTelemetry() {
        this.bitStream.readUI16();
        String password = this.bitStream.readString();
        return new EnableTelemetryTag(password);
    }

    private EndTag readEnd() {
        return new EndTag();
    }

    private ExportAssetsTag readExportAssets() throws MalformedTagException {
        ExportAssetsTag tag = new ExportAssetsTag();
        int count = this.bitStream.readUI16();
        for (int i = 0; i < count; ++i) {
            int id = this.bitStream.readUI16();
            String name = this.bitStream.readString();
            tag.addExport(this.getTagById(id, tag.getTagType()), name);
        }
        return tag;
    }

    private FileAttributesTag readFileAttributes() {
        FileAttributesTag tag = new FileAttributesTag();
        this.bitStream.readUB(1);
        tag.setUseDirectBlit(this.bitStream.readBit());
        tag.setUseGPU(this.bitStream.readBit());
        tag.setHasMetadata(this.bitStream.readBit());
        tag.setAS3(this.bitStream.readBit());
        this.bitStream.readUB(2);
        tag.setUseNetwork(this.bitStream.readBit());
        this.bitStream.readUB(24);
        return tag;
    }

    private IFillStyle readFillStyle(TagType tagType) throws MalformedTagException {
        switch (tagType) {
            case DefineMorphShape: 
            case DefineMorphShape2: {
                return this.readMorphFillStyle(tagType);
            }
        }
        return this.readStandardFillStyle(tagType);
    }

    private FillStyle readStandardFillStyle(TagType tagType) throws MalformedTagException {
        FillStyle s = new FillStyle();
        short type = this.bitStream.readUI8();
        s.setFillStyleType(type);
        block0 : switch (type) {
            case 0: {
                switch (tagType) {
                    case DefineShape3: 
                    case DefineShape4: {
                        s.setColor(this.readRGBA());
                        break block0;
                    }
                    case DefineShape2: 
                    case DefineShape: {
                        s.setColor(this.readRGB());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid tag: " + (Object)((Object)tagType));
            }
            case 16: 
            case 18: {
                s.setGradientMatrix(this.readMatrix());
                s.setGradient(this.readGradient(tagType));
                break;
            }
            case 19: {
                s.setGradientMatrix(this.readMatrix());
                s.setGradient(this.readFocalGradient(tagType));
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                int idref = this.bitStream.readUI16();
                s.setBitmapCharacter(this.getTagById(idref, tagType));
                s.setBitmapMatrix(this.readMatrix());
                break;
            }
            default: {
                this.problems.add(new SWFUnknownFillStyleProblem(type, false, this.swfPath, this.bitStream.getOffset()));
                throw new MalformedTagException();
            }
        }
        return s;
    }

    private FillStyleArray readFillStyleArray(TagType tagType) throws MalformedTagException {
        FillStyleArray fillStyleArray = new FillStyleArray();
        int count = this.readExtensibleCount();
        for (int i = 0; i < count; ++i) {
            IFillStyle fillStyle = this.readFillStyle(tagType);
            fillStyleArray.add(fillStyle);
        }
        return fillStyleArray;
    }

    private FocalGradient readFocalGradient(TagType tagType) {
        this.bitStream.byteAlign();
        FocalGradient gradient = new FocalGradient();
        gradient.setSpreadMode(this.bitStream.readUB(2));
        gradient.setInterpolationMode(this.bitStream.readUB(2));
        int numGradients = this.bitStream.readUB(4);
        for (int i = 0; i < numGradients; ++i) {
            gradient.getGradientRecords().add(this.readGradRecord(tagType));
        }
        gradient.setFocalPoint(this.bitStream.readFIXED8());
        return gradient;
    }

    private FrameLabelTag readFrameLabel() throws IOException {
        String name = this.bitStream.readString();
        FrameLabelTag tag = new FrameLabelTag(name);
        if (this.bitStream.getOffset() < this.bitStream.getReadBoundary()) {
            short flag = this.bitStream.readUI8();
            assert (flag == 1) : "FrameLabel::NamedAnchorFlag must be 1.";
            tag.setNamedAnchorTag(true);
        }
        return tag;
    }

    private Gradient readGradient(TagType tagType) {
        this.bitStream.byteAlign();
        Gradient gradient = new Gradient();
        gradient.setSpreadMode(this.bitStream.readUB(2));
        gradient.setInterpolationMode(this.bitStream.readUB(2));
        int numGradients = this.bitStream.readUB(4);
        for (int i = 0; i < numGradients; ++i) {
            gradient.getGradientRecords().add(this.readGradRecord(tagType));
        }
        return gradient;
    }

    private GradRecord readGradRecord(TagType tagType) {
        short ratio = this.bitStream.readUI8();
        RGB color = null;
        if (TagType.DefineShape == tagType || TagType.DefineShape2 == tagType) {
            color = this.readRGB();
        } else if (TagType.DefineShape3 == tagType || TagType.DefineShape4 == tagType) {
            color = this.readRGBA();
        } else {
            throw new IllegalArgumentException("Invalid tag: " + (Object)((Object)tagType));
        }
        return new GradRecord(ratio, color);
    }

    protected boolean readHeader() throws IOException {
        Header header = this.swf.getHeader();
        try {
            this.bitStream.setReadBoundary(8L);
            char[] signature = new char[]{(char)this.bitStream.readUI8(), (char)this.bitStream.readUI8(), (char)this.bitStream.readUI8()};
            if (!header.isSignatureValid(signature)) {
                this.problems.add(new SWFInvalidSignatureProblem(this.swfPath));
                return false;
            }
            header.setSignature(signature);
            header.setVersion((byte)this.bitStream.readUI8());
            header.setLength(this.bitStream.readUI32());
            if (header.getCompression() == Header.Compression.LZMA) {
                this.bitStream.setReadBoundary(this.bitStream.getOffset() + 4L);
                long compressedSize = this.bitStream.readUI32();
                header.setCompressedLength(compressedSize);
            }
            this.bitStream.setCompress(header.getCompression());
            this.bitStream.setReadBoundary(this.bitStream.getOffset() + 17L);
            header.setFrameSize(this.readRect());
            this.bitStream.setReadBoundary(this.bitStream.getOffset() + 4L);
            header.setFrameRate(this.bitStream.readFIXED8());
            header.setFrameCount(this.bitStream.readUI16());
        }
        catch (RuntimeException e) {
            this.problems.add(new SWFUnexpectedEndOfFileProblem(this.swfPath));
            return false;
        }
        return true;
    }

    private ILineStyle readLineStyle(TagType tagType) throws MalformedTagException {
        ILineStyle result = null;
        if (tagType == TagType.DefineShape4) {
            LineStyle2 s = new LineStyle2();
            s.setWidth(this.bitStream.readUI16());
            s.setStartCapStyle(this.bitStream.readUB(2));
            s.setJoinStyle(this.bitStream.readUB(2));
            s.setHasFillFlag(this.bitStream.readBit());
            s.setNoHScaleFlag(this.bitStream.readBit());
            s.setNoVScaleFlag(this.bitStream.readBit());
            s.setPixelHintingFlag(this.bitStream.readBit());
            this.bitStream.readUB(5);
            s.setNoClose(this.bitStream.readBit());
            s.setEndCapStyle(this.bitStream.readUB(2));
            if (s.getJoinStyle() == 2) {
                s.setMiterLimitFactor(this.bitStream.readUI16());
            }
            if (s.isHasFillFlag()) {
                IFillStyle fillStyle = this.readFillStyle(tagType);
                s.setFillType((FillStyle)fillStyle);
                s.setColor(new RGBA(0, 0, 0, 0));
            } else {
                s.setColor(this.readRGBA());
            }
            result = s;
        } else if (tagType == TagType.DefineMorphShape) {
            result = this.readMorphLineStyle();
        } else if (tagType == TagType.DefineMorphShape2) {
            result = this.readMorphLineStyle2(tagType);
        } else if (tagType == TagType.DefineShape3) {
            LineStyle ls = new LineStyle();
            result = ls;
            ls.setWidth(this.bitStream.readUI16());
            ls.setColor(this.readRGBA());
        } else {
            LineStyle ls = new LineStyle();
            result = ls;
            ls.setWidth(this.bitStream.readUI16());
            ls.setColor(this.readRGB());
        }
        return result;
    }

    private LineStyleArray readLineStyleArray(TagType tagType) throws MalformedTagException {
        LineStyleArray lineStyleArray = new LineStyleArray();
        int count = this.readExtensibleCount();
        for (int i = 0; i < count; ++i) {
            lineStyleArray.add(this.readLineStyle(tagType));
        }
        return lineStyleArray;
    }

    protected Matrix readMatrix() {
        this.bitStream.byteAlign();
        Matrix matrix = new Matrix();
        if (this.bitStream.readBit()) {
            int nScaleBits = this.bitStream.readUB(5);
            matrix.setScale(this.bitStream.readFB(nScaleBits), this.bitStream.readFB(nScaleBits));
        }
        if (this.bitStream.readBit()) {
            int nRotateBits = this.bitStream.readUB(5);
            matrix.setRotate(this.bitStream.readFB(nRotateBits), this.bitStream.readFB(nRotateBits));
        }
        int nTranslateBits = this.bitStream.readUB(5);
        matrix.setTranslate(this.bitStream.readSB(nTranslateBits), this.bitStream.readSB(nTranslateBits));
        this.bitStream.byteAlign();
        return matrix;
    }

    private MetadataTag readMetadata() {
        return new MetadataTag(this.bitStream.readString());
    }

    private PlaceObject2Tag readPlaceObject2() throws IOException, MalformedTagException {
        PlaceObject2Tag tag = new PlaceObject2Tag();
        tag.setHasClipActions(this.bitStream.readBit());
        tag.setHasClipDepth(this.bitStream.readBit());
        tag.setHasName(this.bitStream.readBit());
        tag.setHasRatio(this.bitStream.readBit());
        tag.setHasColorTransform(this.bitStream.readBit());
        tag.setHasMatrix(this.bitStream.readBit());
        tag.setHasCharacter(this.bitStream.readBit());
        tag.setMove(this.bitStream.readBit());
        tag.setDepth(this.bitStream.readUI16());
        if (tag.isHasCharacter()) {
            tag.setCharacter(this.getTagById(this.bitStream.readUI16(), tag.getTagType()));
        }
        if (tag.isHasMatrix()) {
            tag.setMatrix(this.readMatrix());
        }
        if (tag.isHasColorTransform()) {
            tag.setColorTransform(this.readColorTransformWithAlpha());
        }
        if (tag.isHasRatio()) {
            tag.setRatio(this.bitStream.readUI16());
        }
        if (tag.isHasName()) {
            tag.setName(this.bitStream.readString());
        }
        if (tag.isHasClipDepth()) {
            tag.setClipDepth(this.bitStream.readUI16());
        }
        ClipActions clipActions = new ClipActions();
        clipActions.data = this.bitStream.readToBoundary();
        tag.setClipActions(clipActions);
        return tag;
    }

    private ProductInfoTag readProductInfo() {
        ProductInfoTag.Product product = ProductInfoTag.Product.fromCode(this.bitStream.readSI32());
        ProductInfoTag.Edition edition = ProductInfoTag.Edition.fromCode(this.bitStream.readSI32());
        byte majorVersion = this.bitStream.readSI8();
        byte minorVersion = this.bitStream.readSI8();
        long build = this.bitStream.readSI64();
        long compileDate = this.bitStream.readSI64();
        return new ProductInfoTag(product, edition, majorVersion, minorVersion, build, compileDate);
    }

    private RawTag readRawTag(TagType type) throws IOException {
        RawTag rawTag = new RawTag(type);
        rawTag.setTagBody(this.bitStream.readToBoundary());
        return rawTag;
    }

    private Rect readRect() {
        this.bitStream.byteAlign();
        int nbits = this.bitStream.readUB(5);
        Rect rect = new Rect(this.bitStream.readSB(nbits), this.bitStream.readSB(nbits), this.bitStream.readSB(nbits), this.bitStream.readSB(nbits));
        this.bitStream.byteAlign();
        return rect;
    }

    private RGB readRGB() {
        return new RGB(this.bitStream.readUI8(), this.bitStream.readUI8(), this.bitStream.readUI8());
    }

    private RGBA readRGBA() {
        return new RGBA(this.bitStream.readUI8(), this.bitStream.readUI8(), this.bitStream.readUI8(), this.bitStream.readUI8());
    }

    private ScriptLimitsTag readScriptLimits() {
        return new ScriptLimitsTag(this.bitStream.readUI16(), this.bitStream.readUI16());
    }

    private SetBackgroundColorTag readSetBackgroundColor() {
        return new SetBackgroundColorTag(this.bitStream.readUI8(), this.bitStream.readUI8(), this.bitStream.readUI8());
    }

    private List<ShapeRecord> readShapeRecords(TagType tagType, Shape shape, CurrentStyles currentStyles) throws IOException, MalformedTagException {
        ArrayList<ShapeRecord> list = new ArrayList<ShapeRecord>();
        boolean endShapeRecord = false;
        do {
            boolean isEdge;
            if (isEdge = this.bitStream.readBit()) {
                boolean isStraight = this.bitStream.readBit();
                if (isStraight) {
                    StraightEdgeRecord straightEdge = this.readStraightEdgeRecord();
                    list.add(straightEdge);
                    continue;
                }
                CurvedEdgeRecord curvedEdge = this.readCurvedEdgeRecord();
                list.add(curvedEdge);
                continue;
            }
            boolean stateNewStyles = this.bitStream.readBit();
            boolean stateLineStyle = this.bitStream.readBit();
            boolean stateFillStyle1 = this.bitStream.readBit();
            boolean stateFillStyle0 = this.bitStream.readBit();
            boolean stateMoveTo = this.bitStream.readBit();
            if (stateNewStyles || stateLineStyle || stateFillStyle1 || stateFillStyle0 || stateMoveTo) {
                StyleChangeRecord styleChange = this.readStyleChangeRecord(stateNewStyles, stateLineStyle, stateFillStyle1, stateFillStyle0, stateMoveTo, tagType, shape, currentStyles);
                list.add(styleChange);
                continue;
            }
            endShapeRecord = true;
        } while (!endShapeRecord);
        return list;
    }

    private ShapeWithStyle readShapeWithStyle(TagType tagType) throws IOException, MalformedTagException {
        FillStyleArray fillStyles = this.readFillStyleArray(tagType);
        LineStyleArray lineStyles = this.readLineStyleArray(tagType);
        this.bitStream.byteAlign();
        int numFillBits = this.bitStream.readUB(4);
        int numLineBits = this.bitStream.readUB(4);
        Styles styles = new Styles(fillStyles, lineStyles);
        CurrentStyles currentStyles = new CurrentStyles();
        currentStyles.styles = styles;
        currentStyles.numFillBits = numFillBits;
        currentStyles.numLineBits = numLineBits;
        ShapeWithStyle shapes = new ShapeWithStyle(styles);
        shapes.setNumFillBits(numFillBits);
        shapes.setNumLineBits(numLineBits);
        List<ShapeRecord> shapeRecords = this.readShapeRecords(tagType, shapes, currentStyles);
        shapes.addShapeRecords(shapeRecords);
        return shapes;
    }

    private Shape readShape(TagType tagType) throws IOException, MalformedTagException {
        this.bitStream.byteAlign();
        int numFillBits = this.bitStream.readUB(4);
        int numLineBits = this.bitStream.readUB(4);
        CurrentStyles currentStyles = new CurrentStyles();
        currentStyles.styles = null;
        currentStyles.numFillBits = numFillBits;
        currentStyles.numLineBits = numLineBits;
        Shape shapes = new Shape();
        shapes.setNumFillBits(numFillBits);
        shapes.setNumLineBits(numLineBits);
        List<ShapeRecord> shapeRecords = this.readShapeRecords(tagType, shapes, currentStyles);
        shapes.addShapeRecords(shapeRecords);
        return shapes;
    }

    private MorphGradRecord readMorphGradRecord() {
        short startRatio = this.bitStream.readUI8();
        RGBA startColor = this.readRGBA();
        short endRatio = this.bitStream.readUI8();
        RGBA endColor = this.readRGBA();
        MorphGradRecord result = new MorphGradRecord();
        result.setStartRatio(startRatio);
        result.setStartColor(startColor);
        result.setEndRatio(endRatio);
        result.setEndColor(endColor);
        return result;
    }

    private MorphGradient readMorphGradient() {
        MorphGradient result = new MorphGradient();
        int numGradients = this.bitStream.readUI8();
        for (int idx = 0; idx < numGradients; ++idx) {
            MorphGradRecord gradientRecord = this.readMorphGradRecord();
            result.add(gradientRecord);
        }
        return result;
    }

    private MorphFillStyle readMorphFillStyle(TagType tagType) throws MalformedTagException {
        MorphFillStyle result = new MorphFillStyle();
        short fillStyleType = this.bitStream.readUI8();
        result.setFillStyleType(fillStyleType);
        switch (fillStyleType) {
            case 0: {
                RGBA startColor = this.readRGBA();
                RGBA endColor = this.readRGBA();
                result.setStartColor(startColor);
                result.setEndColor(endColor);
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                Matrix startGradientMatrix = this.readMatrix();
                Matrix endGradientMatrix = this.readMatrix();
                MorphGradient gradient = this.readMorphGradient();
                result.setStartGradientMatrix(startGradientMatrix);
                result.setEndGradientMatrix(endGradientMatrix);
                result.setGradient(gradient);
                if (fillStyleType != 19 || tagType.getValue() != TagType.DefineMorphShape2.getValue()) break;
                result.setRatio1(this.bitStream.readSI16());
                result.setRatio2(this.bitStream.readSI16());
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                int bitmapId = this.bitStream.readUI16();
                ICharacterTag bitmap = this.getTagById(bitmapId, tagType);
                Matrix startBitmapMatrix = this.readMatrix();
                Matrix endBitmapMatrix = this.readMatrix();
                result.setBitmap(bitmap);
                result.setStartBitmapMatrix(startBitmapMatrix);
                result.setEndBitmapMatrix(endBitmapMatrix);
                break;
            }
            default: {
                this.problems.add(new SWFUnknownFillStyleProblem(fillStyleType, true, this.swfPath, this.bitStream.getOffset()));
                throw new MalformedTagException();
            }
        }
        return result;
    }

    private MorphLineStyle readMorphLineStyle() {
        int startWidth = this.bitStream.readUI16();
        int endWidth = this.bitStream.readUI16();
        RGBA startColor = this.readRGBA();
        RGBA endColor = this.readRGBA();
        MorphLineStyle result = new MorphLineStyle();
        result.setStartWidth(startWidth);
        result.setEndWidth(endWidth);
        result.setStartColor(startColor);
        result.setEndColor(endColor);
        return result;
    }

    private MorphLineStyle2 readMorphLineStyle2(TagType tagType) throws MalformedTagException {
        MorphLineStyle2 result = new MorphLineStyle2();
        result.setStartWidth(this.bitStream.readUI16());
        result.setEndWidth(this.bitStream.readUI16());
        result.setStartCapStyle(this.bitStream.readUB(2));
        result.setJoinStyle(this.bitStream.readUB(2));
        result.setHasFillFlag(this.bitStream.readBit());
        result.setNoHScaleFlag(this.bitStream.readBit());
        result.setNoVScaleFlag(this.bitStream.readBit());
        result.setPixelHintingFlag(this.bitStream.readBit());
        this.bitStream.readUB(5);
        result.setNoClose(this.bitStream.readBit());
        result.setEndCapStyle(this.bitStream.readUB(2));
        this.bitStream.byteAlign();
        if (2 == result.getJoinStyle()) {
            result.setMiterLimitFactor(this.bitStream.readUI16());
        }
        if (!result.isHasFillFlag()) {
            result.setStartColor(this.readRGBA());
            result.setEndColor(this.readRGBA());
        } else {
            result.setFillType(this.readMorphFillStyle(tagType));
        }
        return result;
    }

    public DefineMorphShapeTag readDefineMorphShape() throws IOException, MalformedTagException {
        int characterId = this.bitStream.readUI16();
        Rect startBounds = this.readRect();
        Rect endBounds = this.readRect();
        long offset = this.bitStream.readUI32();
        ShapeWithStyle startEdges = this.readShapeWithStyle(TagType.DefineMorphShape);
        Shape endEdges = this.readShape(TagType.DefineMorphShape);
        DefineMorphShapeTag tag = new DefineMorphShapeTag();
        tag.setCharacterID(characterId);
        tag.setStartBounds(startBounds);
        tag.setEndBounds(endBounds);
        tag.setOffset(offset);
        tag.setStartEdges(startEdges);
        tag.setEndEdges(endEdges);
        return tag;
    }

    public DefineMorphShape2Tag readDefineMorphShape2() throws IOException, MalformedTagException {
        int characterId = this.bitStream.readUI16();
        Rect startBounds = this.readRect();
        Rect endBounds = this.readRect();
        Rect startEdgeBounds = this.readRect();
        Rect endEdgeBounds = this.readRect();
        this.bitStream.readUB(6);
        boolean usesNonScalingStrokes = this.bitStream.readBit();
        boolean usesScalingStrokes = this.bitStream.readBit();
        long offset = this.bitStream.readUI32();
        ShapeWithStyle startEdges = this.readShapeWithStyle(TagType.DefineMorphShape2);
        Shape endEdges = this.readShape(TagType.DefineMorphShape2);
        DefineMorphShape2Tag tag = new DefineMorphShape2Tag();
        tag.setCharacterID(characterId);
        tag.setStartBounds(startBounds);
        tag.setEndBounds(endBounds);
        tag.setOffset(offset);
        tag.setStartEdges(startEdges);
        tag.setEndEdges(endEdges);
        tag.setStartEdgeBounds(startEdgeBounds);
        tag.setEndEdgeBounds(endEdgeBounds);
        tag.setUsesNonScalingStrokes(usesNonScalingStrokes);
        tag.setUsesScalingStrokes(usesScalingStrokes);
        return tag;
    }

    private int readExtensibleCount() {
        short count = this.bitStream.readUI8();
        if (count == 255) {
            int countExtended = this.bitStream.readUI16();
            return countExtended;
        }
        return count;
    }

    private ShowFrameTag readShowFrame() {
        return new ShowFrameTag();
    }

    private StraightEdgeRecord readStraightEdgeRecord() throws IOException {
        StraightEdgeRecord straightEdgeRecord = null;
        int nbits = 2 + this.bitStream.readUB(4);
        boolean isGeneralLine = this.bitStream.readBit();
        if (isGeneralLine) {
            int dx = this.bitStream.readSB(nbits);
            int dy = this.bitStream.readSB(nbits);
            straightEdgeRecord = new StraightEdgeRecord(dx, dy);
        } else {
            boolean isVertLine = this.bitStream.readBit();
            if (isVertLine) {
                int dy = this.bitStream.readSB(nbits);
                straightEdgeRecord = new StraightEdgeRecord(0, dy);
            } else {
                int dx = this.bitStream.readSB(nbits);
                straightEdgeRecord = new StraightEdgeRecord(dx, 0);
            }
        }
        return straightEdgeRecord;
    }

    private StyleChangeRecord readStyleChangeRecord(boolean stateNewStyles, boolean stateLineStyle, boolean stateFillStyle1, boolean stateFillStyle0, boolean stateMoveTo, TagType tagType, Shape shape, CurrentStyles currentStyles) throws IOException, MalformedTagException {
        boolean isDefineShape234;
        assert (tagType != null);
        assert (currentStyles != null);
        StyleChangeRecord styleChange = new StyleChangeRecord();
        if (stateMoveTo) {
            int moveBits = this.bitStream.readUB(5);
            int moveDeltaX = this.bitStream.readSB(moveBits);
            int moveDeltaY = this.bitStream.readSB(moveBits);
            styleChange.setMove(moveDeltaX, moveDeltaY);
        }
        boolean ignoreStyle = tagType == TagType.DefineFont || tagType == TagType.DefineFont2 || tagType == TagType.DefineFont3;
        int indexFillStyle0 = stateFillStyle0 ? this.bitStream.readUB(currentStyles.numFillBits) : 0;
        int indexFillStyle1 = stateFillStyle1 ? this.bitStream.readUB(currentStyles.numFillBits) : 0;
        int indexLineStyle = stateLineStyle ? this.bitStream.readUB(currentStyles.numLineBits) : 0;
        IFillStyle fillStyle0 = indexFillStyle0 > 0 && !ignoreStyle ? (IFillStyle)currentStyles.styles.getFillStyles().get(indexFillStyle0 - 1) : null;
        IFillStyle fillStyle1 = indexFillStyle1 > 0 && !ignoreStyle ? (IFillStyle)currentStyles.styles.getFillStyles().get(indexFillStyle1 - 1) : null;
        ILineStyle lineStyle = indexLineStyle > 0 && !ignoreStyle ? (ILineStyle)currentStyles.styles.getLineStyles().get(indexLineStyle - 1) : null;
        styleChange.setDefinedStyles(fillStyle0, fillStyle1, lineStyle, stateFillStyle0, stateFillStyle1, stateLineStyle, currentStyles.styles);
        boolean bl = isDefineShape234 = tagType == TagType.DefineShape2 || tagType == TagType.DefineShape3 || tagType == TagType.DefineShape4;
        if (stateNewStyles && isDefineShape234) {
            FillStyleArray fillStyles = this.readFillStyleArray(tagType);
            LineStyleArray lineStyles = this.readLineStyleArray(tagType);
            this.bitStream.byteAlign();
            int numFillBits = this.bitStream.readUB(4);
            int numLineBits = this.bitStream.readUB(4);
            Styles newStyles = new Styles(fillStyles, lineStyles);
            styleChange.setNumFillBits(numFillBits);
            styleChange.setNumLineBits(numLineBits);
            styleChange.setNewStyles(newStyles);
            currentStyles.styles = newStyles;
            currentStyles.numFillBits = numFillBits;
            currentStyles.numLineBits = numLineBits;
        }
        return styleChange;
    }

    private SymbolClassTag readSymbolClass() throws MalformedTagException {
        SymbolClassTag symbolClass = new SymbolClassTag();
        int numSymbols = this.bitStream.readUI16();
        for (int i = 0; i < numSymbols; ++i) {
            int id = this.bitStream.readUI16();
            String name = this.bitStream.readString();
            if (id == 0) {
                if (this.swf.getTopLevelClass() != null) continue;
                this.swf.setTopLevelClass(name);
                continue;
            }
            symbolClass.addSymbol(this.getTagById(id, symbolClass.getTagType()), name);
        }
        return symbolClass;
    }

    protected ITag readTagBody(TagType type) throws IOException, MalformedTagException {
        switch (type) {
            case CSMTextSettings: {
                return this.readCSMTextSettings();
            }
            case DoABC: {
                return this.readDoABC();
            }
            case DefineBinaryData: {
                return this.readDefineBinaryData();
            }
            case DefineBits: {
                return this.readDefineBits();
            }
            case DefineBitsJPEG2: {
                return this.readDefineBitsJPEG2();
            }
            case DefineBitsJPEG3: {
                return this.readDefineBitsJPEG3();
            }
            case DefineBitsLossless: {
                return this.readDefineBitsLossless();
            }
            case DefineBitsLossless2: {
                return this.readDefineBitsLossless2();
            }
            case DefineScalingGrid: {
                return this.readDefineScalingGrid();
            }
            case DefineShape: {
                return this.readDefineShape();
            }
            case DefineShape2: {
                return this.readDefineShape2();
            }
            case DefineShape3: {
                return this.readDefineShape3();
            }
            case DefineShape4: {
                return this.readDefineShape4();
            }
            case DefineSprite: {
                return this.readDefineSprite();
            }
            case DefineSound: {
                return this.readDefineSound();
            }
            case StartSound: {
                return this.readStartSound();
            }
            case StartSound2: {
                return this.readStartSound2();
            }
            case SoundStreamHead: {
                return this.readSoundStreamHead(type);
            }
            case SoundStreamHead2: {
                return this.readSoundStreamHead(type);
            }
            case SoundStreamBlock: {
                return this.readSoundStreamBlock();
            }
            case DefineMorphShape: {
                return this.readDefineMorphShape();
            }
            case DefineMorphShape2: {
                return this.readDefineMorphShape2();
            }
            case DefineSceneAndFrameLabelData: {
                return this.readDefineSceneAndFrameLabelData();
            }
            case DefineFont: {
                return this.readDefineFont();
            }
            case DefineFontInfo: {
                return this.readDefineFontInfo(type);
            }
            case DefineFont2: {
                return this.readDefineFont2();
            }
            case DefineFont3: {
                return this.readDefineFont3();
            }
            case DefineFont4: {
                return this.readDefineFont4();
            }
            case DefineFontAlignZones: {
                return this.readDefineFontAlignZones();
            }
            case DefineFontName: {
                return this.readFontName();
            }
            case DefineText: {
                return this.readDefineText(type);
            }
            case DefineText2: {
                return this.readDefineText(type);
            }
            case DefineEditText: {
                return this.readDefineEditText();
            }
            case DefineButton: {
                return this.readDefineButton();
            }
            case DefineButton2: {
                return this.readDefineButton2();
            }
            case DefineButtonSound: {
                return this.readDefineButtonSound();
            }
            case DefineVideoStream: {
                return this.readDefineVideoStream();
            }
            case VideoFrame: {
                return this.readVideoFrame();
            }
            case End: {
                return this.readEnd();
            }
            case EnableDebugger2: {
                return this.readEnableDebugger2();
            }
            case ExportAssets: {
                return this.readExportAssets();
            }
            case FileAttributes: {
                return this.readFileAttributes();
            }
            case FrameLabel: {
                return this.readFrameLabel();
            }
            case JPEGTables: {
                return this.readJPEGTables();
            }
            case Metadata: {
                return this.readMetadata();
            }
            case ProductInfo: {
                return this.readProductInfo();
            }
            case PlaceObject: {
                return this.readPlaceObject();
            }
            case PlaceObject2: {
                return this.readPlaceObject2();
            }
            case PlaceObject3: {
                return this.readPlaceObject3();
            }
            case RemoveObject: {
                return this.readRemoveObject();
            }
            case RemoveObject2: {
                return this.readRemoveObject2();
            }
            case ScriptLimits: {
                return this.readScriptLimits();
            }
            case SetBackgroundColor: {
                return this.readSetBackgroundColor();
            }
            case SetTabIndex: {
                return this.readSetTabIndex();
            }
            case ShowFrame: {
                return this.readShowFrame();
            }
            case SymbolClass: {
                return this.readSymbolClass();
            }
            case EnableTelemetry: {
                return this.readEnableTelemetry();
            }
        }
        return this.readRawTag(type);
    }

    private ITag readSetTabIndex() {
        SetTabIndexTag tag = new SetTabIndexTag();
        tag.setDepth(this.bitStream.readUI16());
        tag.setTabIndex(this.bitStream.readUI16());
        return tag;
    }

    private RemoveObject2Tag readRemoveObject2() {
        RemoveObject2Tag tag = new RemoveObject2Tag();
        tag.setDepth(this.bitStream.readUI16());
        return tag;
    }

    private RemoveObjectTag readRemoveObject() throws MalformedTagException {
        RemoveObjectTag tag = new RemoveObjectTag();
        tag.setCharacter(this.getTagById(this.bitStream.readUI16(), tag.getTagType()));
        tag.setDepth(this.bitStream.readUI16());
        return tag;
    }

    private PlaceObject3Tag readPlaceObject3() throws IOException, MalformedTagException {
        PlaceObject3Tag tag = new PlaceObject3Tag();
        tag.setHasClipActions(this.bitStream.readBit());
        tag.setHasClipDepth(this.bitStream.readBit());
        tag.setHasName(this.bitStream.readBit());
        tag.setHasRatio(this.bitStream.readBit());
        tag.setHasColorTransform(this.bitStream.readBit());
        tag.setHasMatrix(this.bitStream.readBit());
        tag.setHasCharacter(this.bitStream.readBit());
        tag.setMove(this.bitStream.readBit());
        this.bitStream.readUB(3);
        tag.setHasImage(this.bitStream.readBit());
        tag.setHasClassName(this.bitStream.readBit());
        tag.setHasCacheAsBitmap(this.bitStream.readBit());
        tag.setHasBlendMode(this.bitStream.readBit());
        tag.setHasFilterList(this.bitStream.readBit());
        tag.setDepth(this.bitStream.readUI16());
        if (tag.isHasClassName()) {
            tag.setClassName(this.bitStream.readString());
        }
        if (tag.isHasCharacter()) {
            tag.setCharacter(this.getTagById(this.bitStream.readUI16(), tag.getTagType()));
        }
        if (tag.isHasMatrix()) {
            tag.setMatrix(this.readMatrix());
        }
        if (tag.isHasColorTransform()) {
            tag.setColorTransform(this.readColorTransformWithAlpha());
        }
        if (tag.isHasRatio()) {
            tag.setRatio(this.bitStream.readUI16());
        }
        if (tag.isHasName()) {
            tag.setName(this.bitStream.readString());
        }
        if (tag.isHasClipDepth()) {
            tag.setClipDepth(this.bitStream.readUI16());
        }
        if (tag.isHasFilterList()) {
            int count = this.bitStream.readUI8();
            Filter[] filterList = new Filter[count];
            for (int i = 0; i < count; ++i) {
                filterList[i] = this.readFilter();
            }
            tag.setSurfaceFilterList(filterList);
        }
        if (tag.isHasBlendMode()) {
            tag.setBlendMode(this.bitStream.readUI8());
        }
        if (tag.isHasCacheAsBitmap()) {
            tag.setBitmapCache(this.bitStream.readUI8());
        }
        ClipActions clipActions = new ClipActions();
        clipActions.data = this.bitStream.readToBoundary();
        tag.setClipActions(clipActions);
        return tag;
    }

    private PlaceObjectTag readPlaceObject() throws IOException, MalformedTagException {
        PlaceObjectTag tag = new PlaceObjectTag();
        tag.setCharacter(this.getTagById(this.bitStream.readUI16(), tag.getTagType()));
        tag.setDepth(this.bitStream.readUI16());
        tag.setMatrix(this.readMatrix());
        if (this.bitStream.available() > 0) {
            tag.setColorTransform(this.readColorTransform());
        }
        return tag;
    }

    private CXForm readColorTransform() {
        this.bitStream.byteAlign();
        CXForm cx = new CXForm();
        boolean hasAddTerms = this.bitStream.readBit();
        boolean hasMultTerms = this.bitStream.readBit();
        int nbits = this.bitStream.readUB(4);
        if (hasAddTerms) {
            cx.setAddTerm(this.bitStream.readSB(nbits), this.bitStream.readSB(nbits), this.bitStream.readSB(nbits));
        }
        if (hasMultTerms) {
            cx.setMultTerm(this.bitStream.readSB(nbits), this.bitStream.readSB(nbits), this.bitStream.readSB(nbits));
        }
        return cx;
    }

    private ITag readVideoFrame() throws IOException, MalformedTagException {
        int id = this.bitStream.readUI16();
        ICharacterTag streamTag = this.getTagById(id, TagType.VideoFrame);
        assert (streamTag.getTagType() == TagType.DefineVideoStream);
        int frameNum = this.bitStream.readUI16();
        byte[] videoData = this.bitStream.readToBoundary();
        VideoFrameTag tag = new VideoFrameTag();
        tag.setStreamTag((DefineVideoStreamTag)streamTag);
        tag.setFrameNum(frameNum);
        tag.setVideoData(videoData);
        return tag;
    }

    private ITag readDefineVideoStream() {
        int characterID = this.bitStream.readUI16();
        int numFrames = this.bitStream.readUI16();
        int width = this.bitStream.readUI16();
        int height = this.bitStream.readUI16();
        this.bitStream.byteAlign();
        this.bitStream.readUB(4);
        int deblocking = this.bitStream.readUB(3);
        boolean smoothing = this.bitStream.readBit();
        short codecID = this.bitStream.readUI8();
        DefineVideoStreamTag tag = new DefineVideoStreamTag();
        tag.setCharacterID(characterID);
        tag.setNumFrames(numFrames);
        tag.setWidth(width);
        tag.setHeight(height);
        tag.setDeblocking(deblocking);
        tag.setSmoothing(smoothing);
        tag.setCodecID(codecID);
        return tag;
    }

    private DefineButtonSoundTag readDefineButtonSound() throws MalformedTagException {
        int buttonID = this.bitStream.readUI16();
        DefineButtonSoundTag tag = new DefineButtonSoundTag();
        tag.setButtonTag(this.getTagById(buttonID, tag.getTagType()));
        for (int i = 0; i < 4; ++i) {
            int soundID = this.bitStream.readUI16();
            if (soundID == 0) continue;
            ICharacterTag soundTag = this.getTagById(soundID, tag.getTagType());
            assert (soundTag instanceof DefineSoundTag);
            tag.getSoundChar()[i] = (DefineSoundTag)soundTag;
            tag.getSoundInfo()[i] = this.readSoundInfo();
        }
        return tag;
    }

    private DefineButton2Tag readDefineButton2() throws IOException {
        int buttonID = this.bitStream.readUI16();
        this.bitStream.byteAlign();
        this.bitStream.readUB(7);
        boolean trackAsMenu = this.bitStream.readBit();
        int actionOffset = this.bitStream.readUI16();
        ButtonRecord[] characters = this.readButtonRecords(TagType.DefineButton2);
        byte[] actions = this.bitStream.readToBoundary();
        DefineButton2Tag tag = new DefineButton2Tag();
        tag.setTrackAsMenu(trackAsMenu);
        tag.setActionOffset(actionOffset);
        tag.setCharacterID(buttonID);
        tag.setCharacters(characters);
        tag.setActions(actions);
        return tag;
    }

    private DefineButtonTag readDefineButton() throws IOException {
        int buttonID = this.bitStream.readUI16();
        ButtonRecord[] characters = this.readButtonRecords(TagType.DefineButton);
        byte[] actionsWithEndFlag = this.bitStream.readToBoundary();
        int actionSize = actionsWithEndFlag.length - 1;
        byte[] actions = new byte[actionSize];
        System.arraycopy(actionsWithEndFlag, 0, actions, 0, actionSize);
        DefineButtonTag tag = new DefineButtonTag();
        tag.setCharacterID(buttonID);
        tag.setCharacters(characters);
        tag.setActions(actions);
        return tag;
    }

    private ButtonRecord[] readButtonRecords(TagType type) {
        short firstByte;
        ArrayList<ButtonRecord> characters = new ArrayList<ButtonRecord>(6);
        while ((firstByte = this.bitStream.readUI8()) != 0) {
            ButtonRecord record = new ButtonRecord();
            record.setHasBlendMode((firstByte & 0x20) > 0);
            record.setHasFilterList((firstByte & 0x10) > 0);
            record.setStateHitTest((firstByte & 8) > 0);
            record.setStateDown((firstByte & 4) > 0);
            record.setStateOver((firstByte & 2) > 0);
            record.setStateUp((firstByte & 1) > 0);
            record.setCharacterID(this.bitStream.readUI16());
            record.setPlaceDepth(this.bitStream.readUI16());
            record.setPlaceMatrix(this.readMatrix());
            if (type == TagType.DefineButton2) {
                record.setColorTransform(this.readColorTransformWithAlpha());
                if (record.isHasFilterList()) {
                    int count = this.bitStream.readUI8();
                    Filter[] filterList = new Filter[count];
                    for (int i = 0; i < count; ++i) {
                        filterList[i] = this.readFilter();
                    }
                    record.setFilterList(filterList);
                }
                if (record.isHasBlendMode()) {
                    record.setBlendMode(this.bitStream.readUI8());
                }
            }
            characters.add(record);
        }
        return characters.toArray(new ButtonRecord[characters.size()]);
    }

    private Filter readFilter() {
        Filter filter = new Filter();
        short type = this.bitStream.readUI8();
        filter.setFilterID(type);
        switch (type) {
            case 0: {
                filter.setDropShadowFilter(this.readDropShadowFilter());
                break;
            }
            case 1: {
                filter.setBlurFilter(this.readBlurFilter());
                break;
            }
            case 2: {
                filter.setGlowFilter(this.readGlowFilter());
                break;
            }
            case 3: {
                filter.setBevelFilter(this.readBevelFilter());
                break;
            }
            case 4: {
                filter.setGradientGlowFilter(this.readGradientGlowFilter());
                break;
            }
            case 5: {
                filter.setConvolutionFilter(this.readConvolutionFilter());
                break;
            }
            case 6: {
                filter.setColorMatrixFilter(this.readColorMatrixFilter());
                break;
            }
            case 7: {
                filter.setGradientBevelFilter(this.readGradientBevelFilter());
            }
        }
        return filter;
    }

    private GradientBevelFilter readGradientBevelFilter() {
        GradientBevelFilter filter = new GradientBevelFilter();
        short numColors = this.bitStream.readUI8();
        RGBA[] gradientColors = new RGBA[numColors];
        int[] gradientRatio = new int[numColors];
        for (short i = 0; i < numColors; i = (short)(i + 1)) {
            gradientColors[i] = this.readRGBA();
            gradientRatio[i] = this.bitStream.readUI8();
        }
        filter.setNumColors(numColors);
        filter.setGradientColors(gradientColors);
        filter.setGradientRatio(gradientRatio);
        filter.setBlurX(this.bitStream.readFIXED());
        filter.setBlurY(this.bitStream.readFIXED());
        filter.setAngle(this.bitStream.readFIXED());
        filter.setDistance(this.bitStream.readFIXED());
        filter.setStrength(this.bitStream.readFIXED8());
        filter.setInnerShadow(this.bitStream.readBit());
        filter.setKnockout(this.bitStream.readBit());
        filter.setCompositeSource(this.bitStream.readBit());
        filter.setPasses(this.bitStream.readUB(4));
        return filter;
    }

    private float[] readColorMatrixFilter() {
        float[] result = new float[20];
        for (int i = 0; i < 20; ++i) {
            result[i] = this.bitStream.readFLOAT();
        }
        return result;
    }

    private ConvolutionFilter readConvolutionFilter() {
        ConvolutionFilter filter = new ConvolutionFilter();
        filter.setMatrixX(this.bitStream.readUI8());
        filter.setMatrixY(this.bitStream.readUI8());
        filter.setDivisor(this.bitStream.readFLOAT());
        filter.setBias(this.bitStream.readFLOAT());
        int length = filter.getMatrixX() * filter.getMatrixY();
        float[] matrix = new float[length];
        for (int i = 0; i < length; ++i) {
            matrix[i] = this.bitStream.readFLOAT();
        }
        filter.setMatrix(matrix);
        filter.setDefaultColor(this.readRGBA());
        this.bitStream.byteAlign();
        this.bitStream.readUB(6);
        filter.setClamp(this.bitStream.readBit());
        filter.setPreserveAlpha(this.bitStream.readBit());
        return filter;
    }

    private GradientGlowFilter readGradientGlowFilter() {
        GradientGlowFilter filter = new GradientGlowFilter();
        short numColors = this.bitStream.readUI8();
        RGBA[] gradientColors = new RGBA[numColors];
        int[] gradientRatio = new int[numColors];
        for (short i = 0; i < numColors; i = (short)(i + 1)) {
            gradientColors[i] = this.readRGBA();
            gradientRatio[i] = this.bitStream.readUI8();
        }
        filter.setNumColors(numColors);
        filter.setGradientColors(gradientColors);
        filter.setGradientRatio(gradientRatio);
        filter.setBlurX(this.bitStream.readFIXED());
        filter.setBlurY(this.bitStream.readFIXED());
        filter.setAngle(this.bitStream.readFIXED());
        filter.setDistance(this.bitStream.readFIXED());
        filter.setStrength(this.bitStream.readFIXED8());
        filter.setInnerGlow(this.bitStream.readBit());
        filter.setKnockout(this.bitStream.readBit());
        filter.setCompositeSource(this.bitStream.readBit());
        filter.setPasses(this.bitStream.readUB(4));
        return filter;
    }

    private BevelFilter readBevelFilter() {
        BevelFilter filter = new BevelFilter();
        filter.setShadowColor(this.readRGBA());
        filter.setHighlightColor(this.readRGBA());
        filter.setBlurX(this.bitStream.readFIXED());
        filter.setBlurY(this.bitStream.readFIXED());
        filter.setAngle(this.bitStream.readFIXED());
        filter.setDistance(this.bitStream.readFIXED());
        filter.setStrength(this.bitStream.readFIXED8());
        filter.setInnerShadow(this.bitStream.readBit());
        filter.setKnockout(this.bitStream.readBit());
        filter.setCompositeSource(this.bitStream.readBit());
        filter.setOnTop(this.bitStream.readBit());
        filter.setPasses(this.bitStream.readUB(4));
        return filter;
    }

    private GlowFilter readGlowFilter() {
        GlowFilter filter = new GlowFilter();
        filter.setGlowColor(this.readRGBA());
        filter.setBlurX(this.bitStream.readFIXED());
        filter.setBlurY(this.bitStream.readFIXED());
        filter.setStrength(this.bitStream.readFIXED8());
        filter.setInnerGlow(this.bitStream.readBit());
        filter.setKnockout(this.bitStream.readBit());
        filter.setCompositeSource(this.bitStream.readBit());
        filter.setPasses(this.bitStream.readUB(5));
        return filter;
    }

    private BlurFilter readBlurFilter() {
        BlurFilter filter = new BlurFilter();
        filter.setBlurX(this.bitStream.readFIXED());
        filter.setBlurY(this.bitStream.readFIXED());
        filter.setPasses(this.bitStream.readUB(5));
        this.bitStream.readUB(3);
        return filter;
    }

    private DropShadowFilter readDropShadowFilter() {
        DropShadowFilter filter = new DropShadowFilter();
        filter.setDropShadowColor(this.readRGBA());
        filter.setBlurX(this.bitStream.readFIXED());
        filter.setBlurY(this.bitStream.readFIXED());
        filter.setAngle(this.bitStream.readFIXED());
        filter.setDistance(this.bitStream.readFIXED());
        filter.setStrength(this.bitStream.readFIXED8());
        filter.setInnerShadow(this.bitStream.readBit());
        filter.setKnockout(this.bitStream.readBit());
        filter.setCompositeSource(this.bitStream.readBit());
        filter.setPasses(this.bitStream.readUB(5));
        return filter;
    }

    private SoundStreamBlockTag readSoundStreamBlock() throws IOException {
        byte[] streamSoundData = this.bitStream.readToBoundary();
        SoundStreamBlockTag tag = new SoundStreamBlockTag();
        tag.setStreamSoundData(streamSoundData);
        return tag;
    }

    private SoundStreamHeadTag readSoundStreamHead(TagType tagType) {
        this.bitStream.byteAlign();
        this.bitStream.readUB(4);
        int playbackSoundRate = this.bitStream.readUB(2);
        int playbackSoundSize = this.bitStream.readUB(1);
        int playbackSoundType = this.bitStream.readUB(1);
        int streamSoundCompression = this.bitStream.readUB(4);
        int streamSoundRate = this.bitStream.readUB(2);
        int streamSoundSize = this.bitStream.readUB(1);
        int streamSoundType = this.bitStream.readUB(1);
        int streamSoundSampleCount = this.bitStream.readUI16();
        short latencySeek = streamSoundCompression == 2 ? this.bitStream.readSI16() : (short)0;
        SoundStreamHeadTag tag = tagType == TagType.SoundStreamHead ? new SoundStreamHeadTag() : new SoundStreamHead2Tag();
        tag.setPlaybackSoundRate(playbackSoundRate);
        tag.setPlaybackSoundSize(playbackSoundSize);
        tag.setPlaybackSoundType(playbackSoundType);
        tag.setStreamSoundCompression(streamSoundCompression);
        tag.setStreamSoundRate(streamSoundRate);
        tag.setStreamSoundSize(streamSoundSize);
        tag.setStreamSoundType(streamSoundType);
        tag.setStreamSoundSampleCount(streamSoundSampleCount);
        tag.setLatencySeek(latencySeek);
        return tag;
    }

    private StartSoundTag readStartSound() throws MalformedTagException {
        int soundId = this.bitStream.readUI16();
        SoundInfo soundInfo = this.readSoundInfo();
        StartSoundTag tag = new StartSoundTag();
        tag.setSoundTag(this.getTagById(soundId, tag.getTagType()));
        tag.setSoundInfo(soundInfo);
        return tag;
    }

    private StartSound2Tag readStartSound2() {
        String soundClassName = this.bitStream.readString();
        SoundInfo soundInfo = this.readSoundInfo();
        StartSound2Tag tag = new StartSound2Tag();
        tag.setSoundClassName(soundClassName);
        tag.setSoundInfo(soundInfo);
        return tag;
    }

    private SoundInfo readSoundInfo() {
        this.bitStream.byteAlign();
        this.bitStream.readUB(2);
        boolean syncStop = this.bitStream.readBit();
        boolean syncNoMultiple = this.bitStream.readBit();
        boolean hasEnvelope = this.bitStream.readBit();
        boolean hasLoops = this.bitStream.readBit();
        boolean hasOutPoint = this.bitStream.readBit();
        boolean hasInPoint = this.bitStream.readBit();
        long inPoint = hasInPoint ? this.bitStream.readUI32() : 0L;
        long outPoint = hasOutPoint ? this.bitStream.readUI32() : 0L;
        int loopCount = hasLoops ? this.bitStream.readUI16() : 0;
        int envPoints = hasEnvelope ? this.bitStream.readUI8() : 0;
        SoundEnvelope[] envelopeRecords = new SoundEnvelope[envPoints];
        for (int i = 0; i < envPoints; ++i) {
            envelopeRecords[i] = new SoundEnvelope();
            envelopeRecords[i].setPos44(this.bitStream.readUI32());
            envelopeRecords[i].setLeftLevel(this.bitStream.readUI16());
            envelopeRecords[i].setRightLevel(this.bitStream.readUI16());
        }
        SoundInfo soundInfo = new SoundInfo();
        soundInfo.setSyncStop(syncStop);
        soundInfo.setSyncNoMultiple(syncNoMultiple);
        soundInfo.setHasEnvelope(hasEnvelope);
        soundInfo.setHasLoops(hasLoops);
        soundInfo.setHasOutPoint(hasOutPoint);
        soundInfo.setHasInPoint(hasInPoint);
        soundInfo.setInPoint(inPoint);
        soundInfo.setOutPoint(outPoint);
        soundInfo.setLoopCount(loopCount);
        soundInfo.setEnvPoints(envPoints);
        soundInfo.setEnvelopeRecords(envelopeRecords);
        return soundInfo;
    }

    private ITag readDefineSound() throws IOException {
        this.bitStream.byteAlign();
        int soundId = this.bitStream.readUI16();
        int soundFormat = this.bitStream.readUB(4);
        int soundRate = this.bitStream.readUB(2);
        int soundSize = this.bitStream.readUB(1);
        int soundType = this.bitStream.readUB(1);
        long soundSampleCount = this.bitStream.readUI32();
        byte[] soundData = this.bitStream.readToBoundary();
        DefineSoundTag tag = new DefineSoundTag();
        tag.setCharacterID(soundId);
        tag.setSoundFormat(soundFormat);
        tag.setSoundRate(soundRate);
        tag.setSoundSize(soundSize);
        tag.setSoundType(soundType);
        tag.setSoundSampleCount(soundSampleCount);
        tag.setSoundData(soundData);
        return tag;
    }

    private DefineFont4Tag readDefineFont4() throws IOException {
        DefineFont4Tag tag = new DefineFont4Tag();
        tag.setCharacterID(this.bitStream.readUI16());
        this.bitStream.byteAlign();
        this.bitStream.readUB(5);
        tag.setFontFlagsHasFontData(this.bitStream.readBit());
        tag.setFontFlagsItalic(this.bitStream.readBit());
        tag.setFontFlagsBold(this.bitStream.readBit());
        tag.setFontName(this.bitStream.readString());
        tag.setFontData(this.bitStream.readToBoundary());
        return tag;
    }

    private CSMTextSettingsTag readCSMTextSettings() throws MalformedTagException {
        int id = this.bitStream.readUI16();
        CSMTextSettingsTag tag = new CSMTextSettingsTag();
        ICharacterTag textTag = this.getTagById(id, tag.getTagType());
        tag.setTextTag(textTag);
        this.bitStream.byteAlign();
        tag.setUseFlashType(this.bitStream.readUB(2));
        tag.setGridFit(this.bitStream.readUB(3));
        this.bitStream.readUB(3);
        tag.setThickness(this.bitStream.readFLOAT());
        tag.setSharpness(this.bitStream.readFLOAT());
        this.bitStream.readUI8();
        if (textTag instanceof DefineTextTag) {
            ((DefineTextTag)textTag).setCSMTextSettings(tag);
        } else if (textTag instanceof DefineEditTextTag) {
            ((DefineEditTextTag)textTag).setCSMTextSettings(tag);
        } else {
            this.problems.add(new SWFCSMTextSettingsWrongReferenceTypeProblem(this.swfPath, id));
        }
        return tag;
    }

    private DefineEditTextTag readDefineEditText() throws MalformedTagException {
        DefineEditTextTag tag = new DefineEditTextTag();
        tag.setCharacterID(this.bitStream.readUI16());
        tag.setBounds(this.readRect());
        this.bitStream.byteAlign();
        tag.setHasText(this.bitStream.readBit());
        tag.setWordWrap(this.bitStream.readBit());
        tag.setMultiline(this.bitStream.readBit());
        tag.setPassword(this.bitStream.readBit());
        tag.setReadOnly(this.bitStream.readBit());
        tag.setHasTextColor(this.bitStream.readBit());
        tag.setHasMaxLength(this.bitStream.readBit());
        tag.setHasFont(this.bitStream.readBit());
        tag.setHasFontclass(this.bitStream.readBit());
        tag.setAutoSize(this.bitStream.readBit());
        tag.setHasLayout(this.bitStream.readBit());
        tag.setNoSelect(this.bitStream.readBit());
        tag.setBorder(this.bitStream.readBit());
        tag.setWasStatic(this.bitStream.readBit());
        tag.setHtml(this.bitStream.readBit());
        tag.setUseOutlines(this.bitStream.readBit());
        if (tag.isHasFont()) {
            int id = this.bitStream.readUI16();
            ICharacterTag fontTag = this.getTagById(id, tag.getTagType());
            tag.setFontTag(fontTag);
            tag.setFontHeight(this.bitStream.readUI16());
        }
        if (tag.isHasFontClass()) {
            tag.setFontClass(this.bitStream.readString());
            tag.setFontHeight(this.bitStream.readUI16());
        }
        if (tag.isHasTextColor()) {
            tag.setTextColor(this.readRGBA());
        }
        if (tag.isHasMaxLength()) {
            tag.setMaxLength(this.bitStream.readUI16());
        }
        if (tag.isHasLayout()) {
            tag.setAlign(this.bitStream.readUI8());
            tag.setLeftMargin(this.bitStream.readUI16());
            tag.setRightMargin(this.bitStream.readUI16());
            tag.setIndent(this.bitStream.readUI16());
            tag.setLeading(this.bitStream.readSI16());
        }
        tag.setVariableName(this.bitStream.readString());
        if (tag.isHasText()) {
            tag.setInitialText(this.bitStream.readString());
        }
        return tag;
    }

    private DefineTextTag readDefineText(TagType tagType) throws IOException, MalformedTagException {
        TextRecord textRecord;
        assert (tagType == TagType.DefineText || tagType == TagType.DefineText2);
        int characterId = this.bitStream.readUI16();
        Rect textBounds = this.readRect();
        Matrix textMatrix = this.readMatrix();
        short glyphBits = this.bitStream.readUI8();
        short advanceBits = this.bitStream.readUI8();
        ArrayList<TextRecord> textRecords = new ArrayList<TextRecord>();
        while ((textRecord = this.readTextRecord(tagType, glyphBits, advanceBits)) != null) {
            textRecords.add(textRecord);
        }
        DefineTextTag tag = new DefineTextTag();
        tag.setCharacterID(characterId);
        tag.setTextBounds(textBounds);
        tag.setTextMatrix(textMatrix);
        tag.setGlyphBits(glyphBits);
        tag.setAdvanceBits(advanceBits);
        tag.setTextRecords(textRecords.toArray(new TextRecord[0]));
        return tag;
    }

    private TextRecord readTextRecord(TagType type, int glyphBits, int advanceBits) throws MalformedTagException {
        this.bitStream.byteAlign();
        boolean textRecordType = this.bitStream.readBit();
        if (!textRecordType) {
            return null;
        }
        this.bitStream.readUB(3);
        TextRecord textRecord = new TextRecord();
        textRecord.setStyleFlagsHasFont(this.bitStream.readBit());
        textRecord.setStyleFlagsHasColor(this.bitStream.readBit());
        textRecord.setStyleFlagsHasYOffset(this.bitStream.readBit());
        textRecord.setStyleFlagsHasXOffset(this.bitStream.readBit());
        if (textRecord.isStyleFlagsHasFont()) {
            int fontId = this.bitStream.readUI16();
            ICharacterTag fontTag = this.getTagById(fontId, type);
            textRecord.setFontTag(fontTag);
        }
        if (textRecord.isStyleFlagsHasColor()) {
            if (type == TagType.DefineText2) {
                textRecord.setTextColor(this.readRGBA());
            } else {
                textRecord.setTextColor(this.readRGB());
            }
        }
        if (textRecord.isStyleFlagsHasXOffset()) {
            textRecord.setxOffset(this.bitStream.readSI16());
        }
        if (textRecord.isStyleFlagsHasYOffset()) {
            textRecord.setyOffset(this.bitStream.readSI16());
        }
        if (textRecord.isStyleFlagsHasFont()) {
            textRecord.setTextHeight(this.bitStream.readUI16());
        }
        textRecord.setGlyphCount(this.bitStream.readUI8());
        GlyphEntry[] glyphEntries = new GlyphEntry[textRecord.getGlyphCount()];
        for (int i = 0; i < textRecord.getGlyphCount(); ++i) {
            glyphEntries[i] = this.readGlyphEntry(glyphBits, advanceBits);
        }
        textRecord.setGlyphEntries(glyphEntries);
        return textRecord;
    }

    private GlyphEntry readGlyphEntry(int glyphBits, int advanceBits) {
        GlyphEntry entry = new GlyphEntry();
        entry.setGlyphIndex(this.bitStream.readUB(glyphBits));
        entry.setGlyphAdvance(this.bitStream.readSB(advanceBits));
        return entry;
    }

    private DefineFontNameTag readFontName() throws MalformedTagException {
        int fontId = this.bitStream.readUI16();
        DefineFontNameTag tag = new DefineFontNameTag();
        ICharacterTag character = this.getTagById(fontId, tag.getTagType());
        String fontName = this.bitStream.readString();
        String fontCopyright = this.bitStream.readString();
        tag.setFontTag(character);
        tag.setFontName(fontName);
        tag.setFontCopyright(fontCopyright);
        ((IDefineFontTag)((Object)character)).setLicense(tag);
        return tag;
    }

    private DefineFontAlignZonesTag readDefineFontAlignZones() throws MalformedTagException {
        DefineFontAlignZonesTag tag;
        int fontId = this.bitStream.readUI16();
        ICharacterTag character = this.getTagById(fontId, (tag = new DefineFontAlignZonesTag()).getTagType());
        if (character instanceof DefineFont3Tag) {
            DefineFont3Tag fontTag = (DefineFont3Tag)character;
            this.bitStream.byteAlign();
            int csmTableHint = this.bitStream.readUB(2);
            this.bitStream.byteAlign();
            ZoneRecord[] zoneTable = new ZoneRecord[fontTag.getNumGlyphs()];
            for (int i = 0; i < fontTag.getNumGlyphs(); ++i) {
                zoneTable[i] = this.readZoneRecord();
            }
            tag.setFontTag(fontTag);
            tag.setCsmTableHint(csmTableHint);
            tag.setZoneTable(zoneTable);
            fontTag.setZones(tag);
            return tag;
        }
        this.problems.add(new SWFDefineFontAlignZonesLinkToIncorrectFontProblem(fontId, this.swfPath, this.bitStream.getOffset()));
        throw new MalformedTagException();
    }

    private ZoneRecord readZoneRecord() {
        short numZoneData = this.bitStream.readUI8();
        assert (2 == numZoneData);
        ZoneData zoneData0 = this.readZoneData();
        ZoneData zoneData1 = this.readZoneData();
        this.bitStream.byteAlign();
        this.bitStream.readUB(6);
        boolean zoneMaskY = this.bitStream.readBit();
        boolean zoneMaskX = this.bitStream.readBit();
        ZoneRecord zoneRecord = new ZoneRecord();
        zoneRecord.setZoneData0(zoneData0);
        zoneRecord.setZoneData1(zoneData1);
        zoneRecord.setZoneMaskY(zoneMaskY);
        zoneRecord.setZoneMaskX(zoneMaskX);
        return zoneRecord;
    }

    private ZoneData readZoneData() {
        ZoneData zoneData = new ZoneData();
        zoneData.setData(this.bitStream.readUI32());
        return zoneData;
    }

    private DefineFont3Tag readDefineFont3() throws IOException, MalformedTagException {
        DefineFont3Tag tag = new DefineFont3Tag();
        this.readDefineFont2And3(tag);
        return tag;
    }

    private DefineFont2Tag readDefineFont2() throws IOException, MalformedTagException {
        DefineFont2Tag tag = new DefineFont2Tag();
        this.readDefineFont2And3(tag);
        return tag;
    }

    private void readDefineFont2And3(DefineFont2Tag tag) throws IOException, MalformedTagException {
        int fontId = this.bitStream.readUI16();
        this.bitStream.byteAlign();
        boolean fontFlagsHasLayout = this.bitStream.readBit();
        boolean fontFlagsShiftJIS = this.bitStream.readBit();
        boolean fontFlagsSmallText = this.bitStream.readBit();
        boolean fontFlagsANSI = this.bitStream.readBit();
        boolean fontFlagsWideOffsets = this.bitStream.readBit();
        boolean fontFlagsWideCodes = this.bitStream.readBit();
        boolean fontFlagsItalic = this.bitStream.readBit();
        boolean fontFlagsBold = this.bitStream.readBit();
        short languageCode = this.bitStream.readUI8();
        String fontName = this.readLengthString();
        int numGlyphs = this.bitStream.readUI16();
        long[] offsetTable = new long[numGlyphs];
        for (int i = 0; i < numGlyphs; ++i) {
            offsetTable[i] = fontFlagsWideOffsets ? this.bitStream.readUI32() : (long)this.bitStream.readUI16();
        }
        long codeTableOffset = 0L;
        if (numGlyphs > 0) {
            codeTableOffset = fontFlagsWideOffsets ? this.bitStream.readUI32() : (long)this.bitStream.readUI16();
        }
        Shape[] glyphShapeTable = new Shape[numGlyphs];
        for (int i = 0; i < numGlyphs; ++i) {
            glyphShapeTable[i] = this.readShape(tag.getTagType());
        }
        int[] codeTable = new int[numGlyphs];
        for (int i = 0; i < numGlyphs; ++i) {
            codeTable[i] = fontFlagsWideCodes ? this.bitStream.readUI16() : (int)this.bitStream.readUI8();
        }
        short fontAscent = 0;
        short fontDescent = 0;
        short fontLeading = 0;
        int[] fontAdvanceTable = null;
        Rect[] fontBoundsTable = null;
        int kerningCount = 0;
        KerningRecord[] fontKerningTable = null;
        if (fontFlagsHasLayout) {
            int i;
            fontAscent = this.bitStream.readSI16();
            fontDescent = this.bitStream.readSI16();
            fontLeading = this.bitStream.readSI16();
            fontAdvanceTable = new int[numGlyphs];
            for (i = 0; i < numGlyphs; ++i) {
                fontAdvanceTable[i] = this.bitStream.readSI16();
            }
            fontBoundsTable = new Rect[numGlyphs];
            for (i = 0; i < numGlyphs; ++i) {
                fontBoundsTable[i] = this.readRect();
            }
            kerningCount = this.bitStream.readUI16();
            fontKerningTable = new KerningRecord[kerningCount];
            for (i = 0; i < kerningCount; ++i) {
                fontKerningTable[i] = this.readKerningRecord(fontFlagsWideCodes);
            }
        }
        tag.setCharacterID(fontId);
        tag.setFontFlagsHasLayout(fontFlagsHasLayout);
        tag.setFontFlagsShiftJIS(fontFlagsShiftJIS);
        tag.setFontFlagsSmallText(fontFlagsSmallText);
        tag.setFontFlagsANSI(fontFlagsANSI);
        tag.setFontFlagsWideOffsets(fontFlagsWideOffsets);
        tag.setFontFlagsWideCodes(fontFlagsWideCodes);
        tag.setFontFlagsItalic(fontFlagsItalic);
        tag.setFontFlagsBold(fontFlagsBold);
        tag.setLanguageCode(languageCode);
        tag.setFontName(fontName);
        tag.setNumGlyphs(numGlyphs);
        tag.setOffsetTable(offsetTable);
        tag.setCodeTableOffset(codeTableOffset);
        tag.setGlyphShapeTable(glyphShapeTable);
        tag.setCodeTable(codeTable);
        tag.setFontAscent(fontAscent);
        tag.setFontDescent(fontDescent);
        tag.setFontLeading(fontLeading);
        tag.setFontAdvanceTable(fontAdvanceTable);
        tag.setFontBoundsTable(fontBoundsTable);
        tag.setKerningCount(kerningCount);
        tag.setFontKerningTable(fontKerningTable);
    }

    private KerningRecord readKerningRecord(boolean fontFlagsWideCodes) {
        int code1 = fontFlagsWideCodes ? this.bitStream.readUI16() : (int)this.bitStream.readUI8();
        int code2 = fontFlagsWideCodes ? this.bitStream.readUI16() : (int)this.bitStream.readUI8();
        short adjustment = this.bitStream.readSI16();
        KerningRecord rec = new KerningRecord();
        rec.setCode1(code1);
        rec.setCode2(code2);
        rec.setAdjustment(adjustment);
        return rec;
    }

    private ITag readDefineFontInfo(TagType type) throws IOException, MalformedTagException {
        assert (type == TagType.DefineFontInfo || type == TagType.DefineFontInfo2) : "unknown tag type in readDefineFontInfo";
        int fontId = this.bitStream.readUI16();
        ICharacterTag fontTag = this.getTagById(fontId, type);
        String fontName = this.readLengthString();
        int reserved = this.bitStream.readUB(2);
        boolean smallText = this.bitStream.readBit();
        boolean shiftJIS = this.bitStream.readBit();
        boolean ansi = this.bitStream.readBit();
        boolean italic = this.bitStream.readBit();
        boolean bold = this.bitStream.readBit();
        boolean wideCodes = this.bitStream.readBit();
        short langCode = 0;
        if (type == TagType.DefineFontInfo2) {
            langCode = this.bitStream.readUI8();
        }
        byte[] codeTableRaw = this.bitStream.readToBoundary();
        int numGlyphs = codeTableRaw.length / (wideCodes ? 2 : 1);
        int[] codeTable = new int[numGlyphs];
        InputBitStream codeTableStream = new InputBitStream(codeTableRaw);
        codeTableStream.setReadBoundary(codeTableRaw.length);
        for (int i = 0; i < numGlyphs; ++i) {
            codeTable[i] = wideCodes ? codeTableStream.readUI16() : (int)codeTableStream.readUI8();
        }
        codeTableStream.close();
        DefineFontInfoTag tag = null;
        tag = type == TagType.DefineFontInfo ? new DefineFontInfoTag() : new DefineFontInfo2Tag();
        tag.setFontTag(fontTag);
        tag.setFontName(fontName);
        tag.setFontFlagsReserved(reserved);
        tag.setFontFlagsSmallText(smallText);
        tag.setFontFlagsShiftJIS(shiftJIS);
        tag.setFontFlagsANSI(ansi);
        tag.setFontFlagsItalic(italic);
        tag.setFontFlagsBold(bold);
        tag.setFontFlagsWideCodes(wideCodes);
        if (type == TagType.DefineFontInfo2) {
            ((DefineFontInfo2Tag)tag).setLanguageCode(langCode);
        }
        tag.setCodeTable(codeTable);
        return tag;
    }

    private ITag readDefineFont() throws IOException, MalformedTagException {
        int id = this.bitStream.readUI16();
        int firstGlyphShapeOffset = this.bitStream.readUI16();
        int numGlyphs = firstGlyphShapeOffset / 2;
        DefineFontTag tag = new DefineFontTag();
        tag.setCharacterID(id);
        long[] offsetTable = new long[numGlyphs];
        offsetTable[0] = firstGlyphShapeOffset;
        for (int i = 1; i < numGlyphs; ++i) {
            offsetTable[i] = this.bitStream.readUI16();
        }
        tag.setOffsetTable(offsetTable);
        Shape[] glyphShapeTable = new Shape[numGlyphs];
        for (int i = 0; i < numGlyphs; ++i) {
            glyphShapeTable[i] = this.readShape(tag.getTagType());
        }
        tag.setGlyphShapeTable(glyphShapeTable);
        return tag;
    }

    private ITag readDefineBitsJPEG3() throws IOException {
        int id = this.bitStream.readUI16();
        int alphaDataOffset = (int)this.bitStream.readUI32();
        byte[] imageData = this.bitStream.read(alphaDataOffset);
        byte[] bitmapAlphaData = this.bitStream.readToBoundary();
        DefineBitsJPEG3Tag tag = new DefineBitsJPEG3Tag();
        tag.setCharacterID(id);
        tag.setAlphaDataOffset(alphaDataOffset);
        tag.setImageData(imageData);
        tag.setBitmapAlphaData(bitmapAlphaData);
        return tag;
    }

    private ITag readDefineBitsJPEG2() throws IOException {
        DefineBitsJPEG2Tag tag = new DefineBitsJPEG2Tag();
        tag.setCharacterID(this.bitStream.readUI16());
        tag.setImageData(this.bitStream.readToBoundary());
        return tag;
    }

    private ITag readJPEGTables() throws IOException {
        JPEGTablesTag tag = new JPEGTablesTag();
        tag.setJpegData(this.bitStream.readToBoundary());
        return tag;
    }

    private ITag readDefineBits() throws IOException {
        DefineBitsTag tag = new DefineBitsTag();
        tag.setCharacterID(this.bitStream.readUI16());
        tag.setImageData(this.bitStream.readToBoundary());
        return tag;
    }

    private String readLengthString() throws IOException {
        short length = this.bitStream.readUI8();
        byte[] b = new byte[length];
        this.bitStream.read(b);
        if (this.swf.getVersion() >= 6) {
            return new String(b, 0, length - 1, "UTF8");
        }
        return new String(b, 0, length - 1);
    }

    static class CurrentStyles {
        Styles styles;
        int numFillBits;
        int numLineBits;

        CurrentStyles() {
        }
    }

    protected static class TagHeader {
        final TagType type;
        final int length;

        TagHeader(TagType type, int length) {
            this.type = type;
            this.length = length;
        }
    }

    private static class InvalidTag
    extends CharacterTag
    implements ICharacterTag {
        public static final int BAD_CHARACTER_ID = 65535;

        public InvalidTag() {
            super(TagType.End);
            this.setCharacterID(65535);
        }
    }

    private static class MalformedTagException
    extends Exception {
        private static final long serialVersionUID = -8030549610732167171L;

        private MalformedTagException() {
        }
    }
}

