/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients.problems;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.config.ICompilerProblemSettings;
import org.apache.royale.compiler.problems.CompilerProblemClassification;
import org.apache.royale.compiler.problems.CompilerProblemSeverity;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.annotations.DefaultSeverity;
import org.apache.royale.compiler.problems.annotations.ProblemClassification;

public class CompilerProblemCategorizer {
    private Map<Class<? extends ICompilerProblem>, CompilerProblemSeverity> userSeverity;
    private final boolean showWarnings;

    public CompilerProblemCategorizer() {
        this(null);
    }

    public CompilerProblemCategorizer(ICompilerProblemSettings problemSettings) {
        if (problemSettings != null) {
            this.addToUserSeverity(problemSettings.getErrorProblems(), CompilerProblemSeverity.ERROR);
            this.addToUserSeverity(problemSettings.getWarningProblems(), CompilerProblemSeverity.WARNING);
            this.addToUserSeverity(problemSettings.getIgnoreProblems(), CompilerProblemSeverity.IGNORE);
            this.showWarnings = problemSettings.showWarnings();
        } else {
            this.showWarnings = true;
        }
    }

    public CompilerProblemSeverity getProblemSeverity(ICompilerProblem problem) {
        if (problem == null) {
            throw new NullPointerException("problem may not be null");
        }
        CompilerProblemSeverity severity = null;
        if (this.userSeverity != null) {
            for (Class<?> problemClass = problem.getClass(); problemClass != null; problemClass = problemClass.getSuperclass()) {
                severity = this.userSeverity.get(problemClass);
                if (severity == null) continue;
                return this.ignoreWarningsIfRequired(severity);
            }
        }
        DefaultSeverity defaultSeverity = problem.getClass().getAnnotation(DefaultSeverity.class);
        assert (defaultSeverity != null);
        if (defaultSeverity != null) {
            return this.ignoreWarningsIfRequired(defaultSeverity.value());
        }
        return CompilerProblemSeverity.ERROR;
    }

    public CompilerProblemClassification getProblemClassification(ICompilerProblem problem) {
        if (problem == null) {
            throw new NullPointerException("problem may not be null");
        }
        ProblemClassification classification = problem.getClass().getAnnotation(ProblemClassification.class);
        assert (classification != null);
        CompilerProblemClassification ret = CompilerProblemClassification.DEFAULT;
        if (classification != null) {
            ret = classification.value();
        }
        return ret;
    }

    private CompilerProblemSeverity ignoreWarningsIfRequired(CompilerProblemSeverity severity) {
        if (!this.showWarnings && severity == CompilerProblemSeverity.WARNING) {
            return CompilerProblemSeverity.IGNORE;
        }
        return severity;
    }

    private void addToUserSeverity(Collection<Class<ICompilerProblem>> problems, CompilerProblemSeverity severity) {
        if (this.userSeverity == null) {
            this.userSeverity = new HashMap<Class<? extends ICompilerProblem>, CompilerProblemSeverity>();
        }
        for (Class<ICompilerProblem> problem : problems) {
            this.userSeverity.put(problem, severity);
        }
    }
}

