/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class OverrideContainsOnlySuperCallRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.FunctionID, (node, tokenQuery, problems) -> this.checkFunctionNode((IFunctionNode)node, tokenQuery, problems));
        return result;
    }

    private void checkFunctionNode(IFunctionNode functionNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        if (!functionNode.hasModifier(ASModifier.OVERRIDE)) {
            return;
        }
        IScopedNode scopedNode = functionNode.getScopedNode();
        if (scopedNode.getChildCount() == 0 || scopedNode.getChildCount() > 1) {
            return;
        }
        IASNode child = scopedNode.getChild(0);
        if (!(child instanceof IFunctionCallNode)) {
            return;
        }
        IFunctionCallNode functionCallNode = (IFunctionCallNode)child;
        IExpressionNode nameNode = functionCallNode.getNameNode();
        if (!(nameNode instanceof IMemberAccessExpressionNode)) {
            return;
        }
        IMemberAccessExpressionNode memberAccess = (IMemberAccessExpressionNode)nameNode;
        if (!(memberAccess.getLeftOperandNode() instanceof ILanguageIdentifierNode)) {
            return;
        }
        ILanguageIdentifierNode superNode = (ILanguageIdentifierNode)memberAccess.getLeftOperandNode();
        if (!ILanguageIdentifierNode.LanguageIdentifierKind.SUPER.equals((Object)superNode.getKind())) {
            return;
        }
        if (!(memberAccess.getRightOperandNode() instanceof IIdentifierNode)) {
            return;
        }
        IIdentifierNode rightNode = (IIdentifierNode)memberAccess.getRightOperandNode();
        if (!functionNode.getName().equals(rightNode.getName())) {
            return;
        }
        problems.add(new OverrideContainsOnlySuperCallLinterProblem(functionNode));
    }

    public static class OverrideContainsOnlySuperCallLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Method override '${functionName}' must contain more than call to 'super.${functionName}'";
        public String functionName;

        public OverrideContainsOnlySuperCallLinterProblem(IFunctionNode node) {
            super((ISourceLocation)node.getNameExpressionNode());
            this.functionName = node.getName();
        }
    }
}

