/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.parsing.ISourceFragment;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLModelPropertyContainerNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLInstanceNode;
import org.apache.royale.compiler.tree.mxml.IMXMLModelPropertyNode;
import org.apache.royale.compiler.tree.mxml.IMXMLNode;

class MXMLModelPropertyNode
extends MXMLModelPropertyContainerNodeBase
implements IMXMLModelPropertyNode {
    private static final EnumSet<MXMLDialect.TextParsingFlags> FLAGS = EnumSet.of(MXMLDialect.TextParsingFlags.ALLOW_ARRAY, MXMLDialect.TextParsingFlags.ALLOW_BINDING, MXMLDialect.TextParsingFlags.ALLOW_COMPILER_DIRECTIVE, MXMLDialect.TextParsingFlags.ALLOW_ESCAPED_COMPILER_DIRECTIVE);
    private MXMLInstanceNode instanceNode = null;

    MXMLModelPropertyNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLModelPropertyID;
    }

    @Override
    public int getChildCount() {
        return this.instanceNode != null ? 1 : super.getChildCount();
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 && this.instanceNode != null ? this.instanceNode : super.getChild(i);
    }

    @Override
    public boolean hasLeafValue() {
        return this.instanceNode != null;
    }

    @Override
    public IMXMLInstanceNode getInstanceNode() {
        return this.instanceNode;
    }

    @Override
    protected void initializeFromAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute) {
        super.initializeFromAttribute(builder, attribute);
        Collection<ICompilerProblem> problems = builder.getProblems();
        ISourceFragment[] fragments = attribute.getValueFragments(problems);
        ISourceLocation location = attribute.getValueLocation();
        this.instanceNode = this.createInstanceNode(builder, fragments, location);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLModelPropertyNode propertyNode = new MXMLModelPropertyNode(this);
        propertyNode.initializeFromAttribute(builder, attribute);
        info.addChildNode(propertyNode);
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        Collection<ICompilerProblem> problems = builder.getProblems();
        ISourceFragment[] fragments = text.getFragments(problems);
        MXMLInstanceNode instanceNode = this.createInstanceNode(builder, fragments, text);
        info.addChildNode(instanceNode);
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        List<IMXMLNode> childNodeList = info.getChildNodeList();
        if (childNodeList.size() == 1 && childNodeList.get(0) instanceof IMXMLInstanceNode) {
            this.instanceNode = (MXMLInstanceNode)childNodeList.get(0);
        } else {
            this.setPropertyNodes(childNodeList.toArray(new IMXMLModelPropertyNode[0]));
        }
        super.initializationComplete(builder, tag, info);
    }

    private MXMLInstanceNode createInstanceNode(MXMLTreeBuilder builder, ISourceFragment[] fragments, ISourceLocation location) {
        IClassDefinition anyType = ClassDefinition.getAnyTypeClassDefinition();
        MXMLClassDefinitionNode classNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
        return builder.createInstanceNode(this, anyType, fragments, location, FLAGS, classNode);
    }
}

