/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.common.IFileSpecificationGetter;
import org.apache.royale.compiler.internal.parsing.as.ASParser;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.parsing.as.IncludeHandler;
import org.apache.royale.compiler.internal.parsing.as.MetaDataPayloadToken;
import org.apache.royale.compiler.internal.parsing.as.MetadataToken;
import org.apache.royale.compiler.internal.parsing.as.RepairingTokenBuffer;
import org.apache.royale.compiler.internal.parsing.as.StreamingASTokenizer;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.problems.CannotResolveConfigExpressionProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.formatter.FormatterSettings;
import org.apache.royale.formatter.config.Semicolons;
import org.apache.royale.formatter.internal.BaseTokenFormatter;

public class ASTokenFormatter
extends BaseTokenFormatter {
    private static final int TOKEN_TYPE_EXTRA = 999999;
    private static final Pattern ASDOC_START_LINE_PATTERN = Pattern.compile("^\\*(\\s*)");
    private static final String FORMATTER_TAG_OFF = "@formatter:off";
    private static final String FORMATTER_TAG_ON = "@formatter:on";
    private int indent;
    private boolean inCaseOrDefaultClause;
    private boolean inControlFlowStatement;
    private boolean inVarOrConstDeclaration;
    private boolean inFunctionDeclaration;
    private boolean inPackageDeclaration;
    private boolean inClassDeclaration;
    private boolean inInterfaceDeclaration;
    private boolean inConfigGateForDefinition;
    private boolean blockOpenPending;
    private boolean elseNoNewLinePending;
    private boolean indentedStatement;
    private boolean caseOrDefaultBlockOpenPending;
    private boolean skipFormatting;
    private int varOrConstChainLevel;
    private List<BlockStackItem> blockStack;
    private int controlFlowParenStack;
    private int ternaryStack;
    private int numRequiredNewLines;
    private boolean requiredSpace;
    private IASToken prevTokenNotComment;
    private IASToken prevToken;
    private IASToken prevTokenOrExtra;
    private IASToken token;
    private IASToken nextToken;
    private IASToken nextTokenOrExtra;
    private IASToken nextTokenNotComment;

    public ASTokenFormatter(FormatterSettings settings) {
        super(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(String filePath, String text, Collection<ICompilerProblem> problems) {
        if (problems == null) {
            problems = new ArrayList<ICompilerProblem>();
        }
        StringReader textReader = new StringReader(text);
        StreamingASTokenizer tokenizer = null;
        ASToken[] streamingTokens = null;
        try {
            tokenizer = StreamingASTokenizer.createForRepairingASTokenizer(textReader, filePath, IncludeHandler.creatDefaultIncludeHandler());
            tokenizer.setCollectComments(true);
            tokenizer.setFollowIncludes(false);
            streamingTokens = tokenizer.getTokens(textReader);
        }
        finally {
            IOUtils.closeQuietly((Reader)textReader);
            IOUtils.closeQuietly((Closeable)tokenizer);
        }
        if (tokenizer.hasTokenizationProblems()) {
            problems.addAll(tokenizer.getTokenizationProblems());
        }
        if (!this.settings.ignoreProblems && this.hasErrors(problems)) {
            return text;
        }
        ArrayList<ASToken> comments = new ArrayList<ASToken>();
        ArrayList<ASToken> streamingTokensList = new ArrayList<ASToken>();
        for (ASToken token : streamingTokens) {
            if (token.getType() == 5 || token.getType() == 8) {
                comments.add(token);
                continue;
            }
            streamingTokensList.add(token);
        }
        Workspace workspace = new Workspace();
        RepairingTokenBuffer buffer = new RepairingTokenBuffer(streamingTokensList.toArray(new ASToken[0]));
        ASParser parser = new ASParser(workspace, buffer);
        FileNode node = new FileNode((IFileSpecificationGetter)workspace);
        try {
            parser.file(node);
        }
        catch (Exception e) {
            parser = null;
            problems.add((ICompilerProblem)new UnexpectedExceptionProblem((Throwable)e));
            return text;
        }
        if (tokenizer.hasTokenizationProblems()) {
            problems.addAll(tokenizer.getTokenizationProblems());
        }
        if (parser.getSyntaxProblems().size() > 0) {
            for (ICompilerProblem problem : parser.getSyntaxProblems()) {
                if (problem instanceof CannotResolveConfigExpressionProblem) continue;
                problems.add(problem);
            }
        }
        if (!this.settings.ignoreProblems && this.hasErrors(problems)) {
            return text;
        }
        ArrayList<IASToken> repairedTokensList = new ArrayList<IASToken>(Arrays.asList(buffer.getTokens(true)));
        IASToken nextComment = null;
        for (int i = 0; i < repairedTokensList.size(); ++i) {
            if (nextComment == null) {
                if (comments.size() == 0) break;
                nextComment = (IASToken)comments.get(0);
            }
            IASToken currentToken = (IASToken)repairedTokensList.get(i);
            if (nextComment.getAbsoluteStart() > currentToken.getAbsoluteStart()) continue;
            repairedTokensList.add(i, nextComment);
            nextComment = null;
            comments.remove(0);
        }
        repairedTokensList.addAll(comments);
        List<IASToken> tokens = this.insertExtraAS3Tokens(repairedTokensList, text);
        try {
            return this.parseTokens(tokens, text);
        }
        catch (Exception e) {
            if (problems != null) {
                System.err.println(e);
                e.printStackTrace(System.err);
                problems.add((ICompilerProblem)new UnexpectedExceptionProblem((Throwable)e));
            }
            return text;
        }
    }

    private String parseTokens(List<IASToken> tokens, String fileText) throws Exception {
        this.indent = 0;
        this.inCaseOrDefaultClause = false;
        this.inControlFlowStatement = false;
        this.inVarOrConstDeclaration = false;
        this.inFunctionDeclaration = false;
        this.inPackageDeclaration = false;
        this.inClassDeclaration = false;
        this.inInterfaceDeclaration = false;
        this.inConfigGateForDefinition = false;
        this.blockOpenPending = false;
        this.elseNoNewLinePending = false;
        this.indentedStatement = false;
        this.caseOrDefaultBlockOpenPending = false;
        this.skipFormatting = false;
        this.varOrConstChainLevel = -1;
        this.blockStack = new ArrayList<BlockStackItem>();
        this.controlFlowParenStack = 0;
        this.ternaryStack = 0;
        this.numRequiredNewLines = 0;
        this.requiredSpace = false;
        this.prevTokenNotComment = null;
        this.prevToken = null;
        this.prevTokenOrExtra = null;
        this.token = null;
        this.nextToken = null;
        this.nextTokenOrExtra = null;
        this.nextTokenNotComment = null;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            boolean skipWhitespaceBeforeSemicolon;
            this.token = tokens.get(i);
            if (this.inConfigGateForDefinition && this.token.getType() == 55 && this.token.isImplicit()) {
                this.inConfigGateForDefinition = false;
                this.prevToken = this.token;
                this.prevTokenOrExtra = this.token;
                this.prevTokenNotComment = this.token;
                continue;
            }
            if (this.token.getType() == 999999) {
                if (this.skipFormatting) {
                    builder.append(this.token.getText());
                } else {
                    if (i == tokens.size() - 1) {
                        this.numRequiredNewLines = Math.min(1, Math.max(0, this.countNewLinesInExtra(this.token)));
                        this.appendNewLines(builder, this.numRequiredNewLines);
                        break;
                    }
                    if (!this.blockOpenPending && !this.elseNoNewLinePending) {
                        boolean oneLineBlock;
                        int newLinesInExtra = this.countNewLinesInExtra(this.token);
                        if (this.prevToken != null && this.prevToken.getType() == 5) {
                            ++newLinesInExtra;
                        }
                        boolean bl = oneLineBlock = this.prevToken != null && this.prevToken.getType() == 22 && this.nextToken != null && this.nextToken.getType() == 23;
                        if (oneLineBlock && this.settings.collapseEmptyBlocks) {
                            newLinesInExtra = 0;
                        }
                        this.numRequiredNewLines = Math.max(this.numRequiredNewLines, newLinesInExtra);
                        if (!(this.indentedStatement || this.numRequiredNewLines <= 0 || this.prevTokenNotComment == null || this.prevTokenNotComment.getType() == 55 || this.prevTokenNotComment.getType() == 23 || this.caseOrDefaultBlockOpenPending && this.prevTokenNotComment.getType() == 24 || this.prevTokenNotComment instanceof MetaDataPayloadToken)) {
                            boolean needsIndent;
                            boolean bl2 = needsIndent = this.prevTokenNotComment.getType() != 22 || !this.blockStack.isEmpty() && this.blockStack.get(this.blockStack.size() - 1) instanceof ObjectLiteralBlockStackItem;
                            if (needsIndent) {
                                this.startIndentedStatement();
                            }
                        }
                    }
                }
                this.prevTokenOrExtra = this.token;
                continue;
            }
            this.nextTokenOrExtra = i + 1 < tokens.size() ? tokens.get(i + 1) : null;
            this.nextToken = this.getNextTokenByOffset(tokens, i, 1, true, false);
            this.nextTokenNotComment = this.getNextTokenByOffset(tokens, i, 1, true, true);
            boolean bl = skipWhitespaceBeforeSemicolon = this.nextToken == null || this.nextToken.getType() == 55;
            if (this.token instanceof MetaDataPayloadToken) {
                this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
            } else {
                switch (this.token.getType()) {
                    case 22: {
                        if (!this.blockOpenPending) {
                            boolean bl3 = this.blockOpenPending = this.prevTokenNotComment == null || this.prevTokenNotComment.getType() == 55 || this.prevTokenNotComment.getType() == 22 || this.prevTokenNotComment.getType() == 23;
                            if (!this.blockOpenPending && this.prevTokenNotComment.getType() == 24 && !this.blockStack.isEmpty()) {
                                IASToken blockToken = this.blockStack.get((int)(this.blockStack.size() - 1)).token;
                                boolean bl4 = this.blockOpenPending = blockToken.getType() == 70 || blockToken.getType() == 69;
                            }
                            if (this.blockOpenPending) {
                                this.blockStack.add(new BlockStackItem(this.token));
                            }
                        }
                        if (this.blockOpenPending) {
                            boolean needsNewLine;
                            boolean oneLineBlock = this.nextToken != null && this.nextToken.getType() == 23;
                            boolean bl5 = needsNewLine = this.settings.placeOpenBraceOnNewLine && (!this.settings.collapseEmptyBlocks || !oneLineBlock);
                            if (needsNewLine) {
                                this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                            } else if (oneLineBlock && this.settings.collapseEmptyBlocks) {
                                this.numRequiredNewLines = 0;
                            }
                            this.requiredSpace = true;
                            break;
                        }
                        this.blockStack.add(new ObjectLiteralBlockStackItem(this.token));
                        this.requiredSpace = this.prevTokenNotComment == null || this.prevTokenNotComment.getType() != 46;
                        break;
                    }
                    case 23: {
                        boolean skipSwitchDecrease = false;
                        if (!this.blockStack.isEmpty()) {
                            BlockStackItem stackItem = this.blockStack.get(this.blockStack.size() - 1);
                            if (stackItem.blockDepth <= 1) {
                                boolean oneLineBlock;
                                boolean bl6 = oneLineBlock = this.prevToken != null && this.prevToken.getType() == 22 && !(stackItem instanceof ObjectLiteralBlockStackItem);
                                if (!this.settings.collapseEmptyBlocks || !oneLineBlock) {
                                    this.indent = this.decreaseIndent(this.indent);
                                }
                                if (stackItem.token.getType() == 69 || stackItem.token.getType() == 70) {
                                    this.blockStack.remove(this.blockStack.size() - 1);
                                    this.indent = this.decreaseIndent(this.indent);
                                    skipSwitchDecrease = true;
                                }
                            }
                        }
                        if (skipSwitchDecrease || this.blockStack.isEmpty()) break;
                        BlockStackItem stackItem = this.blockStack.get(this.blockStack.size() - 1);
                        if (stackItem.token.getType() != 68) break;
                        SwitchBlockStackItem switchStackItem = (SwitchBlockStackItem)stackItem;
                        if (switchStackItem.clauseCount <= 0 || this.prevToken != null && this.prevToken.getType() == 23) break;
                        this.indent = this.decreaseIndent(this.indent);
                        break;
                    }
                    case 129: {
                        if (this.blockStack.isEmpty()) break;
                        BlockStackItem stackItem = this.blockStack.get(this.blockStack.size() - 1);
                        if (stackItem.token.getType() != 38) break;
                        this.indent = this.decreaseIndent(this.indent);
                        this.blockStack.remove(this.blockStack.size() - 1);
                        break;
                    }
                    case 47: {
                        if (this.blockStack.isEmpty()) break;
                        BlockStackItem stackItem = this.blockStack.get(this.blockStack.size() - 1);
                        if (stackItem.token.getType() != 46) break;
                        this.indent = this.decreaseIndent(this.indent);
                        this.blockStack.remove(this.blockStack.size() - 1);
                        break;
                    }
                    case 59: {
                        this.inVarOrConstDeclaration = false;
                        this.requiredSpace = true;
                        break;
                    }
                    case 5: 
                    case 8: 
                    case 11: 
                    case 41: 
                    case 44: 
                    case 102: 
                    case 103: {
                        this.requiredSpace = true;
                        break;
                    }
                    case 67: {
                        if (!this.elseNoNewLinePending) break;
                        this.numRequiredNewLines = 0;
                        this.elseNoNewLinePending = false;
                        this.requiredSpace = true;
                        break;
                    }
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 109: 
                    case 110: 
                    case 112: {
                        if (!this.settings.insertSpaceBeforeAndAfterBinaryOperators) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 111: {
                        boolean isAnyType = this.checkTokenBeforeAnyType(this.prevTokenNotComment);
                        boolean isAnyVectorType = this.checkTokensForAnyVectorType(this.prevTokenNotComment, this.nextTokenNotComment);
                        if (isAnyType || isAnyVectorType || !this.settings.insertSpaceBeforeAndAfterBinaryOperators || skipWhitespaceBeforeSemicolon) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 107: 
                    case 108: {
                        boolean isUnary = this.checkTokenBeforePossibleUnaryOperator(this.prevTokenNotComment);
                        if (isUnary || !this.settings.insertSpaceBeforeAndAfterBinaryOperators) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 53: {
                        this.inVarOrConstDeclaration = false;
                        if (!this.settings.insertSpaceBeforeAndAfterBinaryOperators) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 88: {
                        ++this.ternaryStack;
                        if (!this.settings.insertSpaceBeforeAndAfterBinaryOperators) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 50: {
                        boolean isFirstArg;
                        boolean bl7 = isFirstArg = this.prevToken == null || this.prevToken.getType() == 46;
                        if (isFirstArg) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 69: 
                    case 70: {
                        if (!this.blockStack.isEmpty()) {
                            BlockStackItem stackItem = this.blockStack.get(this.blockStack.size() - 1);
                            switch (stackItem.token.getType()) {
                                case 69: 
                                case 70: {
                                    this.blockStack.remove(this.blockStack.size() - 1);
                                    this.indent = this.decreaseIndent(this.indent);
                                }
                            }
                        }
                        if (this.blockStack.isEmpty()) break;
                        BlockStackItem stackItem = this.blockStack.get(this.blockStack.size() - 1);
                        if (stackItem.token.getType() != 68) break;
                        SwitchBlockStackItem switchStackItem = (SwitchBlockStackItem)stackItem;
                        ++switchStackItem.clauseCount;
                        this.inCaseOrDefaultClause = true;
                        this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                        this.blockStack.add(new BlockStackItem(this.token));
                        break;
                    }
                    case 24: {
                        if (this.ternaryStack <= 0) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 55: {
                        this.endIndentedStatement();
                        this.inVarOrConstDeclaration = false;
                        this.varOrConstChainLevel = -1;
                        break;
                    }
                    case 28: {
                        this.numRequiredNewLines = this.prevToken != null && this.prevToken.getType() == 22 ? Math.max(this.numRequiredNewLines, 1) : Math.max(this.numRequiredNewLines, 2);
                    }
                }
            }
            if (!this.skipFormatting && this.prevToken != null) {
                if (this.numRequiredNewLines > 0) {
                    this.appendNewLines(builder, this.numRequiredNewLines);
                    this.appendIndent(builder, this.indent);
                } else if (this.requiredSpace) {
                    builder.append(' ');
                }
            }
            switch (this.token.getType()) {
                case 22: {
                    boolean oneLineBlock;
                    if (!this.blockOpenPending) break;
                    boolean bl8 = oneLineBlock = this.nextToken != null && this.nextToken.getType() == 23;
                    if (!this.settings.placeOpenBraceOnNewLine || this.settings.collapseEmptyBlocks && oneLineBlock) break;
                    this.indent = this.increaseIndent(this.indent);
                }
            }
            builder.append(this.getTokenText(this.token, this.indent, this.skipFormatting, fileText));
            if (this.token.getType() != 5 && this.token.getType() != 8 && this.token.getType() != 28 && this.token.getType() != 22) {
                this.blockOpenPending = false;
            }
            if (this.token.getType() != 5 && this.token.getType() != 8 && this.token.getType() != 28) {
                this.caseOrDefaultBlockOpenPending = false;
            }
            this.requiredSpace = false;
            this.numRequiredNewLines = 0;
            if (this.token instanceof MetaDataPayloadToken) {
                this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
            } else {
                switch (this.token.getType()) {
                    case 55: {
                        if (this.inControlFlowStatement && this.isInForStatement(this.blockStack)) {
                            if (this.settings.insertSpaceAfterSemicolonInForStatements) {
                                this.requiredSpace = true;
                            }
                        } else {
                            boolean checkNext = true;
                            while (!this.blockStack.isEmpty() && checkNext) {
                                checkNext = false;
                                BlockStackItem prevStackItem = this.blockStack.get(this.blockStack.size() - 1);
                                if (prevStackItem.token.getType() == 69 || prevStackItem.token.getType() == 70 || prevStackItem.blockDepth > 0) continue;
                                this.blockStack.remove(this.blockStack.size() - 1);
                                if (prevStackItem.token.getType() == 43 || prevStackItem.token.getType() == 40 || prevStackItem.token.getType() == 45) continue;
                                checkNext = !prevStackItem.braces;
                                this.indent = this.decreaseIndent(this.indent);
                            }
                        }
                        if (this.inControlFlowStatement) break;
                        if (this.nextToken != null && (this.nextToken.getType() == 5 || this.nextToken.getType() == 8)) {
                            this.requiredSpace = true;
                            break;
                        }
                        this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                        break;
                    }
                    case 22: {
                        boolean oneLineBlock;
                        BlockStackItem stackItem;
                        if (!this.blockStack.isEmpty() && (stackItem = this.blockStack.get(this.blockStack.size() - 1)) instanceof ObjectLiteralBlockStackItem) {
                            this.indent = this.increaseIndent(this.indent);
                        }
                        if (!this.blockOpenPending) break;
                        this.blockOpenPending = false;
                        if (!this.blockStack.isEmpty()) {
                            stackItem = this.blockStack.get(this.blockStack.size() - 1);
                            ++stackItem.blockDepth;
                        }
                        boolean bl9 = oneLineBlock = this.nextToken != null && this.nextToken.getType() == 23;
                        if (this.settings.collapseEmptyBlocks && oneLineBlock) break;
                        if (!this.settings.placeOpenBraceOnNewLine) {
                            this.indent = this.increaseIndent(this.indent);
                        }
                        this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                        break;
                    }
                    case 23: {
                        if (this.blockStack.isEmpty()) break;
                        BlockStackItem stackItem = this.blockStack.get(this.blockStack.size() - 1);
                        --stackItem.blockDepth;
                        if (stackItem.blockDepth <= 0) {
                            this.blockStack.remove(this.blockStack.size() - 1);
                        }
                        if (stackItem instanceof ObjectLiteralBlockStackItem) break;
                        if (this.nextToken != null && this.nextTokenNotComment != null && this.nextToken.getType() != 5 && this.nextTokenNotComment.getType() == 67 && !this.settings.insertNewLineElse) {
                            this.elseNoNewLinePending = true;
                            break;
                        }
                        if (this.nextToken != null && (this.nextToken.getType() == 55 || this.nextToken.getType() == 47 || this.nextToken.getType() == 42 || this.nextToken.getType() == 5 || this.nextToken.getType() == 8)) break;
                        this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                        break;
                    }
                    case 38: {
                        this.blockStack.add(new BlockStackItem(this.token));
                        this.indent = this.increaseIndent(this.indent);
                        break;
                    }
                    case 46: {
                        this.blockStack.add(new BlockStackItem(this.token));
                        this.indent = this.increaseIndent(this.indent);
                        if (!this.inControlFlowStatement) break;
                        ++this.controlFlowParenStack;
                        break;
                    }
                    case 15: {
                        IASToken nextNextToken;
                        IASToken prevPrevToken;
                        boolean isConfigBlock;
                        if (this.prevToken == null || this.prevToken.getType() != 20) break;
                        boolean bl10 = isConfigBlock = this.nextToken != null && this.nextToken.getType() == 22;
                        if (isConfigBlock) {
                            this.blockStack.add(new BlockStackItem(this.prevToken));
                            this.blockOpenPending = true;
                            break;
                        }
                        if (this.nextToken == null || this.nextToken.getType() != 55 || !this.nextToken.isImplicit() || (prevPrevToken = this.getPrevTokenByOffset(tokens, i, 3, true, true)) != null && prevPrevToken.getType() != 55 && prevPrevToken.getType() != 22 && prevPrevToken.getType() != 23 || (nextNextToken = this.getNextTokenByOffset(tokens, i, 2, true, true)) == null || nextNextToken.getType() != 21 && nextNextToken.getType() != 43 && nextNextToken.getType() != 40 && nextNextToken.getType() != 45 && nextNextToken.getType() != 51 && nextNextToken.getType() != 52 && nextNextToken.getType() != 35 && nextNextToken.getType() != 30 && nextNextToken.getType() != 29 && nextNextToken.getType() != 33 && nextNextToken.getType() != 31 && nextNextToken.getType() != 32 && nextNextToken.getType() != 34) break;
                        this.inConfigGateForDefinition = true;
                        break;
                    }
                    case 47: {
                        if (!this.inControlFlowStatement) break;
                        --this.controlFlowParenStack;
                        if (this.controlFlowParenStack > 0) break;
                        this.endIndentedStatement();
                        this.inControlFlowStatement = false;
                        this.inVarOrConstDeclaration = false;
                        if (!this.blockStack.isEmpty()) {
                            BlockStackItem stackItem = this.blockStack.get(this.blockStack.size() - 1);
                            stackItem.controlFlowEnd = this.token.getEnd();
                        }
                        this.controlFlowParenStack = 0;
                        this.blockOpenPending = true;
                        if (this.nextToken != null && this.nextToken.getType() == 55) {
                            this.blockStack.remove(this.blockStack.size() - 1);
                            if (skipWhitespaceBeforeSemicolon) break;
                            this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                            break;
                        }
                        if (this.nextTokenNotComment == null || this.nextTokenNotComment.getType() == 22 || skipWhitespaceBeforeSemicolon) break;
                        this.indent = this.increaseIndent(this.indent);
                        BlockStackItem stackItem = this.blockStack.get(this.blockStack.size() - 1);
                        stackItem.braces = false;
                        if (this.nextToken.getType() == 5 || this.nextToken.getType() == 8 || this.nextToken.getType() == 4) break;
                        this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                        break;
                    }
                    case 114: 
                    case 115: {
                        if (this.inControlFlowStatement || this.checkTokenBeforePossibleUnaryOperator(this.prevTokenNotComment) || this.checkTokenAfterPossibleUnaryOperator(this.nextTokenNotComment)) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 56: 
                    case 62: 
                    case 63: {
                        if (skipWhitespaceBeforeSemicolon) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 39: {
                        this.blockStack.add(new BlockStackItem(this.token));
                        this.requiredSpace = true;
                        this.inPackageDeclaration = true;
                        break;
                    }
                    case 43: {
                        this.blockStack.add(new BlockStackItem(this.token));
                        this.requiredSpace = true;
                        this.inClassDeclaration = true;
                        break;
                    }
                    case 40: {
                        this.blockStack.add(new BlockStackItem(this.token));
                        this.requiredSpace = true;
                        this.inInterfaceDeclaration = true;
                        break;
                    }
                    case 45: {
                        boolean skipSpace;
                        this.blockStack.add(new BlockStackItem(this.token));
                        this.inFunctionDeclaration = true;
                        boolean bl11 = skipSpace = !this.settings.insertSpaceAfterFunctionKeywordForAnonymousFunctions && this.nextToken != null && this.nextToken.getType() == 46;
                        if (skipSpace) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 51: 
                    case 52: {
                        this.inVarOrConstDeclaration = true;
                        this.requiredSpace = true;
                        this.varOrConstChainLevel = this.blockStack.size();
                        break;
                    }
                    case 17: 
                    case 58: 
                    case 61: 
                    case 64: 
                    case 66: {
                        this.inControlFlowStatement = true;
                        BlockStackItem stackItem = new BlockStackItem(this.token);
                        stackItem.controlFlow = true;
                        this.blockStack.add(stackItem);
                        if (!this.settings.insertSpaceAfterKeywordsInControlFlowStatements || skipWhitespaceBeforeSemicolon) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 68: {
                        this.inControlFlowStatement = true;
                        this.blockStack.add(new SwitchBlockStackItem(this.token));
                        if (!this.settings.insertSpaceAfterKeywordsInControlFlowStatements || skipWhitespaceBeforeSemicolon) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 16: 
                    case 65: {
                        this.blockStack.add(new BlockStackItem(this.token));
                        if (!skipWhitespaceBeforeSemicolon) {
                            this.requiredSpace = true;
                        }
                        this.blockOpenPending = true;
                        break;
                    }
                    case 67: {
                        if (this.nextTokenNotComment != null && this.nextTokenNotComment.getType() == 66) {
                            this.requiredSpace = true;
                            break;
                        }
                        this.blockStack.add(new BlockStackItem(this.token));
                        this.blockOpenPending = true;
                        if (this.nextToken != null && this.nextToken.getType() == 55) {
                            this.blockStack.remove(this.blockStack.size() - 1);
                            if (skipWhitespaceBeforeSemicolon) break;
                            this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                            break;
                        }
                        if (this.nextToken == null || this.nextToken.getType() == 22 || this.nextToken.getType() == 5 || skipWhitespaceBeforeSemicolon) break;
                        this.indent = this.increaseIndent(this.indent);
                        this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                        break;
                    }
                    case 60: {
                        this.blockStack.add(new BlockStackItem(this.token));
                        this.blockOpenPending = true;
                        if (this.nextToken != null && this.nextToken.getType() == 55) {
                            this.blockStack.remove(this.blockStack.size() - 1);
                            if (skipWhitespaceBeforeSemicolon) break;
                            this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                            break;
                        }
                        if (this.nextToken == null || this.nextToken.getType() == 22 || this.nextToken.getType() == 5 || skipWhitespaceBeforeSemicolon) break;
                        this.indent = this.increaseIndent(this.indent);
                        this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                        break;
                    }
                    case 24: {
                        if (this.ternaryStack > 0) {
                            --this.ternaryStack;
                            this.requiredSpace = true;
                            break;
                        }
                        if (this.inControlFlowStatement || this.inVarOrConstDeclaration || this.inFunctionDeclaration) break;
                        if (this.inCaseOrDefaultClause) {
                            IASToken afterBlockClose;
                            boolean nextIsBlock;
                            this.inCaseOrDefaultClause = false;
                            this.caseOrDefaultBlockOpenPending = true;
                            boolean bl12 = nextIsBlock = this.nextTokenNotComment != null && this.nextTokenNotComment.getType() == 22;
                            if (nextIsBlock && (afterBlockClose = this.findTokenAfterBlock(this.nextTokenNotComment, tokens)) != null && (afterBlockClose.getType() == 23 || afterBlockClose.getType() == 69 || afterBlockClose.getType() == 70)) {
                                this.blockOpenPending = true;
                                this.requiredSpace = true;
                                this.blockStack.remove(this.blockStack.size() - 1);
                            }
                            if (nextIsBlock && this.blockOpenPending) break;
                            this.indent = this.increaseIndent(this.indent);
                            if (this.nextToken != null && (this.nextToken.getType() == 5 || this.nextToken.getType() == 8)) {
                                this.requiredSpace = true;
                                break;
                            }
                            this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                            break;
                        }
                        this.requiredSpace = true;
                        break;
                    }
                    case 69: {
                        if (skipWhitespaceBeforeSemicolon) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 70: {
                        if (this.inCaseOrDefaultClause || skipWhitespaceBeforeSemicolon) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 21: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 41: 
                    case 44: 
                    case 48: 
                    case 49: 
                    case 57: 
                    case 59: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 113: 
                    case 117: 
                    case 155: {
                        if (skipWhitespaceBeforeSemicolon) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 53: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 109: 
                    case 110: 
                    case 112: {
                        if (!this.settings.insertSpaceBeforeAndAfterBinaryOperators || skipWhitespaceBeforeSemicolon) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 111: {
                        boolean isAnyType = this.checkTokenBeforeAnyType(this.prevTokenNotComment);
                        boolean isAnyVectorType = this.checkTokensForAnyVectorType(this.prevTokenNotComment, this.nextTokenNotComment);
                        if (isAnyType || isAnyVectorType || !this.settings.insertSpaceBeforeAndAfterBinaryOperators || skipWhitespaceBeforeSemicolon) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 107: 
                    case 108: {
                        boolean isUnary = this.checkTokenBeforePossibleUnaryOperator(this.prevTokenNotComment);
                        if (isUnary || !this.settings.insertSpaceBeforeAndAfterBinaryOperators || skipWhitespaceBeforeSemicolon) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 42: {
                        if (this.varOrConstChainLevel == this.blockStack.size()) {
                            this.inVarOrConstDeclaration = true;
                        }
                        if (!this.settings.insertSpaceAfterCommaDelimiter || skipWhitespaceBeforeSemicolon) break;
                        this.requiredSpace = true;
                        break;
                    }
                    case 5: {
                        this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                        String trimmed = this.token.getText().substring(2).trim();
                        if (!this.skipFormatting && FORMATTER_TAG_OFF.equals(trimmed)) {
                            this.skipFormatting = true;
                            this.appendNewLines(builder, 1);
                            break;
                        }
                        if (!this.skipFormatting || !FORMATTER_TAG_ON.equals(trimmed)) break;
                        this.skipFormatting = false;
                        this.numRequiredNewLines = 0;
                        break;
                    }
                    case 8: 
                    case 28: {
                        if (skipWhitespaceBeforeSemicolon || this.nextTokenOrExtra == null || this.nextTokenOrExtra.getType() != 999999) break;
                        this.numRequiredNewLines = Math.max(0, this.countNewLinesInExtra(this.nextTokenOrExtra));
                        this.requiredSpace = true;
                    }
                }
            }
            if ((this.inPackageDeclaration || this.inClassDeclaration || this.inInterfaceDeclaration || this.inFunctionDeclaration) && this.nextToken != null && this.nextToken.getType() == 22) {
                this.blockOpenPending = true;
                this.endIndentedStatement();
                this.inPackageDeclaration = false;
                this.inClassDeclaration = false;
                this.inInterfaceDeclaration = false;
                this.inFunctionDeclaration = false;
            }
            this.prevTokenOrExtra = this.prevToken = this.token;
            if (this.prevToken.getType() == 5 || this.prevToken.getType() == 8 || this.prevToken.getType() == 28) continue;
            this.prevTokenNotComment = this.prevToken;
        }
        if (this.blockStack.size() > 0) {
            throw new Exception("Unexpected end of file. Blocks still considered open by formatter. This is a bug.");
        }
        return builder.toString();
    }

    private IASToken getPrevTokenByOffset(List<IASToken> tokens, int startIndex, int offset, boolean skipExtra, boolean skipComments) {
        int current = 0;
        for (int i = startIndex; i >= 0; --i) {
            IASToken token = tokens.get(i);
            if (skipExtra && token.getType() == 999999 || skipComments && (token.getType() == 5 || token.getType() == 8 || token.getType() == 28)) continue;
            if (current == offset) {
                return token;
            }
            ++current;
        }
        return null;
    }

    private IASToken getNextTokenByOffset(List<IASToken> tokens, int startIndex, int offset, boolean skipExtra, boolean skipComments) {
        int current = 0;
        for (int i = startIndex; i < tokens.size(); ++i) {
            IASToken token = tokens.get(i);
            if (skipExtra && token.getType() == 999999 || skipComments && (token.getType() == 5 || token.getType() == 8 || token.getType() == 28)) continue;
            if (current == offset) {
                return token;
            }
            ++current;
        }
        return null;
    }

    private void startIndentedStatement() {
        for (int i = this.blockStack.size() - 1; i >= 0; --i) {
            BlockStackItem stackItem = this.blockStack.get(i);
            if (this.inPackageDeclaration) {
                if (stackItem.token.getType() != 39) continue;
                if (!stackItem.indentedStatement) {
                    stackItem.indentedStatement = true;
                    this.indent = this.increaseIndent(this.indent);
                }
                return;
            }
            if (this.inClassDeclaration) {
                if (stackItem.token.getType() != 43) continue;
                if (!stackItem.indentedStatement) {
                    stackItem.indentedStatement = true;
                    this.indent = this.increaseIndent(this.indent);
                }
                return;
            }
            if (this.inInterfaceDeclaration) {
                if (stackItem.token.getType() != 40) continue;
                if (!stackItem.indentedStatement) {
                    stackItem.indentedStatement = true;
                    this.indent = this.increaseIndent(this.indent);
                }
                return;
            }
            if (this.inFunctionDeclaration) {
                if (stackItem.token.getType() != 45) continue;
                if (!stackItem.indentedStatement) {
                    stackItem.indentedStatement = true;
                    this.indent = this.increaseIndent(this.indent);
                }
                return;
            }
            if (this.inControlFlowStatement) {
                if (!stackItem.controlFlow) continue;
                if (!stackItem.indentedStatement) {
                    stackItem.indentedStatement = true;
                    this.indent = this.increaseIndent(this.indent);
                }
                return;
            }
            if (stackItem.token.getType() != 45) continue;
            if (!stackItem.indentedStatement) {
                stackItem.indentedStatement = true;
                this.indent = this.increaseIndent(this.indent);
            }
            return;
        }
        if (this.inPackageDeclaration || this.inClassDeclaration || this.inInterfaceDeclaration || this.inFunctionDeclaration || this.inControlFlowStatement) {
            return;
        }
        if (!this.indentedStatement) {
            this.indentedStatement = true;
            this.indent = this.increaseIndent(this.indent);
        }
    }

    private void endIndentedStatement() {
        for (int i = this.blockStack.size() - 1; i >= 0; --i) {
            BlockStackItem stackItem = this.blockStack.get(i);
            if (this.inPackageDeclaration) {
                if (stackItem.token.getType() != 39) continue;
                if (stackItem.indentedStatement) {
                    stackItem.indentedStatement = false;
                    this.indent = this.decreaseIndent(this.indent);
                }
                return;
            }
            if (this.inClassDeclaration) {
                if (stackItem.token.getType() != 43) continue;
                if (stackItem.indentedStatement) {
                    stackItem.indentedStatement = false;
                    this.indent = this.decreaseIndent(this.indent);
                }
                return;
            }
            if (this.inInterfaceDeclaration) {
                if (stackItem.token.getType() != 40) continue;
                if (stackItem.indentedStatement) {
                    stackItem.indentedStatement = false;
                    this.indent = this.decreaseIndent(this.indent);
                }
                return;
            }
            if (this.inFunctionDeclaration) {
                if (stackItem.token.getType() != 45) continue;
                if (stackItem.indentedStatement) {
                    stackItem.indentedStatement = false;
                    this.indent = this.decreaseIndent(this.indent);
                }
                return;
            }
            if (this.inControlFlowStatement) {
                if (!stackItem.controlFlow) continue;
                if (stackItem.indentedStatement) {
                    stackItem.indentedStatement = false;
                    this.indent = this.decreaseIndent(this.indent);
                }
                return;
            }
            if (stackItem.token.getType() != 45) continue;
            if (stackItem.indentedStatement) {
                stackItem.indentedStatement = false;
                this.indent = this.decreaseIndent(this.indent);
            }
            return;
        }
        if (this.inClassDeclaration || this.inInterfaceDeclaration || this.inFunctionDeclaration || this.inControlFlowStatement) {
            return;
        }
        if (this.indentedStatement) {
            this.indentedStatement = false;
            this.indent = this.decreaseIndent(this.indent);
        }
    }

    private String getTokenText(IASToken token, int indent, boolean skipFormatting, String fileText) {
        if (token instanceof MetaDataPayloadToken) {
            MetaDataPayloadToken metaPlayloadToken = (MetaDataPayloadToken)token;
            return this.formatMetadataToken(metaPlayloadToken);
        }
        switch (token.getType()) {
            case 28: {
                if (skipFormatting) {
                    String tokenText = token.getText();
                    if (tokenText != null) {
                        return tokenText;
                    }
                    return "";
                }
                return this.formatASDocComment(token.getText(), indent);
            }
            case 5: {
                if (skipFormatting) {
                    String tokenText = token.getText();
                    if (tokenText != null) {
                        return tokenText;
                    }
                    return "";
                }
                return this.formatSingleLineComment(token.getText());
            }
            case 8: {
                if (skipFormatting) {
                    String tokenText = token.getText();
                    if (tokenText != null) {
                        return tokenText;
                    }
                    return "";
                }
                return this.formatMultiLineComment(token.getText());
            }
            case 18: {
                return this.formatLiteralString(token, fileText);
            }
            case 55: {
                String tokenText;
                boolean skipSemicolon;
                if (skipFormatting) {
                    if (token.isImplicit()) {
                        return "";
                    }
                    String tokenText2 = token.getText();
                    if (tokenText2 != null) {
                        return tokenText2;
                    }
                    return "";
                }
                boolean bl = skipSemicolon = Semicolons.REMOVE.equals((Object)this.settings.semicolons) || Semicolons.IGNORE.equals((Object)this.settings.semicolons) && token.isImplicit();
                if (!skipSemicolon && (tokenText = token.getText()) != null) {
                    return tokenText;
                }
                return "";
            }
        }
        String tokenText = token.getText();
        if (tokenText != null) {
            return tokenText;
        }
        return "";
    }

    private String formatMetadataToken(MetaDataPayloadToken token) {
        StringBuilder builder = new StringBuilder();
        boolean needsComma = false;
        List<MetadataToken> payload = token.getPayload();
        block4: for (int i = 0; i < payload.size(); ++i) {
            MetadataToken metaToken = payload.get(i);
            switch (metaToken.getType()) {
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 50: 
                case 51: 
                case 62: {
                    if (needsComma) {
                        builder.append(",");
                        if (this.settings.insertSpaceBetweenMetadataAttributes) {
                            builder.append(" ");
                        }
                    }
                    needsComma = true;
                    builder.append(metaToken.getText());
                    MetadataToken nextToken = payload.get(i + 1);
                    if (nextToken.getType() != 8) continue block4;
                    builder.append("=");
                    builder.append("\"");
                    builder.append(nextToken.getText());
                    builder.append("\"");
                    ++i;
                    continue block4;
                }
                case 8: {
                    if (needsComma) {
                        builder.append(",");
                        if (this.settings.insertSpaceBetweenMetadataAttributes) {
                            builder.append(" ");
                        }
                    }
                    builder.append("\"");
                    builder.append(metaToken.getText());
                    builder.append("\"");
                    needsComma = true;
                    continue block4;
                }
                default: {
                    builder.append(metaToken.getText());
                }
            }
        }
        return builder.toString();
    }

    private String formatSingleLineComment(String comment) {
        comment = comment.substring(2).trim();
        StringBuilder builder = new StringBuilder();
        builder.append("//");
        if (this.settings.insertSpaceAtStartOfLineComment) {
            builder.append(" ");
        }
        builder.append(comment);
        return builder.toString();
    }

    private String formatMultiLineComment(String comment) {
        return comment;
    }

    private String formatLiteralString(IASToken token, String fileText) {
        int start = token.getAbsoluteStart();
        int end = token.getAbsoluteEnd();
        if (start != -1 && start < end && end < fileText.length()) {
            return fileText.substring(start, end);
        }
        String string = token.getText();
        Object charsToEscape = "\b\t\n\f\r\\";
        Object escapeChars = "btnfr\\";
        int escapeIndex = -1;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char currChar = string.charAt(i);
            if (i == 0) {
                charsToEscape = (String)charsToEscape + currChar;
                escapeChars = (String)escapeChars + currChar;
                builder.append(currChar);
                continue;
            }
            if (i == string.length() - 1) {
                builder.append(currChar);
                continue;
            }
            escapeIndex = ((String)charsToEscape).indexOf(currChar);
            if (escapeIndex != -1) {
                builder.append("\\");
                builder.append(((String)escapeChars).charAt(escapeIndex));
                continue;
            }
            builder.append(currChar);
        }
        return builder.toString();
    }

    private boolean isInListing(String lineText, boolean alreadyInListing) {
        boolean inListing = alreadyInListing;
        for (int searchIndex = 0; searchIndex < lineText.length(); searchIndex += 10) {
            if (!inListing) {
                if ((searchIndex = lineText.indexOf("<listing", searchIndex)) == -1) {
                    return false;
                }
                searchIndex += 8;
                inListing = true;
            }
            if ((searchIndex = lineText.indexOf("</listing>", searchIndex)) == -1) {
                return true;
            }
            inListing = false;
        }
        return inListing;
    }

    private String formatASDocComment(String comment, int indent) {
        String[] lines = comment.split("\n");
        StringBuilder builder = new StringBuilder();
        Object lineText = lines[0].trim();
        builder.append((String)lineText);
        boolean inListing = this.isInListing((String)lineText, false);
        if (lines.length > 1) {
            builder.append('\n');
        }
        String listingIndent = null;
        for (int i = 1; i < lines.length - 1; ++i) {
            Matcher startMatcher;
            lineText = lines[i].trim();
            if (inListing && (startMatcher = ASDOC_START_LINE_PATTERN.matcher((CharSequence)lineText)).find()) {
                if (listingIndent == null) {
                    listingIndent = startMatcher.group(1);
                } else if (startMatcher.group().length() >= ((String)lineText).length()) {
                    lineText = "*" + listingIndent;
                }
            }
            this.appendIndent(builder, indent);
            builder.append(' ');
            builder.append((String)lineText);
            builder.append('\n');
            inListing = this.isInListing((String)lineText, inListing);
            if (inListing) continue;
            listingIndent = null;
        }
        if (lines.length > 1) {
            this.appendIndent(builder, indent);
            builder.append(' ');
            builder.append(lines[lines.length - 1].trim());
        }
        return builder.toString();
    }

    private boolean checkTokenBeforeAnyType(IASToken token) {
        return token.getType() == 24;
    }

    private boolean checkTokensForAnyVectorType(IASToken prevToken, IASToken nextToken) {
        return prevToken != null && nextToken != null && (prevToken.getType() == 72 && nextToken.getType() == 73 || prevToken.getType() == 130 && nextToken.getType() == 131);
    }

    private boolean checkTokenBeforePossibleUnaryOperator(IASToken token) {
        if (token instanceof ASToken) {
            if (token.getType() == 47 && !this.blockStack.isEmpty()) {
                BlockStackItem stackItem = this.blockStack.get(this.blockStack.size() - 1);
                if (stackItem.controlFlowEnd == token.getEnd()) {
                    return true;
                }
            }
            return ((ASToken)token).isOperator() || token.getType() == 38 || token.getType() == 46 || token.getType() == 22 || token.getType() == 23 || token.getType() == 55 || token.getType() == 56 || token.getType() == 42 || token.getType() == 24;
        }
        return token == null;
    }

    private boolean checkTokenAfterPossibleUnaryOperator(IASToken token) {
        if (token instanceof ASToken) {
            return ((ASToken)token).isOperator() || token.getType() == 129 || token.getType() == 47 || token.getType() == 22 || token.getType() == 23 || token.getType() == 55 || token.getType() == 42;
        }
        return token == null;
    }

    private boolean isInForStatement(List<BlockStackItem> blockStack) {
        block4: for (int i = blockStack.size() - 1; i >= 0; --i) {
            BlockStackItem stackItem = blockStack.get(i);
            switch (stackItem.token.getType()) {
                case 22: 
                case 38: 
                case 46: {
                    continue block4;
                }
                case 58: {
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    private IASToken findTokenAfterBlock(IASToken tokenBlockOpen, List<IASToken> tokens) {
        int startIndex;
        ArrayList<IASToken> stack = new ArrayList<IASToken>();
        for (int i = startIndex = tokens.indexOf(tokenBlockOpen) + 1; i < tokens.size(); ++i) {
            IASToken current = tokens.get(i);
            if (current.getType() == 22) {
                stack.add(current);
                continue;
            }
            if (current.getType() != 23) continue;
            if (stack.size() == 0) {
                return this.getNextTokenByOffset(tokens, i, 1, true, true);
            }
            stack.remove(stack.size() - 1);
        }
        return null;
    }

    private int countNewLinesInExtra(IASToken tokenOrExtra) {
        if (tokenOrExtra == null || tokenOrExtra.getType() != 999999) {
            return 0;
        }
        int numNewLinesInWhitespace = 0;
        String whitespace = tokenOrExtra.getText();
        int index = -1;
        while ((index = whitespace.indexOf(10, index + 1)) != -1) {
            ++numNewLinesInWhitespace;
        }
        return numNewLinesInWhitespace;
    }

    private List<IASToken> insertExtraAS3Tokens(List<IASToken> originalTokens, String fileText) {
        ArrayList<IASToken> tokens = new ArrayList<IASToken>();
        IASToken prevToken = null;
        for (IASToken token : originalTokens) {
            if (prevToken != null) {
                boolean skipSemicolon;
                boolean bl = skipSemicolon = token.getType() == 55 && token.isImplicit() && prevToken != null && (prevToken.getType() == 5 || prevToken.getType() == 22);
                if (skipSemicolon) continue;
                int start = prevToken.getAbsoluteEnd();
                int end = token.getAbsoluteStart();
                if (end > start) {
                    String tokenText = fileText.substring(start, end);
                    ASToken extraToken = new ASToken(999999, start, end, prevToken.getEndLine(), prevToken.getEndColumn(), tokenText);
                    extraToken.setEndLine(token.getLine());
                    extraToken.setEndLine(token.getColumn());
                    tokens.add(extraToken);
                }
            }
            tokens.add(token);
            prevToken = token;
        }
        if (prevToken != null) {
            int start = prevToken.getAbsoluteEnd();
            int end = fileText.length();
            if (end > start) {
                String tokenText = fileText.substring(start, end);
                ASToken extraToken = new ASToken(999999, start, end, prevToken.getEndLine(), prevToken.getEndColumn(), tokenText);
                extraToken.setEndLine(prevToken.getLine());
                extraToken.setEndLine(prevToken.getColumn());
                tokens.add(extraToken);
            }
        }
        return tokens;
    }

    private static class ObjectLiteralBlockStackItem
    extends BlockStackItem {
        public ObjectLiteralBlockStackItem(IASToken token) {
            super(token);
        }
    }

    private static class BlockStackItem {
        public IASToken token;
        public int blockDepth = 0;
        public boolean braces = true;
        public boolean indentedStatement = false;
        public boolean controlFlow = false;
        public int controlFlowEnd = -1;

        public BlockStackItem(IASToken token) {
            this.token = token;
        }
    }

    private static class SwitchBlockStackItem
    extends BlockStackItem {
        public int clauseCount = 0;

        public SwitchBlockStackItem(IASToken token) {
            super(token);
            this.controlFlow = true;
        }
    }
}

