/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs.pass;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import org.apache.royale.compiler.internal.codegen.typedefs.DummyNode;
import org.apache.royale.compiler.internal.codegen.typedefs.pass.AbstractCompilerPass;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ReferenceModel;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.VariableHasNoTypeDeclarationProblem;
import org.apache.royale.compiler.tree.as.IASNode;

public class NamespaceResolutionPass
extends AbstractCompilerPass {
    public NamespaceResolutionPass(ReferenceModel model, AbstractCompiler compiler) {
        super(model, compiler);
    }

    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        return n.isRoot() || n.isNormalBlock() || n.isScript();
    }

    public void visit(NodeTraversal t, Node n, Node parent) {
        for (Node child : n.children()) {
            JSDocInfo comment = null;
            if (child.isVar()) {
                Node name = child.getFirstChild();
                comment = child.getJSDocInfo();
                if (comment != null && comment.isConstant()) {
                    if (name.getFirstChild() == null || !name.getFirstChild().isObjectLit()) continue;
                    this.model.addClass(child, name.getQualifiedName());
                    continue;
                }
                if (comment == null || !comment.hasEnumParameterType()) continue;
                this.model.addEnum(child, name.getQualifiedName());
                continue;
            }
            if (!child.isExprResult()) continue;
            Node first = child.getFirstChild();
            comment = first.getJSDocInfo();
            if (first.isQualifiedName() || !first.isAssign()) continue;
            comment = first.getJSDocInfo();
            Node firstAssignChild = first.getFirstChild();
            Node lastAssignChild = first.getLastChild();
            if (!lastAssignChild.isObjectLit()) continue;
            if (comment == null) {
                StaticSourceFile ssf = first.getStaticSourceFile();
                String source = this.getSourceCode(ssf, first.getLineno());
                DummyNode node = new DummyNode();
                String externName = NamespaceResolutionPass.getSourceFileName(ssf.getName(), this.model);
                node.setSourcePath(externName);
                node.setLine(first.getLineno());
                VariableHasNoTypeDeclarationProblem problem = new VariableHasNoTypeDeclarationProblem((IASNode)node, source);
                this.model.problems.add((ICompilerProblem)problem);
                return;
            }
            if (comment.getType() != null) {
                this.model.addClass(first, firstAssignChild.getQualifiedName());
                continue;
            }
            if (comment.isConstant()) {
                this.model.addClass(first, firstAssignChild.getQualifiedName());
                continue;
            }
            if (comment.hasEnumParameterType()) {
                this.err(first);
                this.model.addEnum(first, firstAssignChild.getQualifiedName());
                continue;
            }
            this.err("Unhandled expression result:");
            this.err(child);
        }
    }
}

