/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.common;

import java.lang.ref.WeakReference;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.workspaces.IWorkspace;

public class NodeReference {
    private WeakReference<IASNode> nodeRef;
    private IFileSpecification fileSpec;
    private int absoluteStart = -1;
    public static NodeReference noReference = new NodeReference();

    public NodeReference(IASNode node) {
        this.absoluteStart = node.getAbsoluteStart();
        this.nodeRef = new WeakReference<IASNode>(node);
        this.fileSpec = node.getFileSpecification();
    }

    public NodeReference(IFileSpecification containingFileSpec, int absoluteStart) {
        this.absoluteStart = absoluteStart;
        this.nodeRef = new WeakReference<Object>(null);
        this.fileSpec = containingFileSpec;
    }

    public IFileSpecification getFileSpecification() {
        return this.fileSpec;
    }

    public int getAbsoluteStart() {
        return this.absoluteStart;
    }

    private static IASNode findNode(IASNode root, int absoluteOffset) {
        IASNode current = root;
        assert (root.getAbsoluteEnd() >= absoluteOffset);
        while (current != null && current.getAbsoluteStart() != absoluteOffset) {
            assert (current.getAbsoluteStart() < absoluteOffset);
            assert (current.getAbsoluteEnd() >= absoluteOffset);
            int childCount = current.getChildCount();
            IASNode next = null;
            for (int i = 0; i < childCount && next == null; ++i) {
                IASNode currChild = current.getChild(i);
                if (currChild == null || currChild.getAbsoluteEnd() < absoluteOffset) continue;
                next = currChild;
            }
            current = next;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IASNode getNode(IWorkspace workspace, ASScope scope) {
        if (this.fileSpec == null || this.absoluteStart == -1) {
            return null;
        }
        IASNode node = (IASNode)this.nodeRef.get();
        if (node != null) {
            return node;
        }
        if (workspace != null) {
            ASFileScope fileScope = null;
            for (ASScope s = scope; s != null; s = s.getContainingScope()) {
                if (!(s instanceof ASFileScope)) continue;
                fileScope = (ASFileScope)s;
            }
            if (fileScope != null) {
                if ((CompilerDiagnosticsConstants.diagnostics & 1) == 1) {
                    System.out.println("NodeReference getting lock for " + this.fileSpec.getPath());
                }
                NodeReference nodeReference = this;
                synchronized (nodeReference) {
                    node = (IASNode)this.nodeRef.get();
                    if (node != null) {
                        return node;
                    }
                    IASNode fileNode = fileScope.getNode();
                    if (fileNode != null) {
                        node = NodeReference.findNode(fileNode, this.absoluteStart);
                        this.nodeRef = new WeakReference<IASNode>(node);
                    }
                }
                if ((CompilerDiagnosticsConstants.diagnostics & 1) == 1) {
                    System.out.println("NodeReference done with lock for " + this.fileSpec.getPath());
                }
            }
        }
        return node;
    }

    public IASNode getNodeIfExists() {
        return this.nodeRef != null ? (IASNode)this.nodeRef.get() : null;
    }

    public void reconnectNode(IASNode node) {
        assert (node.contains(this.absoluteStart));
        this.nodeRef = new WeakReference<IASNode>(node);
    }

    private NodeReference() {
        this.nodeRef = null;
        this.fileSpec = null;
        this.absoluteStart = -1;
    }
}

