/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.concrete.PlayerSessionManager;
import flash.tools.debugger.events.FaultEvent;

public class DVariable
implements Variable,
Comparable {
    private String m_rawName;
    private String m_name;
    private String m_namespace = "";
    private int m_attribs;
    protected Value m_value;
    private boolean m_firedGetter;
    private String m_definingClass;
    private byte m_level;
    private Session m_session;
    long m_nonProtoParentId;
    private int m_isolateId;
    public static final int kNormalObjectType = 0;
    public static final int kXMLSocketObjectType = 1;
    public static final int kTextFieldObjectType = 2;
    public static final int kButtonObjectType = 3;
    public static final int kNumberObjectType = 4;
    public static final int kBooleanObjectType = 5;
    public static final int kNativeStringObject = 6;
    public static final int kNativeArrayObject = 7;
    public static final int kDateObjectType = 8;
    public static final int kSoundObjectType = 9;
    public static final int kNativeXMLDoc = 10;
    public static final int kNativeXMLNode = 11;
    public static final int kNativeCameraObject = 12;
    public static final int kNativeMicrophoneObject = 13;
    public static final int kNativeCommunicationObject = 14;
    public static final int kNetConnectionObjectType = 15;
    public static final int kNetStreamObjectType = 16;
    public static final int kVideoObjectType = 17;
    public static final int kTextFormatObjectType = 18;
    public static final int kSharedObjectType = 19;
    public static final int kSharedObjectDataType = 20;
    public static final int kPrintJobObjectType = 21;
    public static final int kMovieClipLoaderObjectType = 22;
    public static final int kStyleSheetObjectType = 23;
    public static final int kFapPacketDummyObject = 24;
    public static final int kLoadVarsObject = 25;
    public static final int kTextSnapshotType = 26;

    public DVariable(String string, DValue dValue, int n) {
        int n2;
        this.m_rawName = string;
        this.m_attribs = dValue.getAttributes();
        if (string != null && !this.isAttributeSet(0) && (n2 = string.lastIndexOf("::")) >= 0) {
            this.m_namespace = string.substring(0, n2);
            int n3 = this.m_namespace.indexOf(64);
            if (n3 != -1) {
                this.m_namespace = this.m_namespace.substring(0, n3);
            }
            string = string.substring(n2 + 2);
        }
        this.m_name = string;
        this.m_nonProtoParentId = -1L;
        this.m_value = dValue;
        dValue.setSession(this.m_session);
        this.m_isolateId = n;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public int getAttributes() {
        return this.m_attribs;
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    @Override
    public int getScope() {
        return this.m_attribs & 0x3800000;
    }

    @Override
    public int getLevel() {
        return this.m_level;
    }

    @Override
    public String getDefiningClass() {
        return this.m_definingClass;
    }

    @Override
    public int getIsolateId() {
        return this.m_isolateId;
    }

    public void makePublic() {
        int n = this.getAttributes();
        n &= 0xFC7FFFFF;
        this.setAttributes(n |= 0);
        this.m_namespace = "";
    }

    @Override
    public Value getValue() {
        if (this.m_session != null && this.m_session.getPreference("$invokegetters") != 0) {
            try {
                this.invokeGetter(this.m_session);
            }
            catch (NotSuspendedException notSuspendedException) {
            }
            catch (NoResponseException noResponseException) {
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
        return this.m_value;
    }

    @Override
    public boolean hasValueChanged(Session session) {
        Value value;
        boolean bl = false;
        if (session instanceof PlayerSession && (value = ((PlayerSession)session).getPreviousValue(this.m_nonProtoParentId, this.m_isolateId)) != null) {
            try {
                String string;
                Value value2;
                Variable variable = value.getMemberNamed(null, this.getName());
                if (variable instanceof DVariable && !variable.needsToInvokeGetter() && (value2 = ((DVariable)variable).m_value) != null && (string = value2.getValueAsString()) != null && !string.equals(this.getValue().getValueAsString())) {
                    bl = true;
                }
            }
            catch (PlayerDebugException playerDebugException) {
                // empty catch block
            }
        }
        return bl;
    }

    @Override
    public FaultEvent setValue(Session session, int n, String string) throws NotSuspendedException, NoResponseException, NotConnectedException {
        return ((PlayerSession)session).setScalarMember(this.m_nonProtoParentId, this.m_rawName, n, string, this.m_isolateId);
    }

    @Override
    public boolean isAttributeSet(int n) {
        if ((n & 0x3800000) == n) {
            return this.getScope() == n;
        }
        return (this.getAttributes() & n) == n;
    }

    public void clearAttribute(int n) {
        this.m_attribs = (n & 0x3800000) == n ? this.m_attribs & 0xFC7FFFFF | 0 : (this.m_attribs &= ~n);
    }

    public void setAttribute(int n) {
        this.m_attribs = (n & 0x3800000) == n ? this.m_attribs & 0xFC7FFFFF | n : (this.m_attribs |= n);
    }

    public String getRawName() {
        return this.m_rawName;
    }

    @Override
    public String getQualifiedName() {
        if (this.m_namespace.length() > 0) {
            return this.m_namespace + "::" + this.m_name;
        }
        return this.m_name;
    }

    public int compareTo(Object object) {
        Variable variable = (Variable)object;
        String string = this.getName();
        String string2 = variable.getName();
        return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
    }

    @Override
    public boolean needsToInvokeGetter() {
        return this.isAttributeSet(524288) && this.m_value.getId() != -1L && !this.m_firedGetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeGetter(Session session) throws NotSuspendedException, NoResponseException, NotConnectedException {
        PlayerSession playerSession;
        if (this.needsToInvokeGetter() && (playerSession = (PlayerSession)session).getRawValue(this.m_value.getId(), this.m_isolateId) == this.m_value) {
            int n = playerSession.getPreference("$invokegetters");
            playerSession.setPreference("$invokegetters", 1);
            try {
                Value value = playerSession.getValue(this.m_nonProtoParentId, this.getRawName(), this.m_isolateId);
                if (value != null) {
                    this.m_value = value;
                    this.m_firedGetter = true;
                    if (this.m_value instanceof DValue) {
                        ((DValue)this.m_value).setSession(session);
                    }
                }
            }
            finally {
                playerSession.setPreference("$invokegetters", n);
            }
        }
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setAttributes(int n) {
        this.m_attribs = n;
        ((DValue)this.getValue()).setAttributes(n);
    }

    public void setSession(Session session) {
        this.m_session = session;
        if (this.m_value instanceof DValue) {
            ((DValue)this.m_value).setSession(session);
        }
    }

    public void setDefiningClass(int n, String string) {
        this.m_level = (byte)Math.min(n, 255);
        this.m_definingClass = string;
    }

    public String toString() {
        return this.getValue().getValueAsString();
    }

    public static String typeNameFor(int n) {
        String string = "string";
        switch (n) {
            case 0: {
                string = "number";
                break;
            }
            case 1: {
                string = "boolean";
                break;
            }
            case 2: {
                string = "string";
                break;
            }
            case 3: {
                string = "object";
                break;
            }
            case 4: {
                string = "function";
                break;
            }
            case 5: {
                string = "movieclip";
                break;
            }
            case 6: {
                string = "null";
                break;
            }
            default: {
                string = "undefined";
            }
        }
        return string;
    }

    public static String classNameFor(long l, boolean bl) {
        return switch ((int)l) {
            case 0 -> bl ? "MovieClip" : "Object";
            case 1 -> "XMLSocket";
            case 2 -> "TextField";
            case 3 -> "Button";
            case 4 -> "Number";
            case 5 -> "Boolean";
            case 6 -> "String";
            case 7 -> "Array";
            case 8 -> "Date";
            case 9 -> "Sound";
            case 10 -> "XML";
            case 11 -> "XMLNode";
            case 12 -> "Camera";
            case 13 -> "Microphone";
            case 14 -> "Communication";
            case 15 -> "Connection";
            case 16 -> "Stream";
            case 17 -> "Video";
            case 18 -> "TextFormat";
            case 19 -> "SharedObject";
            case 20 -> "SharedObjectData";
            case 21 -> "PrintJob";
            case 22 -> "MovieClipLoader";
            case 23 -> "StyleSheet";
            case 24 -> "FapPacket";
            case 25 -> "LoadVars";
            case 26 -> "TextSnapshot";
            default -> PlayerSessionManager.getLocalizationManager().getLocalizedTextString("unknown") + "<" + l + ">";
        };
    }
}

