/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.semantics;

public class Metadata {
    private static final long PRIME_MULTIPLIER = 5857L;
    private final String name;
    private final String[] keys;
    private final String[] values;
    private Integer cachedHashCode = null;

    public static <T> boolean arrayEquals(T[] array1, T[] array2) {
        boolean result = array1.length == array2.length;
        for (int i = 0; result && i < array1.length; ++i) {
            if (array1[i] == null && array2[i] == null) continue;
            result = array1[i] != null && array2[i] != null ? array1[i].equals(array2[i]) : false;
        }
        return result;
    }

    public Metadata(String name, String[] keys, String[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Null name not allowed.");
        }
        if (keys == null) {
            throw new IllegalArgumentException("Null key array not allowed.");
        }
        if (values == null) {
            throw new IllegalArgumentException("Null value array not allowed.");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Number of keys and values must be same.");
        }
        this.name = name;
        this.keys = keys;
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public String[] getValues() {
        return this.values;
    }

    public int hashCode() {
        if (this.cachedHashCode == null) {
            int result = this.name.hashCode();
            for (String key : this.keys) {
                result = (int)(5857L * (long)result + (long)(key != null ? key.hashCode() : 0));
            }
            for (String value : this.values) {
                result = (int)(5857L * (long)result + (long)(value != null ? value.hashCode() : 0));
            }
            this.cachedHashCode = result;
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata other = (Metadata)o;
        return this.name.equals(other.name) && Metadata.arrayEquals(this.keys, other.keys) && Metadata.arrayEquals(this.values, other.values);
    }
}

