/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions.metadata;

import java.util.Collection;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.internal.definitions.metadata.MetaTag;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.resourcebundles.ResourceBundleUtils;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.units.ICompilationUnit;

public class ResourceBundleMetaTag
extends MetaTag {
    private String bundleName;

    public ResourceBundleMetaTag(IDefinition decoratedDefinition, String tagName, IMetaTagAttribute[] attributes, String bundleName) {
        super(decoratedDefinition, tagName, attributes);
        this.bundleName = bundleName;
    }

    public void resolveDependencies(Collection<ICompilerProblem> errors, ICompilerProject project) throws InterruptedException {
        if (project instanceof RoyaleProject) {
            ICompilationUnit refCompUnit = ((RoyaleProject)project).getScope().getCompilationUnitForScope(this.getDecoratedDefinition().getContainingScope());
            assert (refCompUnit != null);
            ResourceBundleUtils.resolveDependencies(this.bundleName, refCompUnit, project, this, errors);
        }
    }
}

