/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.resourcebundles;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.royale.compiler.common.SourceLocation;
import org.apache.royale.compiler.internal.parsing.as.ASParser;
import org.apache.royale.compiler.internal.tree.as.ClassReferenceNode;
import org.apache.royale.compiler.internal.tree.as.EmbedNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagsNode;
import org.apache.royale.compiler.internal.tree.properties.ResourceBundleEntryNode;
import org.apache.royale.compiler.internal.tree.properties.ResourceBundleFileNode;
import org.apache.royale.compiler.problems.FileNotFoundProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem2;
import org.apache.royale.compiler.problems.ParserProblem;
import org.apache.royale.compiler.problems.ResourceBundleMalformedEncodingProblem;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.workspaces.IWorkspace;

public class PropertiesFileParser {
    public static final Pattern CLASS_REFERENCE_REGEX = Pattern.compile("ClassReference\\((.*)\\)");
    public static final Pattern EMBED_REGEX = Pattern.compile("Embed\\(.*\\)");
    private static final String WHITESPACE = " \t\n\r\f";
    private static String SPLITTERS = "=: \t";
    private static final String TERMINATORS = "\n\r\f";
    private String filePath;
    private ResourceBundleFileNode fileNode;
    private Collection<ICompilerProblem> problems;
    private IWorkspace workspace;

    public PropertiesFileParser(IWorkspace workspace) {
        this.workspace = workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundleFileNode parse(String filePath, String locale, Reader reader, Collection<ICompilerProblem> problems) {
        this.filePath = filePath;
        this.problems = problems;
        try {
            this.fileNode = new ResourceBundleFileNode(this.workspace, filePath, locale);
            this.parse(new BufferedReader(reader));
            ResourceBundleFileNode resourceBundleFileNode = this.fileNode;
            return resourceBundleFileNode;
        }
        catch (FileNotFoundException ex) {
            FileNotFoundProblem problem = new FileNotFoundProblem(filePath);
            problems.add(problem);
        }
        catch (IOException ex) {
            InternalCompilerProblem2 problem = new InternalCompilerProblem2(filePath, ex, "PropertiesFileParser");
            problems.add(problem);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
        return null;
    }

    private void parse(BufferedReader br) throws IOException {
        String line;
        StringBuilder buffer = new StringBuilder(100);
        int lineNumber = 0;
        int comment_length = 0;
        String sep = System.getProperty("line.separator");
        int sep_len = sep.length();
        int offset = 0;
        while ((line = br.readLine()) != null) {
            int len = line.length();
            offset += len;
            int start = 0;
            if (++lineNumber == 1 && len > 0 && line.charAt(0) == '\ufeff') {
                line = line.substring(1);
                offset = len = line.length();
            }
            while (start < len && WHITESPACE.indexOf(line.charAt(start)) != -1) {
                ++start;
            }
            if (line.trim().length() == 0) {
                buffer.append(sep);
                comment_length += sep_len;
                continue;
            }
            if (len == 0 || line.charAt(start) == '!' || line.charAt(start) == '#' || WHITESPACE.indexOf(line.charAt(start)) != -1) {
                buffer.append(line);
                buffer.append(sep);
                comment_length += len + sep_len;
                continue;
            }
            if (comment_length != 0) {
                buffer.setLength(comment_length);
            }
            buffer.setLength(0);
            buffer.append(line.substring(start));
            offset += start;
            while (line != null && line.length() > 1 && line.charAt(line.length() - 1) == '\\') {
                int new_start;
                buffer.setLength(buffer.length() - 1);
                line = br.readLine();
                if (line == null) continue;
                len = line.length();
                for (new_start = 0; new_start < len && WHITESPACE.indexOf(line.charAt(new_start)) != -1; ++new_start) {
                }
                buffer.append(line.substring(new_start));
            }
            String propLine = buffer.toString();
            String com_key = this.loadProperty(propLine, lineNumber, offset, start);
            if (comment_length != 0 && com_key != null) {
                comment_length = 0;
            }
            buffer.setLength(0);
        }
    }

    private String loadProperty(String property, int lineNumber, int startOffset, int column) {
        int prop_index;
        int prop_len = property.length();
        for (prop_index = 0; prop_index < prop_len; ++prop_index) {
            char current = property.charAt(prop_index);
            if (current == '\\') {
                ++prop_index;
                continue;
            }
            if (SPLITTERS.indexOf(current) != -1) break;
        }
        String key = property.substring(0, prop_index);
        key = this.unescape(key, startOffset, column, lineNumber, property);
        key = key.trim();
        while (prop_index < property.length() && WHITESPACE.indexOf(property.charAt(prop_index)) != -1) {
            ++prop_index;
        }
        try {
            if (property.charAt(prop_index) == ':' || property.charAt(prop_index) == '=') {
                ++prop_index;
                while (prop_index < property.length() && WHITESPACE.indexOf(property.charAt(prop_index)) != -1) {
                    ++prop_index;
                }
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            return null;
        }
        int value_start = prop_index;
        while (prop_index < property.length()) {
            char current = property.charAt(prop_index);
            if (current == '\\') {
                ++prop_index;
            } else if (TERMINATORS.indexOf(current) != -1) break;
            ++prop_index;
        }
        String value = property.substring(value_start, prop_index);
        value = this.unescape(value, startOffset + value_start, value_start, lineNumber, property);
        SourceLocation keyLocation = new SourceLocation(this.filePath, startOffset, startOffset + key.length(), lineNumber, column);
        SourceLocation valueLocation = new SourceLocation(this.filePath, startOffset + value_start, startOffset + value_start + value.length(), lineNumber, value_start);
        this.process(key, value, keyLocation, valueLocation, this.problems);
        return key;
    }

    private String unescape(String string, int start, int column, int line, String lineText) {
        if (string == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(string.length());
        int string_index = 0;
        while (string_index < string.length()) {
            char add;
            if ((add = string.charAt(string_index++)) == '\\') {
                if ((add = string.charAt(string_index++)) == 'u') {
                    int unicode = 0;
                    block12: for (int i = 0; i < 4; ++i) {
                        add = string.charAt(string_index++);
                        switch (add) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                unicode = (unicode << 4) + add - 48;
                                continue block12;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                unicode = (unicode << 4) + 10 + add - 97;
                                continue block12;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                unicode = (unicode << 4) + 10 + add - 65;
                                continue block12;
                            }
                            default: {
                                SourceLocation location = new SourceLocation(this.filePath, start, start + string.length(), line, column);
                                ResourceBundleMalformedEncodingProblem problem = new ResourceBundleMalformedEncodingProblem(location, string);
                                this.problems.add(problem);
                            }
                        }
                    }
                    add = (char)unicode;
                } else {
                    switch (add) {
                        case 't': {
                            add = '\t';
                            break;
                        }
                        case 'n': {
                            add = '\n';
                            break;
                        }
                        case 'r': {
                            add = '\r';
                            break;
                        }
                        case 'f': {
                            add = '\f';
                        }
                    }
                }
                buffer.append(add);
                continue;
            }
            buffer.append(add);
        }
        return buffer.toString();
    }

    private void process(String key, String value, SourceLocation keySource, SourceLocation valueSource, Collection<ICompilerProblem> problems) {
        LiteralNode keyNode = new LiteralNode(ILiteralNode.LiteralType.STRING, key, keySource);
        ExpressionNodeBase valueNode = null;
        Matcher matcher = CLASS_REFERENCE_REGEX.matcher(value);
        valueNode = matcher.matches() ? this.processClassReference(matcher, valueSource, problems) : ((matcher = EMBED_REGEX.matcher(value)).matches() ? this.processEmbed(value, valueSource, problems) : new LiteralNode(ILiteralNode.LiteralType.STRING, value, valueSource));
        if (valueNode != null) {
            this.fileNode.addItem(new ResourceBundleEntryNode(keyNode, valueNode));
        }
    }

    private ClassReferenceNode processClassReference(Matcher matcher, SourceLocation sourceLocation, Collection<ICompilerProblem> problems) {
        try {
            String qName = matcher.group(1).trim();
            if (qName.equals("null")) {
                return new ClassReferenceNode(null, sourceLocation);
            }
            if (qName.charAt(0) == '\"' && qName.indexOf(34, 1) == qName.length() - 1) {
                qName = qName.substring(1, qName.length() - 1);
                return new ClassReferenceNode(qName, sourceLocation);
            }
        }
        catch (Exception qName) {
            // empty catch block
        }
        ParserProblem problem = new ParserProblem(sourceLocation);
        problems.add(problem);
        return null;
    }

    private EmbedNode processEmbed(String value, SourceLocation sourceLocation, Collection<ICompilerProblem> problems) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(value);
        sb.append("]");
        MetaTagsNode metaTagsNode = ASParser.parseMetadata(this.workspace, sb.toString(), sourceLocation.getSourcePath(), sourceLocation.getAbsoluteStart(), sourceLocation.getLine(), sourceLocation.getColumn(), problems);
        if (metaTagsNode == null) {
            return null;
        }
        IMetaTagNode embedMetaTagNode = metaTagsNode.getTagByName("Embed");
        if (embedMetaTagNode == null) {
            return null;
        }
        EmbedNode embedNode = new EmbedNode(this.filePath, embedMetaTagNode, this.fileNode);
        embedNode.setSourceLocation(sourceLocation);
        return embedNode;
    }
}

