/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.tools.unknowntreehandler;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.royale.compiler.tools.unknowntreehandler.UnknownTreePatternInputOutput;

@Mojo(name="generate-unknown-tree-handler", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class UnknownTreeHandlerGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}/src/main/unknowntreehandler", property="inputDir", required=true)
    private File inputDir;
    @Parameter(property="inputFile", required=true)
    private String inputFile;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/unknowntreehandler", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(property="outputFile", required=true)
    private String outputFile;
    @Parameter(defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        File input = new File(this.inputDir, this.inputFile);
        if (!input.exists()) {
            throw new MojoExecutionException("Could not read file: " + input.getAbsolutePath());
        }
        File output = new File(this.outputDirectory, this.outputFile);
        if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
            throw new MojoExecutionException("Could not create output directory: " + output.getParentFile().getAbsolutePath());
        }
        String[] args = new String[]{input.getAbsolutePath(), output.getAbsolutePath()};
        try {
            UnknownTreePatternInputOutput.main(args);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Caught error while executing UnknownTreePatternInputOutput.main", e);
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getPath());
    }
}

