/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.registry.api.PropertyExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public abstract class AbstractPropertiesLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPropertiesLoader.class);

    public Map<String, String> loadProperties(Environment environment) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        this.loadPropertiesFromConfigMap(environment, propertiesMap);
        this.loadPropertiesFromExtendedClass(environment, propertiesMap);
        return propertiesMap;
    }

    protected abstract Map<String, String> readProperties(Environment var1);

    protected abstract String readPropertiesExtendedClass(Environment var1);

    private void loadPropertiesFromConfigMap(Environment environment, Map<String, String> propertiesMap) {
        propertiesMap.putAll(this.readProperties(environment));
    }

    private void loadPropertiesFromExtendedClass(Environment environment, Map<String, String> propertiesMap) {
        String extendedPropertyClass = this.readPropertiesExtendedClass(environment);
        if (StringUtils.isEmpty((CharSequence)extendedPropertyClass)) {
            return;
        }
        try {
            Class<?> classExternalProperty = Class.forName(extendedPropertyClass);
            if (!PropertyExtended.class.isAssignableFrom(classExternalProperty)) {
                String errMsg = String.format("Define propertyExtendedClass %s in yaml, but not implement the interface PropertyExtended.", extendedPropertyClass);
                LOGGER.error(errMsg);
                throw new Error(errMsg);
            }
            PropertyExtended instance = (PropertyExtended)classExternalProperty.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map extendedPropertiesMap = instance.getExtendedProperties();
            if (extendedPropertiesMap != null && !extendedPropertiesMap.isEmpty()) {
                propertiesMap.putAll(extendedPropertiesMap);
            }
        }
        catch (ReflectiveOperationException e) {
            String errMsg = "Fail to create instance of class: " + extendedPropertyClass;
            LOGGER.error(errMsg);
            throw new Error(errMsg, e);
        }
    }
}

