/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.scalar;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.ByteSetter;
import org.apache.servicecomb.foundation.common.utils.bean.IntSetter;
import org.apache.servicecomb.foundation.common.utils.bean.ShortSetter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.scalar.AbstractScalarReadSchemas;

public class Int32ReadSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (Integer.TYPE.equals(javaType.getRawClass())) {
            return new IntFieldIntPrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Short.TYPE.equals(javaType.getRawClass())) {
            return new ShortFieldIntPrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Byte.TYPE.equals(javaType.getRawClass())) {
            return new ByteFieldIntPrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Integer.class.equals((Object)javaType.getRawClass()) || Byte.class.equals((Object)javaType.getRawClass()) || Short.class.equals((Object)javaType.getRawClass()) || javaType.isJavaLangObject()) {
            return new Int32Schema(protoField, propertyDescriptor);
        }
        ProtoUtils.throwNotSupportMerge(protoField, propertyDescriptor.getJavaType());
        return null;
    }

    private static class IntFieldIntPrimitiveSchema<T>
    extends FieldSchema<T> {
        protected final IntSetter<T> setter;

        public IntFieldIntPrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (IntSetter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            int value = input.readInt32();
            this.setter.set(message, value);
            return input.readFieldNumber();
        }
    }

    private static class ShortFieldIntPrimitiveSchema<T>
    extends FieldSchema<T> {
        protected final ShortSetter<T> setter;

        public ShortFieldIntPrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (ShortSetter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            int value = input.readInt32();
            this.setter.set(message, (short)value);
            return input.readFieldNumber();
        }
    }

    private static class ByteFieldIntPrimitiveSchema<T>
    extends FieldSchema<T> {
        protected final ByteSetter<T> setter;

        public ByteFieldIntPrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (ByteSetter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            int value = input.readInt32();
            this.setter.set(message, (byte)value);
            return input.readFieldNumber();
        }
    }

    private static class Int32Schema<T>
    extends AbstractScalarReadSchemas.AbstractIntSchema<T> {
        public Int32Schema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            int value = input.readInt32();
            if (Byte.class.equals((Object)this.javaType.getRawClass())) {
                this.setter.set(message, (Object)((byte)value));
            } else if (Short.class.equals((Object)this.javaType.getRawClass())) {
                this.setter.set(message, (Object)((short)value));
            } else {
                this.setter.set(message, (Object)value);
            }
            return input.readFieldNumber();
        }
    }
}

