/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.diffvalidation.skeleton.paths;

import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffValidationContext;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffViolation;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasObjectDiffValidatorTemplate;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.PathItemDiffValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.PathsDiffValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.util.OasObjectDiffValidatorUtils;

public class PathsPathItemsDiffValidator
extends OasObjectDiffValidatorTemplate<Paths>
implements PathsDiffValidator {
    private final List<PathItemDiffValidator> pathItemValidators;

    public PathsPathItemsDiffValidator(List<PathItemDiffValidator> pathItemValidators) {
        this.pathItemValidators = pathItemValidators;
    }

    @Override
    public List<OasDiffViolation> validateCompare(OasDiffValidationContext context, OasObjectPropertyLocation leftLocation, Paths leftOasObject, OasObjectPropertyLocation rightLocation, Paths rightOasObject) {
        ArrayList<OasDiffViolation> violations = new ArrayList<OasDiffViolation>();
        for (Map.Entry entry : leftOasObject.entrySet()) {
            String lPath = (String)entry.getKey();
            PathItem lPathItem = (PathItem)entry.getValue();
            OasObjectPropertyLocation lPathItemLoc = leftLocation.property(lPath, OasObjectType.PATH_ITEM);
            PathItem rPathItem = (PathItem)rightOasObject.get((Object)lPath);
            if (rPathItem == null) {
                violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, lPathItemLoc, lPathItem, null, null, this.pathItemValidators));
                continue;
            }
            OasObjectPropertyLocation rPathItemLoc = rightLocation.property(lPath, OasObjectType.PATH_ITEM);
            violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, lPathItemLoc, lPathItem, rPathItemLoc, rPathItem, this.pathItemValidators));
        }
        for (Map.Entry entry : rightOasObject.entrySet()) {
            String rPath = (String)entry.getKey();
            if (leftOasObject.containsKey((Object)rPath)) continue;
            PathItem rPathItem = (PathItem)entry.getValue();
            OasObjectPropertyLocation rPathItemLoc = leftLocation.property(rPath, OasObjectType.PATH_ITEM);
            violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, null, null, rPathItemLoc, rPathItem, this.pathItemValidators));
        }
        return violations;
    }
}

