/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.engine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapper;
import org.apache.servicecomb.swagger.invocation.context.ContextUtils;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.swagger.invocation.extension.ProducerInvokeExtension;
import org.apache.servicecomb.swagger.invocation.response.producer.ProducerResponseMapper;

public class SwaggerProducerOperation {
    private String name;
    private Class<?> producerClass;
    private Object producerInstance;
    private Method producerMethod;
    private Method swaggerMethod;
    private ProducerArgumentsMapper argumentsMapper;
    private ProducerResponseMapper responseMapper;
    private List<ProducerInvokeExtension> producerInvokeExtenstionList = SPIServiceUtils.getSortedService(ProducerInvokeExtension.class);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getProducerClass() {
        return this.producerClass;
    }

    public void setProducerClass(Class<?> producerClass) {
        this.producerClass = producerClass;
    }

    public Object getProducerInstance() {
        return this.producerInstance;
    }

    public void setProducerInstance(Object producerInstance) {
        this.producerInstance = producerInstance;
    }

    public Method getProducerMethod() {
        return this.producerMethod;
    }

    public void setProducerMethod(Method producerMethod) {
        this.producerMethod = producerMethod;
    }

    public Method getSwaggerMethod() {
        return this.swaggerMethod;
    }

    public void setSwaggerMethod(Method swaggerMethod) {
        this.swaggerMethod = swaggerMethod;
    }

    public ProducerArgumentsMapper getArgumentsMapper() {
        return this.argumentsMapper;
    }

    public void setArgumentsMapper(ProducerArgumentsMapper argumentsMapper) {
        this.argumentsMapper = argumentsMapper;
    }

    public ProducerResponseMapper getResponseMapper() {
        return this.responseMapper;
    }

    public void setResponseMapper(ProducerResponseMapper responseMapper) {
        this.responseMapper = responseMapper;
    }

    public void invoke(SwaggerInvocation invocation, AsyncResponse asyncResp) {
        if (CompletableFuture.class.equals(this.producerMethod.getReturnType())) {
            this.completableFutureInvoke(invocation, asyncResp);
            return;
        }
        this.syncInvoke(invocation, asyncResp);
    }

    public void completableFutureInvoke(SwaggerInvocation invocation, AsyncResponse asyncResp) {
        ContextUtils.setInvocationContext(invocation);
        this.doCompletableFutureInvoke(invocation, asyncResp);
        ContextUtils.removeInvocationContext();
    }

    public void doCompletableFutureInvoke(SwaggerInvocation invocation, AsyncResponse asyncResp) {
        try {
            invocation.onBusinessMethodStart();
            Object[] args = this.argumentsMapper.toProducerArgs(invocation);
            for (ProducerInvokeExtension producerInvokeExtension : this.producerInvokeExtenstionList) {
                producerInvokeExtension.beforeMethodInvoke(invocation, this, args);
            }
            Object result = this.producerMethod.invoke(this.producerInstance, args);
            invocation.onBusinessMethodFinish();
            ((CompletableFuture)result).whenComplete((realResult, ex) -> {
                invocation.onBusinessFinish();
                if (ex == null) {
                    asyncResp.handle(this.responseMapper.mapResponse(invocation.getStatus(), realResult));
                    return;
                }
                asyncResp.handle(this.processException(invocation, (Throwable)ex));
            });
        }
        catch (IllegalArgumentException ae) {
            invocation.onBusinessMethodFinish();
            invocation.onBusinessFinish();
            asyncResp.handle(this.processException(invocation, new InvocationException(Response.Status.BAD_REQUEST.getStatusCode(), "", new CommonExceptionData("Parameters not valid or types not match."), ae)));
        }
        catch (Throwable e) {
            invocation.onBusinessMethodFinish();
            invocation.onBusinessFinish();
            asyncResp.handle(this.processException(invocation, e));
        }
    }

    public void syncInvoke(SwaggerInvocation invocation, AsyncResponse asyncResp) {
        ContextUtils.setInvocationContext(invocation);
        Response response = this.doInvoke(invocation);
        ContextUtils.removeInvocationContext();
        asyncResp.handle(response);
    }

    public Response doInvoke(SwaggerInvocation invocation) {
        Response response = null;
        try {
            invocation.onBusinessMethodStart();
            Object[] args = this.argumentsMapper.toProducerArgs(invocation);
            for (ProducerInvokeExtension producerInvokeExtension : this.producerInvokeExtenstionList) {
                producerInvokeExtension.beforeMethodInvoke(invocation, this, args);
            }
            Object result = this.producerMethod.invoke(this.producerInstance, args);
            response = this.responseMapper.mapResponse(invocation.getStatus(), result);
            invocation.onBusinessMethodFinish();
            invocation.onBusinessFinish();
        }
        catch (IllegalArgumentException ae) {
            invocation.onBusinessMethodFinish();
            invocation.onBusinessFinish();
            response = this.processException(invocation, new InvocationException(Response.Status.BAD_REQUEST.getStatusCode(), "", new CommonExceptionData("Parameters not valid or types not match."), ae));
        }
        catch (Throwable e) {
            invocation.onBusinessMethodFinish();
            invocation.onBusinessFinish();
            response = this.processException(invocation, e);
        }
        return response;
    }

    protected Response processException(SwaggerInvocation invocation, Throwable e) {
        if (InvocationTargetException.class.isInstance(e)) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        return ExceptionFactory.convertExceptionToResponse(invocation, e);
    }
}

