/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.validator.tag;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.api.TagValidator;

public class TagMustBeReferencedValidator
implements TagValidator {
    public static final String CONFIG_KEY = "tag.name.must_be_referenced";
    public static final String ERROR = "Must be referenced by at least one Operation object";
    private static final String CACHE_KEY = TagMustBeReferencedValidator.class.getName() + ".allOperationsTags";

    public List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, Tag tag) {
        Set<String> allOperationsTags = this.getAllOperationsTags(context);
        ArrayList<OasViolation> violations = new ArrayList<OasViolation>();
        if (!allOperationsTags.contains(tag.getName())) {
            violations.add(new OasViolation(location, ERROR));
        }
        return violations;
    }

    private Set<String> getAllOperationsTags(OasValidationContext context) {
        HashSet<String> allTags = (HashSet<String>)context.getAttribute(CACHE_KEY);
        if (allTags != null) {
            return allTags;
        }
        allTags = new HashSet<String>();
        OpenAPI openAPI = context.getOpenAPI();
        Paths paths = openAPI.getPaths();
        if (paths == null) {
            return Collections.emptySet();
        }
        for (Map.Entry entry : paths.entrySet()) {
            PathItem pathItem = (PathItem)entry.getValue();
            List operations = pathItem.readOperations();
            for (Operation operation : operations) {
                List tags = operation.getTags();
                if (CollectionUtils.isEmpty((Collection)tags)) continue;
                allTags.addAll(tags);
            }
        }
        context.setAttribute(CACHE_KEY, allTags);
        return allTags;
    }
}

