--
-- Licensed to the Apache Software Foundation (ASF) under one or more
-- contributor license agreements.  See the NOTICE file distributed with
-- this work for additional information regarding copyright ownership.
-- The ASF licenses this file to You under the Apache License, Version 2.0
-- (the "License"); you may not use this file except in compliance with
-- the License.  You may obtain a copy of the License at
--
--     http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--

SET character_set_database='utf8';
SET character_set_server='utf8';

DROP DATABASE IF EXISTS sql_federation_ds_0;
DROP DATABASE IF EXISTS sql_federation_ds_1;
DROP DATABASE IF EXISTS sql_federation_ds_2;
DROP DATABASE IF EXISTS sql_federation_ds_3;
DROP DATABASE IF EXISTS sql_federation_ds_4;
DROP DATABASE IF EXISTS sql_federation_ds_5;
DROP DATABASE IF EXISTS sql_federation_ds_6;
DROP DATABASE IF EXISTS sql_federation_ds_7;
DROP DATABASE IF EXISTS sql_federation_ds_8;
DROP DATABASE IF EXISTS sql_federation_ds_9;

CREATE DATABASE sql_federation_ds_0;
CREATE DATABASE sql_federation_ds_1;
CREATE DATABASE sql_federation_ds_2;
CREATE DATABASE sql_federation_ds_3;
CREATE DATABASE sql_federation_ds_4;
CREATE DATABASE sql_federation_ds_5;
CREATE DATABASE sql_federation_ds_6;
CREATE DATABASE sql_federation_ds_7;
CREATE DATABASE sql_federation_ds_8;
CREATE DATABASE sql_federation_ds_9;

CREATE TABLE sql_federation_ds_0.t_order_0 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_item_0 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_1 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_item_1 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_2 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_item_2 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_3 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_item_3 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_4 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_item_4 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_5 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_item_5 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_6 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_item_6 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_7 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_item_7 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_8 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_item_8 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_9 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_order_item_9 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_user (user_id INT PRIMARY KEY, user_name VARCHAR(50) NOT NULL, password VARCHAR(50) NOT NULL, email VARCHAR(50) NOT NULL, telephone VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_product (product_id INT PRIMARY KEY, product_name VARCHAR(50) NOT NULL, category_id INT NOT NULL, price DECIMAL NOT NULL, status VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_product_extend(extend_id INT PRIMARY KEY, product_id INT NOT NULL, type_int INT NOT NULL, type_smallint SMALLINT NOT NULL, type_decimal DECIMAL NOT NULL, type_float FLOAT NOT NULL, type_double DOUBLE NOT NULL, type_bit BIT(64) NOT NULL, type_tinyint TINYINT NOT NULL, type_mediumint mediumint NOT NULL, type_bigint BIGINT NOT NULL, type_date DATE NOT NULL, type_time TIME NOT NULL, type_datetime DATETIME NOT NULL, type_timestamp TIMESTAMP NOT NULL, type_year YEAR NOT NULL, type_char CHAR NOT NULL, type_text TEXT NOT NULL, type_varchar VARCHAR(50) NOT NULL, type_longtext LONGTEXT NOT NULL, type_longblob LONGBLOB NOT NULL, type_mediumtext mediumtext NOT NULL, type_mediumblob mediumblob NOT NULL, type_binary BINARY(255) NOT NULL, type_varbinary VARBINARY(1024) NOT NULL, type_blob BLOB NOT NULL, type_enum ENUM('spring', 'summer', 'autumn', 'winter') NOT NULL, type_set SET('spring', 'summer', 'autumn', 'winter') NOT NULL, type_json JSON NOT NULL, type_unsigned_int INT UNSIGNED NOT NULL, type_unsigned_bigint BIGINT UNSIGNED NOT NULL, type_unsigned_tinyint TINYINT UNSIGNED NOT NULL, type_unsigned_smallint SMALLINT UNSIGNED NOT NULL, type_unsigned_float FLOAT UNSIGNED NOT NULL, type_unsigned_double DOUBLE UNSIGNED NOT NULL, type_unsigned_decimal DECIMAL UNSIGNED NOT NULL);
CREATE TABLE sql_federation_ds_0.t_product_category(category_id INT PRIMARY KEY, category_name VARCHAR(50) NOT NULL, parent_id INT NOT NULL, level INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_0.t_country (country_id INT PRIMARY KEY, country_name VARCHAR(50), continent_name VARCHAR(50), creation_date DATE NOT NULL);
CREATE INDEX order_index_t_order_0 ON sql_federation_ds_0.t_order_0 (order_id);
CREATE INDEX order_index_t_order_1 ON sql_federation_ds_0.t_order_1 (order_id);
CREATE INDEX order_index_t_order_2 ON sql_federation_ds_0.t_order_2 (order_id);
CREATE INDEX order_index_t_order_3 ON sql_federation_ds_0.t_order_3 (order_id);
CREATE INDEX order_index_t_order_4 ON sql_federation_ds_0.t_order_4 (order_id);
CREATE INDEX order_index_t_order_5 ON sql_federation_ds_0.t_order_5 (order_id);
CREATE INDEX order_index_t_order_6 ON sql_federation_ds_0.t_order_6 (order_id);
CREATE INDEX order_index_t_order_7 ON sql_federation_ds_0.t_order_7 (order_id);
CREATE INDEX order_index_t_order_8 ON sql_federation_ds_0.t_order_8 (order_id);
CREATE INDEX order_index_t_order_9 ON sql_federation_ds_0.t_order_9 (order_id);

CREATE TABLE sql_federation_ds_1.t_order_0 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_item_0 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_1 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_item_1 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_2 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_item_2 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_3 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_item_3 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_4 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_item_4 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_5 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_item_5 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_6 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_item_6 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_7 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_item_7 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_8 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_item_8 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_9 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_order_item_9 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_merchant (merchant_id INT PRIMARY KEY, country_id INT NOT NULL, merchant_name VARCHAR(50) NOT NULL, business_code VARCHAR(50) NOT NULL, telephone VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_product_detail (detail_id INT PRIMARY KEY, product_id INT NOT NULL, description VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_product_category( category_id INT PRIMARY KEY, category_name VARCHAR(50) NOT NULL, parent_id INT NOT NULL, level INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_1.t_country (country_id INT PRIMARY KEY, country_name VARCHAR(50), continent_name VARCHAR(50), creation_date DATE NOT NULL);
CREATE INDEX order_index_t_order_0 ON sql_federation_ds_1.t_order_0 (order_id);
CREATE INDEX order_index_t_order_1 ON sql_federation_ds_1.t_order_1 (order_id);
CREATE INDEX order_index_t_order_2 ON sql_federation_ds_1.t_order_2 (order_id);
CREATE INDEX order_index_t_order_3 ON sql_federation_ds_1.t_order_3 (order_id);
CREATE INDEX order_index_t_order_4 ON sql_federation_ds_1.t_order_4 (order_id);
CREATE INDEX order_index_t_order_5 ON sql_federation_ds_1.t_order_5 (order_id);
CREATE INDEX order_index_t_order_6 ON sql_federation_ds_1.t_order_6 (order_id);
CREATE INDEX order_index_t_order_7 ON sql_federation_ds_1.t_order_7 (order_id);
CREATE INDEX order_index_t_order_8 ON sql_federation_ds_1.t_order_8 (order_id);
CREATE INDEX order_index_t_order_9 ON sql_federation_ds_1.t_order_9 (order_id);

CREATE TABLE sql_federation_ds_2.t_order_0 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_item_0 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_1 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_item_1 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_2 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_item_2 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_3 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_item_3 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_4 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_item_4 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_5 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_item_5 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_6 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_item_6 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_7 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_item_7 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_8 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_item_8 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_9 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_order_item_9 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_product_category( category_id INT PRIMARY KEY, category_name VARCHAR(50) NOT NULL, parent_id INT NOT NULL, level INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_2.t_country (country_id INT PRIMARY KEY, country_name VARCHAR(50), continent_name VARCHAR(50), creation_date DATE NOT NULL);
CREATE INDEX order_index_t_order_0 ON sql_federation_ds_2.t_order_0 (order_id);
CREATE INDEX order_index_t_order_1 ON sql_federation_ds_2.t_order_1 (order_id);
CREATE INDEX order_index_t_order_2 ON sql_federation_ds_2.t_order_2 (order_id);
CREATE INDEX order_index_t_order_3 ON sql_federation_ds_2.t_order_3 (order_id);
CREATE INDEX order_index_t_order_4 ON sql_federation_ds_2.t_order_4 (order_id);
CREATE INDEX order_index_t_order_5 ON sql_federation_ds_2.t_order_5 (order_id);
CREATE INDEX order_index_t_order_6 ON sql_federation_ds_2.t_order_6 (order_id);
CREATE INDEX order_index_t_order_7 ON sql_federation_ds_2.t_order_7 (order_id);
CREATE INDEX order_index_t_order_8 ON sql_federation_ds_2.t_order_8 (order_id);
CREATE INDEX order_index_t_order_9 ON sql_federation_ds_2.t_order_9 (order_id);

CREATE TABLE sql_federation_ds_3.t_order_0 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_item_0 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_1 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_item_1 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_2 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_item_2 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_3 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_item_3 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_4 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_item_4 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_5 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_item_5 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_6 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_item_6 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_7 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_item_7 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_8 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_item_8 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_9 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_order_item_9 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_product_category( category_id INT PRIMARY KEY, category_name VARCHAR(50) NOT NULL, parent_id INT NOT NULL, level INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_3.t_country (country_id INT PRIMARY KEY, country_name VARCHAR(50), continent_name VARCHAR(50), creation_date DATE NOT NULL);
CREATE INDEX order_index_t_order_0 ON sql_federation_ds_3.t_order_0 (order_id);
CREATE INDEX order_index_t_order_1 ON sql_federation_ds_3.t_order_1 (order_id);
CREATE INDEX order_index_t_order_2 ON sql_federation_ds_3.t_order_2 (order_id);
CREATE INDEX order_index_t_order_3 ON sql_federation_ds_3.t_order_3 (order_id);
CREATE INDEX order_index_t_order_4 ON sql_federation_ds_3.t_order_4 (order_id);
CREATE INDEX order_index_t_order_5 ON sql_federation_ds_3.t_order_5 (order_id);
CREATE INDEX order_index_t_order_6 ON sql_federation_ds_3.t_order_6 (order_id);
CREATE INDEX order_index_t_order_7 ON sql_federation_ds_3.t_order_7 (order_id);
CREATE INDEX order_index_t_order_8 ON sql_federation_ds_3.t_order_8 (order_id);
CREATE INDEX order_index_t_order_9 ON sql_federation_ds_3.t_order_9 (order_id);

CREATE TABLE sql_federation_ds_4.t_order_0 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_item_0 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_1 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_item_1 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_2 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_item_2 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_3 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_item_3 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_4 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_item_4 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_5 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_item_5 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_6 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_item_6 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_7 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_item_7 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_8 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_item_8 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_9 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_order_item_9 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_product_category( category_id INT PRIMARY KEY, category_name VARCHAR(50) NOT NULL, parent_id INT NOT NULL, level INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_4.t_country (country_id INT PRIMARY KEY, country_name VARCHAR(50), continent_name VARCHAR(50), creation_date DATE NOT NULL);
CREATE INDEX order_index_t_order_0 ON sql_federation_ds_4.t_order_0 (order_id);
CREATE INDEX order_index_t_order_1 ON sql_federation_ds_4.t_order_1 (order_id);
CREATE INDEX order_index_t_order_2 ON sql_federation_ds_4.t_order_2 (order_id);
CREATE INDEX order_index_t_order_3 ON sql_federation_ds_4.t_order_3 (order_id);
CREATE INDEX order_index_t_order_4 ON sql_federation_ds_4.t_order_4 (order_id);
CREATE INDEX order_index_t_order_5 ON sql_federation_ds_4.t_order_5 (order_id);
CREATE INDEX order_index_t_order_6 ON sql_federation_ds_4.t_order_6 (order_id);
CREATE INDEX order_index_t_order_7 ON sql_federation_ds_4.t_order_7 (order_id);
CREATE INDEX order_index_t_order_8 ON sql_federation_ds_4.t_order_8 (order_id);
CREATE INDEX order_index_t_order_9 ON sql_federation_ds_4.t_order_9 (order_id);

CREATE TABLE sql_federation_ds_5.t_order_0 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_item_0 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_1 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_item_1 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_2 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_item_2 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_3 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_item_3 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_4 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_item_4 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_5 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_item_5 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_6 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_item_6 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_7 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_item_7 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_8 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_item_8 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_9 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_order_item_9 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_product_category( category_id INT PRIMARY KEY, category_name VARCHAR(50) NOT NULL, parent_id INT NOT NULL, level INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_5.t_country (country_id INT PRIMARY KEY, country_name VARCHAR(50), continent_name VARCHAR(50), creation_date DATE NOT NULL);
CREATE INDEX order_index_t_order_0 ON sql_federation_ds_5.t_order_0 (order_id);
CREATE INDEX order_index_t_order_1 ON sql_federation_ds_5.t_order_1 (order_id);
CREATE INDEX order_index_t_order_2 ON sql_federation_ds_5.t_order_2 (order_id);
CREATE INDEX order_index_t_order_3 ON sql_federation_ds_5.t_order_3 (order_id);
CREATE INDEX order_index_t_order_4 ON sql_federation_ds_5.t_order_4 (order_id);
CREATE INDEX order_index_t_order_5 ON sql_federation_ds_5.t_order_5 (order_id);
CREATE INDEX order_index_t_order_6 ON sql_federation_ds_5.t_order_6 (order_id);
CREATE INDEX order_index_t_order_7 ON sql_federation_ds_5.t_order_7 (order_id);
CREATE INDEX order_index_t_order_8 ON sql_federation_ds_5.t_order_8 (order_id);
CREATE INDEX order_index_t_order_9 ON sql_federation_ds_5.t_order_9 (order_id);

CREATE TABLE sql_federation_ds_6.t_order_0 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_item_0 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_1 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_item_1 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_2 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_item_2 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_3 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_item_3 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_4 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_item_4 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_5 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_item_5 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_6 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_item_6 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_7 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_item_7 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_8 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_item_8 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_9 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_order_item_9 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_product_category( category_id INT PRIMARY KEY, category_name VARCHAR(50) NOT NULL, parent_id INT NOT NULL, level INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_6.t_country (country_id INT PRIMARY KEY, country_name VARCHAR(50), continent_name VARCHAR(50), creation_date DATE NOT NULL);
CREATE INDEX order_index_t_order_0 ON sql_federation_ds_6.t_order_0 (order_id);
CREATE INDEX order_index_t_order_1 ON sql_federation_ds_6.t_order_1 (order_id);
CREATE INDEX order_index_t_order_2 ON sql_federation_ds_6.t_order_2 (order_id);
CREATE INDEX order_index_t_order_3 ON sql_federation_ds_6.t_order_3 (order_id);
CREATE INDEX order_index_t_order_4 ON sql_federation_ds_6.t_order_4 (order_id);
CREATE INDEX order_index_t_order_5 ON sql_federation_ds_6.t_order_5 (order_id);
CREATE INDEX order_index_t_order_6 ON sql_federation_ds_6.t_order_6 (order_id);
CREATE INDEX order_index_t_order_7 ON sql_federation_ds_6.t_order_7 (order_id);
CREATE INDEX order_index_t_order_8 ON sql_federation_ds_6.t_order_8 (order_id);
CREATE INDEX order_index_t_order_9 ON sql_federation_ds_6.t_order_9 (order_id);

CREATE TABLE sql_federation_ds_7.t_order_0 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_item_0 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_1 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_item_1 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_2 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_item_2 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_3 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_item_3 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_4 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_item_4 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_5 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_item_5 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_6 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_item_6 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_7 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_item_7 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_8 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_item_8 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_9 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_order_item_9 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_product_category( category_id INT PRIMARY KEY, category_name VARCHAR(50) NOT NULL, parent_id INT NOT NULL, level INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_7.t_country (country_id INT PRIMARY KEY, country_name VARCHAR(50), continent_name VARCHAR(50), creation_date DATE NOT NULL);
CREATE INDEX order_index_t_order_0 ON sql_federation_ds_7.t_order_0 (order_id);
CREATE INDEX order_index_t_order_1 ON sql_federation_ds_7.t_order_1 (order_id);
CREATE INDEX order_index_t_order_2 ON sql_federation_ds_7.t_order_2 (order_id);
CREATE INDEX order_index_t_order_3 ON sql_federation_ds_7.t_order_3 (order_id);
CREATE INDEX order_index_t_order_4 ON sql_federation_ds_7.t_order_4 (order_id);
CREATE INDEX order_index_t_order_5 ON sql_federation_ds_7.t_order_5 (order_id);
CREATE INDEX order_index_t_order_6 ON sql_federation_ds_7.t_order_6 (order_id);
CREATE INDEX order_index_t_order_7 ON sql_federation_ds_7.t_order_7 (order_id);
CREATE INDEX order_index_t_order_8 ON sql_federation_ds_7.t_order_8 (order_id);
CREATE INDEX order_index_t_order_9 ON sql_federation_ds_7.t_order_9 (order_id);

CREATE TABLE sql_federation_ds_8.t_order_0 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_item_0 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_1 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_item_1 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_2 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_item_2 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_3 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_item_3 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_4 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_item_4 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_5 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_item_5 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_6 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_item_6 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_7 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_item_7 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_8 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_item_8 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_9 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_order_item_9 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_product_category( category_id INT PRIMARY KEY, category_name VARCHAR(50) NOT NULL, parent_id INT NOT NULL, level INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_8.t_country (country_id INT PRIMARY KEY, country_name VARCHAR(50), continent_name VARCHAR(50), creation_date DATE NOT NULL);
CREATE INDEX order_index_t_order_0 ON sql_federation_ds_8.t_order_0 (order_id);
CREATE INDEX order_index_t_order_1 ON sql_federation_ds_8.t_order_1 (order_id);
CREATE INDEX order_index_t_order_2 ON sql_federation_ds_8.t_order_2 (order_id);
CREATE INDEX order_index_t_order_3 ON sql_federation_ds_8.t_order_3 (order_id);
CREATE INDEX order_index_t_order_4 ON sql_federation_ds_8.t_order_4 (order_id);
CREATE INDEX order_index_t_order_5 ON sql_federation_ds_8.t_order_5 (order_id);
CREATE INDEX order_index_t_order_6 ON sql_federation_ds_8.t_order_6 (order_id);
CREATE INDEX order_index_t_order_7 ON sql_federation_ds_8.t_order_7 (order_id);
CREATE INDEX order_index_t_order_8 ON sql_federation_ds_8.t_order_8 (order_id);
CREATE INDEX order_index_t_order_9 ON sql_federation_ds_8.t_order_9 (order_id);

CREATE TABLE sql_federation_ds_9.t_order_0 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_item_0 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_1 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_item_1 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_2 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_item_2 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_3 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_item_3 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_4 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_item_4 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_5 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_item_5 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_6 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_item_6 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_7 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_item_7 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_8 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_item_8 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_9 (order_id INT PRIMARY KEY, user_id INT NOT NULL, status VARCHAR(50) NOT NULL, merchant_id INT NOT NULL, remark VARCHAR(50) NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_order_item_9 (item_id INT PRIMARY KEY, order_id INT NOT NULL, user_id INT NOT NULL, product_id INT NOT NULL, quantity INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_product_category( category_id INT PRIMARY KEY, category_name VARCHAR(50) NOT NULL, parent_id INT NOT NULL, level INT NOT NULL, creation_date DATE NOT NULL);
CREATE TABLE sql_federation_ds_9.t_country (country_id INT PRIMARY KEY, country_name VARCHAR(50), continent_name VARCHAR(50), creation_date DATE NOT NULL);
CREATE INDEX order_index_t_order_0 ON sql_federation_ds_9.t_order_0 (order_id);
CREATE INDEX order_index_t_order_1 ON sql_federation_ds_9.t_order_1 (order_id);
CREATE INDEX order_index_t_order_2 ON sql_federation_ds_9.t_order_2 (order_id);
CREATE INDEX order_index_t_order_3 ON sql_federation_ds_9.t_order_3 (order_id);
CREATE INDEX order_index_t_order_4 ON sql_federation_ds_9.t_order_4 (order_id);
CREATE INDEX order_index_t_order_5 ON sql_federation_ds_9.t_order_5 (order_id);
CREATE INDEX order_index_t_order_6 ON sql_federation_ds_9.t_order_6 (order_id);
CREATE INDEX order_index_t_order_7 ON sql_federation_ds_9.t_order_7 (order_id);
CREATE INDEX order_index_t_order_8 ON sql_federation_ds_9.t_order_8 (order_id);
CREATE INDEX order_index_t_order_9 ON sql_federation_ds_9.t_order_9 (order_id);
