/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal.shared;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.function.Predicate;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.internal.shared.Strings;
import org.opengis.util.CodeList;

public final class CodeLists
implements CodeList.Filter {
    public static final String RESOURCES = "org.apache.sis.metadata.iso.CodeLists";
    private final String codename;
    private final boolean canCreate;

    private CodeLists(String codename, boolean canCreate) {
        this.codename = codename;
        this.canCreate = canCreate;
    }

    public String codename() {
        return this.canCreate ? this.codename : null;
    }

    public boolean accept(CodeList<?> code) {
        for (String candidate : code.names()) {
            if (!CodeLists.accept(candidate, this.codename)) continue;
            return true;
        }
        return false;
    }

    private static boolean accept(String candidate, String codename) {
        return CharSequences.equalsFiltered(candidate, codename, Characters.Filter.LETTERS_AND_DIGITS, true);
    }

    public static <T extends Enum<T>> T forEnumName(Class<T> enumType, String name) {
        if ((name = Strings.trimOrNull(name)) != null) {
            try {
                return Enum.valueOf(enumType, name);
            }
            catch (IllegalArgumentException e) {
                Enum[] values = (Enum[])enumType.getEnumConstants();
                if (values != null) {
                    for (Enum code : values) {
                        if (!CodeLists.accept(code.name(), name)) continue;
                        return (T)((Enum)enumType.cast(code));
                    }
                }
                throw e;
            }
        }
        return null;
    }

    public static <E extends CodeList<E>> E forCodeName(Class<E> codeType, String name) {
        return (E)((name = Strings.trimOrNull(name)) != null ? CodeList.valueOf(codeType, (CodeList.Filter)new CodeLists(name, false)) : null);
    }

    public static <E extends CodeList<E>> E find(Class<E> codeType, final Predicate<? super CodeList<?>> filter) {
        return (E)CodeList.valueOf(codeType, (CodeList.Filter)new CodeList.Filter(){

            public boolean accept(CodeList<?> code) {
                return filter.test(code);
            }

            public String codename() {
                return null;
            }
        });
    }

    public static <E extends CodeList<E>> E getOrCreate(Class<E> codeType, String name) {
        if ((name = Strings.trimOrNull(name)) == null) {
            return null;
        }
        return (E)CodeList.valueOf(codeType, (CodeList.Filter)new CodeLists(name, true));
    }

    public static <T extends CodeList<?>> T[] values(Class<T> codeType) {
        Object values;
        try {
            values = codeType.getMethod("values", null).invoke(null, (Object[])null);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            values = Array.newInstance(codeType, 0);
        }
        return (CodeList[])values;
    }
}

