/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.PropertyValue;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.pending.geoapi.filter.Name;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.opengis.util.ScopedName;

final class AssociationValue<V>
extends LeafExpression<AbstractFeature, V>
implements ValueReference<AbstractFeature, V>,
Optimization.OnExpression<AbstractFeature, V> {
    private static final long serialVersionUID = 2082322712413854288L;
    private final String[] path;
    private final PropertyValue<V> accessor;

    AssociationValue(List<String> path, PropertyValue<V> accessor) {
        this.path = (String[])path.toArray(String[]::new);
        this.accessor = accessor;
    }

    private AssociationValue(String[] path, PropertyValue<V> accessor) {
        this.path = path;
        this.accessor = accessor;
    }

    @Override
    public final ScopedName getFunctionName() {
        return Name.VALUE_REFERENCE;
    }

    @Override
    public final Class<AbstractFeature> getResourceClass() {
        return AbstractFeature.class;
    }

    @Override
    public Set<FunctionProperty> properties() {
        return AssociationValue.transitiveProperties(this.accessor.getParameters());
    }

    @Override
    protected final Collection<?> getChildren() {
        return Set.of(this.getXPath());
    }

    @Override
    public final String getXPath() {
        return this.accessor.getXPath(this.path);
    }

    @Override
    public V apply(AbstractFeature instance) {
        block3: {
            if (instance != null) {
                for (String p : this.path) {
                    Object value = instance.getPropertyValue(p);
                    if (value instanceof AbstractFeature) {
                        instance = (AbstractFeature)value;
                        continue;
                    }
                    break block3;
                }
                return this.accessor.apply(instance);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression<AbstractFeature, V> optimize(Optimization optimization) {
        block11: {
            DefaultFeatureType specifiedType = optimization.getFeatureType();
            if (specifiedType != null) {
                try {
                    Expression converted;
                    DefaultFeatureType type = specifiedType;
                    String[] direct = this.path;
                    for (int i = 0; i < this.path.length; ++i) {
                        AbstractIdentifiedType property = type.getProperty(this.path[i]);
                        Optional<String> link = Features.getLinkTarget(property);
                        if (link.isPresent()) {
                            if (direct == this.path) {
                                direct = (String[])direct.clone();
                            }
                            direct[i] = link.get();
                            property = type.getProperty(direct[i]);
                        }
                        if (property instanceof DefaultAssociationRole) {
                            type = ((DefaultAssociationRole)property).getValueType();
                            continue;
                        }
                        break block11;
                    }
                    optimization.setFeatureType(type);
                    try {
                        converted = this.accessor.optimize(optimization);
                    }
                    finally {
                        optimization.setFeatureType(specifiedType);
                    }
                    if (converted != this.accessor || direct != this.path) {
                        return new AssociationValue<V>(direct, converted);
                    }
                }
                catch (IllegalArgumentException e) {
                    this.warning(e, true);
                }
            }
        }
        return this;
    }

    @Override
    public final <N> Expression<AbstractFeature, N> toValueType(Class<N> target) {
        Expression converted = this.accessor.toValueType((Class)target);
        if (converted == this.accessor) {
            return this;
        }
        return new AssociationValue<V>(this.path, converted);
    }

    @Override
    public FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder addTo) {
        DefaultFeatureType valueType = addTo.source();
        for (String p : this.path) {
            AbstractIdentifiedType type;
            try {
                type = valueType.getProperty(p);
            }
            catch (IllegalArgumentException e) {
                if (this.accessor.isVirtual) {
                    return this.accessor.defaultType(addTo);
                }
                throw e;
            }
            if (!(type instanceof DefaultAssociationRole)) {
                return null;
            }
            valueType = ((DefaultAssociationRole)type).getValueType();
        }
        return addTo.using(valueType, this.accessor);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.path) + this.accessor.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AssociationValue) {
            AssociationValue other = (AssociationValue)obj;
            return Arrays.equals(this.path, other.path) && this.accessor.equals(other.accessor);
        }
        return false;
    }
}

