/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers.impl;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Value;
import org.osgi.util.converter.ConverterBuilder;
import org.osgi.util.converter.ConverterFunction;
import org.osgi.util.converter.TargetRule;
import org.osgi.util.converter.TypeRule;

public final class JcrRules {
    private JcrRules() {
    }

    static void addJcrRules(ConverterBuilder converterBuilder) {
        converterBuilder.rule((TargetRule)new TypeRule(Value.class, String.class, value -> {
            try {
                return value.getString();
            }
            catch (Exception e) {
                return (String)ConverterFunction.CANNOT_HANDLE;
            }
        }));
        converterBuilder.rule((TargetRule)new TypeRule(Value.class, InputStream.class, value -> {
            try {
                return value.getBinary().getStream();
            }
            catch (Exception e) {
                return (InputStream)ConverterFunction.CANNOT_HANDLE;
            }
        }));
        converterBuilder.rule((TargetRule)new TypeRule(Value.class, Binary.class, value -> {
            try {
                return value.getBinary();
            }
            catch (Exception e) {
                return (Binary)ConverterFunction.CANNOT_HANDLE;
            }
        }));
        converterBuilder.rule((TargetRule)new TypeRule(Value.class, Long.class, value -> {
            try {
                return value.getLong();
            }
            catch (Exception e) {
                return (Long)ConverterFunction.CANNOT_HANDLE;
            }
        }));
        converterBuilder.rule((TargetRule)new TypeRule(Value.class, Double.class, value -> {
            try {
                return value.getDouble();
            }
            catch (Exception e) {
                return (Double)ConverterFunction.CANNOT_HANDLE;
            }
        }));
        converterBuilder.rule((TargetRule)new TypeRule(Value.class, BigDecimal.class, value -> {
            try {
                return value.getDecimal();
            }
            catch (Exception e) {
                return (BigDecimal)ConverterFunction.CANNOT_HANDLE;
            }
        }));
        converterBuilder.rule((TargetRule)new TypeRule(Value.class, Calendar.class, value -> {
            try {
                return value.getDate();
            }
            catch (Exception e) {
                return (Calendar)ConverterFunction.CANNOT_HANDLE;
            }
        }));
        converterBuilder.rule((TargetRule)new TypeRule(Value.class, Boolean.class, value -> {
            try {
                return value.getBoolean();
            }
            catch (Exception e) {
                return (Boolean)ConverterFunction.CANNOT_HANDLE;
            }
        }));
    }
}

