/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.saml2;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.security.impl.RandomIdentifierGenerationStrategy;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;

public class Helpers {
    private static RandomIdentifierGenerationStrategy secureRandomIdGenerator;
    private static String DEFAULT_ELEMENT_NAME;

    private Helpers() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> T buildSAMLObject(Class<T> clazz) {
        XMLObject object = null;
        try {
            XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
            QName defaultElementName = (QName)clazz.getDeclaredField(DEFAULT_ELEMENT_NAME).get(null);
            object = builderFactory.getBuilder(defaultElementName).buildObject(defaultElementName);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("Could not create SAML object");
        }
        return (T)object;
    }

    public static String generateSecureRandomId() {
        return secureRandomIdGenerator.generateIdentifier();
    }

    static {
        DEFAULT_ELEMENT_NAME = "DEFAULT_ELEMENT_NAME";
        secureRandomIdGenerator = new RandomIdentifierGenerationStrategy();
    }
}

