/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl;

import java.io.IOException;
import java.util.Date;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.bgservlets.BackgroundHttpServletRequest;
import org.apache.sling.bgservlets.BackgroundHttpServletResponse;
import org.apache.sling.bgservlets.JobData;
import org.apache.sling.bgservlets.JobProgressInfo;
import org.apache.sling.bgservlets.JobStatus;
import org.apache.sling.bgservlets.JobStorage;
import org.apache.sling.bgservlets.RuntimeState;
import org.apache.sling.bgservlets.impl.SuspendableOutputStream;
import org.apache.sling.engine.SlingRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackgroundRequestExecutionJob
implements Runnable,
JobStatus,
RuntimeState,
JobProgressInfo {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HttpServletRequest request;
    private final BackgroundHttpServletResponse response;
    private final SuspendableOutputStream stream;
    private final ResourceResolver processingResourceResolver;
    private final ResourceResolver outputResourceResolver;
    private final SlingRequestProcessor slingRequestProcessor;
    private final String path;
    private final String streamPath;
    private final Date creationTime;
    private Date estimatedCompletionTime;
    private String progressMessage;

    BackgroundRequestExecutionJob(SlingRequestProcessor slingRequestProcessor, JobStorage storage, SlingHttpServletRequest request, HttpServletResponse hsr, String[] parametersToRemove) throws IOException, LoginException {
        this.request = new BackgroundHttpServletRequest((HttpServletRequest)request, parametersToRemove);
        this.slingRequestProcessor = slingRequestProcessor;
        this.request.setAttribute(RuntimeState.class.getName(), (Object)this);
        this.processingResourceResolver = request.getResourceResolver().clone(null);
        this.outputResourceResolver = request.getResourceResolver().clone(null);
        Session outputSession = (Session)this.outputResourceResolver.adaptTo(Session.class);
        if (outputSession == null) {
            throw new IOException("Unable to get Session from ResourceResolver " + this.processingResourceResolver);
        }
        JobData d = storage.createJobData(outputSession);
        String ext = request.getRequestPathInfo().getExtension();
        if (ext != null) {
            d.setProperty("sling:jobExtension", ext);
        }
        this.path = d.getPath();
        this.creationTime = d.getCreationTime();
        this.streamPath = d.getPath() + "/stream" + (ext == null ? "" : "." + ext);
        this.stream = new SuspendableOutputStream(d.getOutputStream());
        this.response = new BackgroundHttpServletResponse(hsr, this.stream);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", state=" + (Object)((Object)this.getState()) + ", path=" + this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.slingRequestProcessor.processRequest(this.request, (HttpServletResponse)this.response, this.processingResourceResolver);
        }
        catch (Exception e) {
            this.log.error("Exception in background request processing", (Throwable)e);
        }
        finally {
            try {
                this.response.cleanup();
            }
            catch (IOException ioe) {
                this.log.error("ServletResponseWrapper cleanup failed", (Throwable)ioe);
            }
            this.processingResourceResolver.close();
            this.outputResourceResolver.close();
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public JobStatus.State getState() {
        return this.stream.getState();
    }

    @Override
    public void requestStateChange(JobStatus.State s) {
        this.stream.requestStateChange(s);
    }

    @Override
    public JobStatus.State[] getAllowedHumanStateChanges() {
        return this.stream.getAllowedHumanStateChanges();
    }

    @Override
    public String getStreamPath() {
        return this.streamPath;
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    public JobProgressInfo getProgressInfo() {
        return this;
    }

    @Override
    public String getProgressMessage() {
        return this.progressMessage;
    }

    @Override
    public Date getEstimatedCompletionTime() {
        return this.estimatedCompletionTime;
    }

    @Override
    public void setEstimatedCompletionTime(Date d) {
        this.estimatedCompletionTime = d;
    }

    @Override
    public void setProgressMessage(String str) {
        this.progressMessage = str;
    }
}

