/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.clam.http.internal;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.clam.http.internal.ClamEventsServletConfiguration;
import org.apache.sling.clam.http.internal.ResponseUtil;
import org.apache.sling.clam.result.JcrPropertyScanResultHandler;
import org.apache.sling.commons.clam.ScanResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class, JcrPropertyScanResultHandler.class}, property={"service.description=Apache Sling Clam Events Servlet", "service.vendor=The Apache Software Foundation", "osgi.http.whiteboard.context.select=(osgi.http.whiteboard.context.name=org.apache.sling)", "osgi.http.whiteboard.servlet.asyncSupported=true", "osgi.http.whiteboard.servlet.pattern=/system/clam-events", "sling.auth.requirements=/system/clam-events"})
@Designate(ocd=ClamEventsServletConfiguration.class)
public class ClamEventsServlet
extends HttpServlet
implements JcrPropertyScanResultHandler {
    private final List<Client> clients = Collections.synchronizedList(new ArrayList());
    private final AtomicLong counter = new AtomicLong(0L);
    private static final String JCR_RESULT_EVENT_TYPE = "sling/clam/jcr/result";
    private final Logger logger = LoggerFactory.getLogger(ClamEventsServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("text/event-stream");
        response.addHeader("Connection", "close");
        AsyncContext context = request.startAsync();
        context.setTimeout(0L);
        Client client = new Client(context);
        context.getResponse().getOutputStream().setWriteListener((WriteListener)client);
        this.clients.add(client);
    }

    @Override
    public void handleJcrPropertyScanResult(@NotNull ScanResult scanResult, @NotNull String path, int propertyType, @Nullable String userId) {
        String data = ResponseUtil.json(scanResult, path, null, propertyType, userId);
        this.addEvent(JCR_RESULT_EVENT_TYPE, data);
    }

    @Override
    public void handleJcrPropertyScanResult(@NotNull ScanResult scanResult, @NotNull String path, int index, int propertyType, @Nullable String userId) {
        String data = ResponseUtil.json(scanResult, path, index, propertyType, userId);
        this.addEvent(JCR_RESULT_EVENT_TYPE, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(String type, String data) {
        Event event = new Event(type, data);
        List<Client> list = this.clients;
        synchronized (list) {
            this.clients.iterator().forEachRemaining(client -> ((Client)client).addEvent(event));
        }
    }

    private class Client
    implements AsyncListener,
    WriteListener {
        private final AsyncContext context;
        private final Queue<Event> events = new ConcurrentLinkedQueue<Event>();

        private Client(AsyncContext context) {
            this.context = context;
            context.addListener((AsyncListener)this);
        }

        public void onComplete(AsyncEvent event) throws IOException {
            ClamEventsServlet.this.logger.debug("on complete: {}", (Object)event.getAsyncContext());
            ClamEventsServlet.this.clients.remove(this);
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            ClamEventsServlet.this.logger.debug("on timeout: {}", (Object)event.getAsyncContext());
            ClamEventsServlet.this.clients.remove(this);
        }

        public void onError(AsyncEvent event) throws IOException {
            ClamEventsServlet.this.logger.debug("on error: {}", (Object)event.getAsyncContext());
            ClamEventsServlet.this.clients.remove(this);
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            ClamEventsServlet.this.logger.debug("on start async: {}", (Object)event.getAsyncContext());
        }

        public void onWritePossible() throws IOException {
            ServletOutputStream outputStream = this.context.getResponse().getOutputStream();
            while (outputStream.isReady() && this.events.peek() != null) {
                Event event = this.events.poll();
                String data = String.format("event: %s\ndata: %s\n\n", event.type, event.data);
                outputStream.write(data.getBytes(StandardCharsets.UTF_8));
                this.flushIfReady(outputStream);
            }
            this.flushIfReady(outputStream);
        }

        public void onError(Throwable t) {
            ClamEventsServlet.this.logger.error("on error: {}", (Object)t.getMessage(), (Object)t);
            ClamEventsServlet.this.clients.remove(this);
            this.context.complete();
        }

        private void flushIfReady(ServletOutputStream outputStream) throws IOException {
            if (outputStream.isReady()) {
                outputStream.flush();
            }
        }

        private void addEvent(Event event) {
            long count = ClamEventsServlet.this.counter.incrementAndGet();
            ClamEventsServlet.this.logger.debug("adding event: {}", (Object)count);
            this.events.add(event);
            try {
                this.onWritePossible();
            }
            catch (Exception e) {
                ClamEventsServlet.this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private class Event {
        final String type;
        final String data;

        Event(String type, String data) {
            this.type = type;
            this.data = data;
        }
    }
}

