/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.clam.http.internal;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@ObjectClassDefinition(name="Apache Sling Clam JCR Scan Servlet", description="Servlet to trigger digging JCR properties via HTTP")
@interface ClamJcrScanServletConfiguration {
    @AttributeDefinition(name="Sling servlet paths", description="Paths under which this servlet is available")
    public String[] sling_servlet_paths() default {"/system/clam-jcr-scan"};

    @AttributeDefinition(name="Sling authentication requirements", description="Additional Sling authentication requirements, defaults to Sling Clam JCR Scan Servlet path")
    public String[] sling_auth_requirements() default {"/system/clam-jcr-scan"};

    @AttributeDefinition(name="scan authorized groups", description="User groups authorized for scanning")
    public String[] scan_authorized_groups() default {};

    @AttributeDefinition(name="default property types", description="Type of properties", options={@Option(label="Binary", value="Binary"), @Option(label="String", value="String")})
    public String[] digger_default_property_types() default {"Binary"};

    @AttributeDefinition(name="default property path pattern", description="Pattern a property path has to match, e.g. '^/content/.*/jcr:content/jcr:data$'")
    public String digger_default_property_path_pattern() default "^/.*$";

    @AttributeDefinition(name="default property length max", description="Max length of property value to scan, -1 for unlimited length. Scanning data greater 4GB may result in errors due to limitations in Clam.")
    public long digger_default_property_length_max() default -1L;

    @AttributeDefinition(name="default node depth max", description="Max depth of nodes below given path to scan, -1 for unlimited depth.")
    public int digger_default_node_depth_max() default -1;
}

