/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.messaging.mail.internal;

import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.event.ConnectionListener;
import jakarta.mail.event.TransportListener;
import jakarta.mail.internet.MimeMessage;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.sling.commons.crypto.CryptoService;
import org.apache.sling.commons.messaging.MessageService;
import org.apache.sling.commons.messaging.mail.MailService;
import org.apache.sling.commons.messaging.mail.MessageBuilder;
import org.apache.sling.commons.messaging.mail.MessageIdProvider;
import org.apache.sling.commons.messaging.mail.internal.SimpleMailServiceConfiguration;
import org.apache.sling.commons.messaging.mail.internal.SimpleMessageBuilder;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={MessageService.class, MailService.class}, property={"service.description=Apache Sling Commons Messaging Mail \u2013 Simple Mail Service", "service.vendor=The Apache Software Foundation", "protocol=SMTPS"})
@Designate(ocd=SimpleMailServiceConfiguration.class, factory=true)
public final class SimpleMailService
implements MailService {
    private static final String SMTPS_PROTOCOL = "smtps";
    private static final String MAIL_SMTPS_FROM = "mail.smtps.from";
    private static final String MAIL_SMTPS_SSL_CHECKSERVERIDENTITY = "mail.smtps.ssl.checkserveridentity";
    private static final String MESSAGE_ID_HEADER = "Message-ID";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile MessageIdProvider messageIdProvider;
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ThreadPoolManager threadPoolManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CryptoService cryptoService;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile List<ConnectionListener> connectionListeners;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile List<TransportListener> transportListeners;
    private ThreadPool threadPool;
    private SimpleMailServiceConfiguration configuration;
    private Properties properties;
    private final Logger logger = LoggerFactory.getLogger(SimpleMailService.class);

    @Activate
    private void activate(SimpleMailServiceConfiguration configuration) {
        this.logger.debug("activating");
        this.configuration = configuration;
        this.configure(configuration);
    }

    @Modified
    private void modified(SimpleMailServiceConfiguration configuration) {
        this.logger.debug("modifying");
        this.configuration = configuration;
        this.configure(configuration);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
        this.configuration = null;
        this.threadPoolManager.release(this.threadPool);
        this.threadPool = null;
        this.properties = null;
    }

    private void configure(SimpleMailServiceConfiguration configuration) {
        this.threadPoolManager.release(this.threadPool);
        this.threadPool = this.threadPoolManager.get(configuration.threadpool_name());
        Properties properties = new Properties();
        properties.setProperty(MAIL_SMTPS_SSL_CHECKSERVERIDENTITY, Boolean.toString(configuration.mail_smtps_ssl_checkserveridentity()));
        String from = configuration.mail_smtps_from();
        if (Objects.nonNull(from) && !from.isBlank()) {
            properties.setProperty(MAIL_SMTPS_FROM, from.trim());
        }
        this.properties = properties;
    }

    @Override
    @NotNull
    public MessageBuilder getMessageBuilder() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.properties);
        Session session = Session.getInstance((Properties)properties);
        return new SimpleMessageBuilder(session);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> sendMessage(@NotNull MimeMessage message) {
        ThreadPool threadPool = this.threadPool;
        Objects.requireNonNull(threadPool, "Thread pool must not be null");
        return CompletableFuture.runAsync(() -> this.send(message), runnable -> threadPool.submit(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(@NotNull MimeMessage message) {
        SimpleMailServiceConfiguration configuration = this.configuration;
        Objects.requireNonNull(configuration, "Configuration must not be null");
        CryptoService cryptoService = this.cryptoService;
        Objects.requireNonNull(cryptoService, "Crypto service must not be null");
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            String password = cryptoService.decrypt(configuration.password());
            try (Transport transport = message.getSession().getTransport(SMTPS_PROTOCOL);){
                List<ConnectionListener> connectionListeners = this.connectionListeners;
                connectionListeners.forEach(arg_0 -> ((Transport)transport).addConnectionListener(arg_0));
                List<TransportListener> transportListeners = this.transportListeners;
                transportListeners.forEach(arg_0 -> ((Transport)transport).addTransportListener(arg_0));
                transport.connect(configuration.mail_smtps_host(), configuration.mail_smtps_port(), configuration.username(), password);
                message.saveChanges();
                MessageIdProvider messageIdProvider = this.messageIdProvider;
                if (messageIdProvider != null) {
                    String messageId = messageIdProvider.getMessageId(message);
                    message.setHeader(MESSAGE_ID_HEADER, String.format("<%s>", messageId));
                }
                this.logger.debug("sending message '{}'", (Object)message.getMessageID());
                transport.sendMessage((Message)message, message.getAllRecipients());
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        catch (MessagingException e) {
            throw new CompletionException(e);
        }
    }
}

