/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.core.commands;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.felix.SHADED.cm.file.ConfigurationHandler;
import org.apache.sling.crankstart.api.CrankstartCommand;
import org.apache.sling.crankstart.api.CrankstartCommandLine;
import org.apache.sling.crankstart.api.CrankstartContext;
import org.apache.sling.crankstart.api.CrankstartException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configure
implements CrankstartCommand {
    public static final String I_CONFIGURE = "config";
    public static final String FACTORY_SUFFIX = ".factory";
    public static final String FELIX_FORMAT_SUFFIX = "FORMAT:felix.config";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String CRANKSTART_CONFIG_ID = "CRANKSTART_CONFIG_ID";

    public boolean appliesTo(CrankstartCommandLine commandLine) {
        return commandLine.getVerb().startsWith(I_CONFIGURE);
    }

    public String getDescription() {
        return "config or config.factory: create OSGi configurations";
    }

    public void execute(CrankstartContext crankstartContext, CrankstartCommandLine commandLine) throws Exception {
        String pid = null;
        boolean felixFormat = false;
        if (commandLine.getQualifier().endsWith(FELIX_FORMAT_SUFFIX)) {
            felixFormat = true;
            pid = commandLine.getQualifier().split(" ")[0].trim();
        } else {
            pid = commandLine.getQualifier();
        }
        Dictionary<String, Object> properties = commandLine.getProperties();
        if (felixFormat) {
            properties = this.parseFelixConfig(properties);
        }
        BundleContext bundleContext = crankstartContext.getOsgiFramework().getBundleContext();
        String CONFIG_ADMIN_CLASS = "org.osgi.service.cm.ConfigurationAdmin";
        ServiceReference configAdminRef = bundleContext.getServiceReference("org.osgi.service.cm.ConfigurationAdmin");
        if (configAdminRef == null) {
            throw new IllegalStateException("Required service is missing:org.osgi.service.cm.ConfigurationAdmin");
        }
        Object configAdminService = bundleContext.getService(configAdminRef);
        Object config = null;
        if (commandLine.getVerb().endsWith(FACTORY_SUFFIX)) {
            config = this.getExistingConfig(configAdminService, pid, properties);
            if (config == null) {
                config = configAdminService.getClass().getMethod("createFactoryConfiguration", String.class).invoke(configAdminService, pid);
            }
        } else {
            config = configAdminService.getClass().getMethod("getConfiguration", String.class).invoke(configAdminService, pid);
        }
        config.getClass().getMethod("setBundleLocation", String.class).invoke(config, new Object[]{null});
        config.getClass().getMethod("update", Dictionary.class).invoke(config, properties);
        this.log.info("Updated configuration {}: {}", (Object)pid, properties);
    }

    Object getExistingConfig(Object configAdminService, String factoryPid, Dictionary<String, Object> properties) throws Exception {
        Object o = properties.get(CRANKSTART_CONFIG_ID);
        if (o == null || !(o instanceof String)) {
            this.log.info("Factory config does not specify {}, might be created multiple times", (Object)CRANKSTART_CONFIG_ID);
            return null;
        }
        String id = (String)o;
        String filter = "(&(service.factoryPid=" + factoryPid + ")(" + CRANKSTART_CONFIG_ID + "=" + id + "))";
        Object[] c = (Object[])configAdminService.getClass().getMethod("listConfigurations", String.class).invoke(configAdminService, filter);
        Object result = null;
        if (c != null && c.length > 0) {
            if (c.length > 1) {
                throw new CrankstartException("Found " + c.length + " configs with " + CRANKSTART_CONFIG_ID + "=" + id);
            }
            result = c[0];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary<String, Object> parseFelixConfig(Dictionary<String, Object> properties) {
        Dictionary dictionary;
        if (properties == null) {
            return new Hashtable<String, Object>();
        }
        StringBuilder sb = new StringBuilder();
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object value = properties.get(key);
            sb.append(key).append("=").append(value).append("\n");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
        try {
            dictionary = ConfigurationHandler.read(is);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new CrankstartException("Parsing error (Felix format config) for\n" + sb, (Throwable)ioe);
            }
        }
        ((InputStream)is).close();
        return dictionary;
    }
}

